/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.codemanipulation;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.text.edits.TextEdit;

public class GenerateGetterSetterOperation {
    private static final int generateVisibility = 1;
    private final IType type;
    private CompilationUnit astRoot;
    private boolean generateComments = true;
    private IJavaElement insertPosition = null;

    public GenerateGetterSetterOperation(IType type, CompilationUnit astRoot, boolean generateComments) {
        this(type, astRoot, generateComments, null);
    }

    public GenerateGetterSetterOperation(IType type, CompilationUnit astRoot, boolean generateComments, IJavaElement insertPosition) {
        Assert.isNotNull((Object)type);
        this.type = type;
        this.astRoot = astRoot;
        this.generateComments = generateComments;
        this.insertPosition = insertPosition;
    }

    public static boolean supportsGetterSetter(IType type) throws JavaModelException {
        return type != null && !type.isAnnotation() && !type.isInterface() && type.getCompilationUnit() != null;
    }

    public static AccessorField[] getUnimplementedAccessors(IType type, AccessorKind kind) throws JavaModelException {
        IField[] fields;
        if (!GenerateGetterSetterOperation.supportsGetterSetter(type)) {
            return new AccessorField[0];
        }
        ArrayList<AccessorField> unimplemented = new ArrayList<AccessorField>();
        IField[] iFieldArray = fields = type.isRecord() ? type.getRecordComponents() : type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            int flags = field.getFlags();
            if (!Flags.isEnum((int)flags)) {
                boolean isStatic = Flags.isStatic((int)flags);
                boolean generateGetter = GetterSetterUtil.getGetter((IField)field) == null;
                boolean generateSetter = !Flags.isFinal((int)flags) && GetterSetterUtil.getSetter((IField)field) == null;
                switch (kind) {
                    case BOTH: {
                        if (!generateGetter && !generateSetter) break;
                        unimplemented.add(new AccessorField(field.getElementName(), isStatic, generateGetter, generateSetter, Signature.getSignatureSimpleName((String)field.getTypeSignature())));
                        break;
                    }
                    case GETTER: {
                        if (!generateGetter) break;
                        unimplemented.add(new AccessorField(field.getElementName(), isStatic, generateGetter, false, Signature.getSignatureSimpleName((String)field.getTypeSignature())));
                        break;
                    }
                    case SETTER: {
                        if (!generateSetter) break;
                        unimplemented.add(new AccessorField(field.getElementName(), isStatic, false, generateSetter, Signature.getSignatureSimpleName((String)field.getTypeSignature())));
                        break;
                    }
                }
            }
            ++n2;
        }
        return unimplemented.toArray(new AccessorField[0]);
    }

    public TextEdit createTextEdit(AccessorKind kind, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        AccessorField[] accessors = GenerateGetterSetterOperation.getUnimplementedAccessors(this.type, kind);
        return this.createTextEdit(monitor, accessors);
    }

    public TextEdit createTextEdit(IProgressMonitor monitor, AccessorField[] accessors) throws OperationCanceledException, CoreException {
        if (accessors == null || accessors.length == 0) {
            return null;
        }
        ICompilationUnit unit = this.type.getCompilationUnit();
        if (this.astRoot == null) {
            this.astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
        }
        if (this.astRoot == null) {
            return null;
        }
        ASTRewrite astRewrite = ASTRewrite.create((AST)this.astRoot.getAST());
        ListRewrite listRewriter = null;
        if (this.type.isAnonymous()) {
            AnonymousClassDeclaration declaration;
            ClassInstanceCreation creation = (ClassInstanceCreation)ASTNodes.getParent((ASTNode)NodeFinder.perform((ASTNode)this.astRoot, (ISourceRange)this.type.getNameRange()), ClassInstanceCreation.class);
            if (creation != null && (declaration = creation.getAnonymousClassDeclaration()) != null) {
                listRewriter = astRewrite.getListRewrite((ASTNode)declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            }
        } else {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)NodeFinder.perform((ASTNode)this.astRoot, (ISourceRange)this.type.getNameRange()), AbstractTypeDeclaration.class);
            if (declaration != null) {
                listRewriter = astRewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
            }
        }
        if (listRewriter == null) {
            return null;
        }
        ASTNode insertion = StubUtility2Core.getNodeToInsertBefore(listRewriter, (IJavaElement)this.insertPosition);
        AccessorField[] accessorFieldArray = accessors;
        int n = accessors.length;
        int n2 = 0;
        while (n2 < n) {
            AccessorField accessor = accessorFieldArray[n2];
            this.generateGetterSetterMethods(listRewriter, accessor, insertion);
            ++n2;
        }
        return astRewrite.rewriteAST();
    }

    private void generateGetterSetterMethods(ListRewrite listRewriter, AccessorField accessor, ASTNode insertion) throws OperationCanceledException, CoreException {
        IField field = this.type.getField(accessor.fieldName);
        if (field == null) {
            return;
        }
        if (accessor.generateGetter && GetterSetterUtil.getGetter((IField)field) == null) {
            this.insertMethod(field, listRewriter, AccessorKind.GETTER, insertion);
        }
        if (accessor.generateSetter && GetterSetterUtil.getSetter((IField)field) == null) {
            this.insertMethod(field, listRewriter, AccessorKind.SETTER, insertion);
        }
    }

    private void insertMethod(IField field, ListRewrite rewrite, AccessorKind kind, ASTNode insertion) throws CoreException {
        String stub;
        IType type = field.getDeclaringType();
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)type);
        int flags = 1 | field.getFlags() & 8;
        if (kind == AccessorKind.GETTER) {
            name = GetterSetterUtil.getGetterName((IField)field, null);
            stub = GetterSetterUtil.getGetterStub((IField)field, (String)name, (boolean)this.generateComments, (int)flags);
        } else {
            name = GetterSetterUtil.getSetterName((IField)field, null);
            stub = GetterSetterUtil.getSetterStub((IField)field, (String)name, (boolean)this.generateComments, (int)flags);
        }
        Map options = type.getCompilationUnit() != null ? type.getCompilationUnit().getOptions(true) : type.getJavaProject().getOptions(true);
        String formattedStub = CodeFormatterUtil.format((int)4, (String)stub, (int)0, (String)delimiter, (Map)options);
        MethodDeclaration declaration = (MethodDeclaration)rewrite.getASTRewrite().createStringPlaceholder(formattedStub, 31);
        if (insertion != null) {
            rewrite.insertBefore((ASTNode)declaration, insertion, null);
        } else {
            rewrite.insertLast((ASTNode)declaration, null);
        }
    }

    public static class AccessorField {
        public String fieldName;
        public boolean isStatic;
        public boolean generateGetter;
        public boolean generateSetter;
        public String typeName;

        public AccessorField(String fieldName, boolean isStatic, boolean generateGetter, boolean generateSetter, String typeName) {
            this.fieldName = fieldName;
            this.isStatic = isStatic;
            this.generateGetter = generateGetter;
            this.generateSetter = generateSetter;
            this.typeName = typeName;
        }
    }

    public static enum AccessorKind {
        GETTER,
        SETTER,
        BOTH;

    }
}

