/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryWithResourcesAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SurroundWithTryWithResourcesRefactoringCore
extends Refactoring {
    public static final String GROUP_EXC_TYPE = "exc_type";
    public static final String GROUP_EXC_NAME = "exc_name";
    public static final String GROUP_TRY_STATEMENT = "try_stmt";
    private Selection fSelection;
    private SurroundWithTryWithResourcesAnalyzer fAnalyzer;
    private boolean fLeaveDirty;
    private ICompilationUnit fCUnit;
    private CompilationUnit fRootNode;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private CodeScopeBuilder.Scope fScope;
    private ASTNode[] fSelectedNodes;
    private List<ASTNode> fAutoClosableNodes;
    private LinkedProposalModelCore fLinkedProposalModel;

    protected SurroundWithTryWithResourcesRefactoringCore(ICompilationUnit cu, Selection selection) {
        this.fCUnit = cu;
        this.fSelection = selection;
        this.fLeaveDirty = false;
    }

    public static SurroundWithTryWithResourcesRefactoringCore create(ICompilationUnit cu, int offset, int length) {
        return new SurroundWithTryWithResourcesRefactoringCore(cu, Selection.createFromStartLength(offset, length));
    }

    public static SurroundWithTryWithResourcesRefactoringCore create(ICompilationUnit cu, Selection selection) {
        return new SurroundWithTryWithResourcesRefactoringCore(cu, selection);
    }

    public LinkedProposalModelCore getLinkedProposalModelCore() {
        return this.fLinkedProposalModel;
    }

    public void setLeaveDirty(boolean leaveDirty) {
        this.fLeaveDirty = leaveDirty;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions(this.fAnalyzer.getSelection());
        List<ASTNode> autoClosableNodes = this.fAnalyzer.getCoveredAutoClosableNodes();
        return !(exceptions != null && exceptions.length != 0 || autoClosableNodes != null && !autoClosableNodes.isEmpty());
    }

    public String getName() {
        return RefactoringCoreMessages.SurroundWithTryWithResourcesRefactoring_name;
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fRootNode = rootNode;
        this.fAnalyzer = new SurroundWithTryWithResourcesAnalyzer(this.fCUnit, this.fSelection);
        this.fRootNode.accept((ASTVisitor)this.fAnalyzer);
        result.merge(this.fAnalyzer.getStatus());
        this.fAutoClosableNodes = this.fAnalyzer.getCoveredAutoClosableNodes();
        if (this.fAutoClosableNodes == null || this.fAutoClosableNodes.isEmpty()) {
            result.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.SurroundWithTryWithResourcesRefactoring_notAutoclosable));
        }
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        CompilationUnit rootNode = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)this.fCUnit, true, pm);
        return this.checkActivationBasics(rootNode);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        return Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit}), this.getValidationContext(), pm);
    }

    protected LinkedProposalModelCore createLinkedProposalModel() {
        return new LinkedProposalModelCore();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 2);
        try {
            CompilationUnitChange result = new CompilationUnitChange(this.getName(), this.fCUnit);
            if (this.fLeaveDirty) {
                result.setSaveMode(4);
            }
            MultiTextEdit root = new MultiTextEdit();
            result.setEdit((TextEdit)root);
            this.fRewriter = ASTRewrite.create((AST)this.fAnalyzer.getEnclosingBodyDeclaration().getAST());
            this.fImportRewrite = StubUtility.createImportRewrite(this.fRootNode, true);
            this.fLinkedProposalModel = this.createLinkedProposalModel();
            BodyDeclaration enclosingBodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
            Selection ignoreSelection = Selection.createFromStartEnd(this.fSelection.getOffset(), enclosingBodyDeclaration.getStartPosition() + enclosingBodyDeclaration.getLength());
            this.fScope = CodeScopeBuilder.perform(enclosingBodyDeclaration, ignoreSelection).findScope(this.fSelection.getOffset(), this.fSelection.getLength());
            this.fScope.setCursor(this.fSelection.getOffset());
            this.fSelectedNodes = this.fAnalyzer.getSelectedNodes();
            this.createTryWithResourcesStatement(this.fCUnit.getBuffer(), this.fCUnit.findRecommendedLineSeparator());
            if (this.fImportRewrite.hasRecordedChanges()) {
                TextEdit edit = this.fImportRewrite.rewriteImports(null);
                root.addChild(edit);
                result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{edit}));
            }
            TextEdit change = this.fRewriter.rewriteAST();
            root.addChild(change);
            result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{change}));
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private AST getAST() {
        return this.fRootNode.getAST();
    }

    /*
     * WARNING - void declaration
     */
    private void createTryWithResourcesStatement(IBuffer buffer, String lineDelimiter) throws CoreException {
        block53: {
            void var30_77;
            int index;
            List<Object> nodesInRange;
            ASTNode replacementNode;
            ListRewrite statements;
            block54: {
                TryStatement enclosingTry;
                boolean modifyExistingTry;
                block52: {
                    Assignment assignment;
                    Type type;
                    ArrayList<Object> result = new ArrayList<Object>(1);
                    modifyExistingTry = false;
                    TryStatement tryStatement = null;
                    ITypeBinding[] exceptions = this.fAnalyzer.getExceptions(this.fAnalyzer.getSelection());
                    ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration(), this.fImportRewrite);
                    enclosingTry = (TryStatement)ASTResolving.findAncestor(this.fSelectedNodes[0], 54);
                    ListRewrite resourcesRewriter = null;
                    ListRewrite clausesRewriter = null;
                    statements = null;
                    if (enclosingTry == null || enclosingTry.getBody() == null || enclosingTry.getBody().statements().get(0) != this.fSelectedNodes[0]) {
                        tryStatement = this.getAST().newTryStatement();
                        statements = this.fRewriter.getListRewrite((ASTNode)tryStatement.getBody(), Block.STATEMENTS_PROPERTY);
                    } else {
                        modifyExistingTry = true;
                        resourcesRewriter = this.fRewriter.getListRewrite((ASTNode)enclosingTry, TryStatement.RESOURCES2_PROPERTY);
                        clausesRewriter = this.fRewriter.getListRewrite((ASTNode)enclosingTry, TryStatement.CATCH_CLAUSES_PROPERTY);
                    }
                    CatchClause catchClause = this.getAST().newCatchClause();
                    SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
                    String varName = StubUtility.getExceptionVariableName(this.fCUnit.getJavaProject());
                    String name = this.fScope.createName(varName, false);
                    decl.setName(this.getAST().newSimpleName(name));
                    boolean selectedNodeRemoved = false;
                    ASTNode expressionStatement = null;
                    replacementNode = null;
                    nodesInRange = new ArrayList();
                    if (!modifyExistingTry) {
                        ASTNode[] statement;
                        ASTNode node;
                        List<ASTNode> variableDeclarations = this.getSpecialVariableDeclarationStatements();
                        ASTNode[] aSTNodeArray = this.fSelectedNodes;
                        int n = this.fSelectedNodes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            node = aSTNodeArray[n2];
                            if (!this.fAutoClosableNodes.contains(node) && node instanceof VariableDeclarationStatement && variableDeclarations.contains(node)) {
                                Object typeName;
                                CompilationUnit compilationUnit;
                                int extendedStart;
                                ITypeBinding iTypeBinding;
                                AST ast = this.getAST();
                                statement = (ASTNode[])node;
                                VariableDeclarationStatement copy = (VariableDeclarationStatement)ASTNode.copySubtree((AST)ast, (ASTNode)statement);
                                List modifiers = copy.modifiers();
                                Iterator iter = modifiers.iterator();
                                while (iter.hasNext()) {
                                    IExtendedModifier iExtendedModifier = (IExtendedModifier)iter.next();
                                    if (!iExtendedModifier.isModifier() || !Modifier.isFinal((int)((Modifier)iExtendedModifier).getKeyword().toFlagValue())) continue;
                                    iter.remove();
                                }
                                Object fragments = copy.fragments();
                                Iterator iterator = fragments.iterator();
                                while (iterator.hasNext()) {
                                    VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
                                    variableDeclarationFragment.setInitializer(null);
                                }
                                if (ASTNodes.isVarType((ASTNode)statement, this.fRootNode) && (iTypeBinding = statement.getType().resolveBinding()) != null) {
                                    Type varType = this.fImportRewrite.addImport(iTypeBinding, this.getAST(), (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
                                    copy.setType(varType);
                                }
                                if ((extendedStart = (compilationUnit = (CompilationUnit)statement.getRoot()).getExtendedStartPosition((ASTNode)statement)) != statement.getStartPosition() && extendedStart >= this.fSelection.getOffset()) {
                                    String commentToken = buffer.getText(extendedStart, statement.getStartPosition() - extendedStart);
                                    commentToken = Strings.trimTrailingTabsAndSpaces(commentToken);
                                    type = statement.getType();
                                    typeName = buffer.getText(type.getStartPosition(), type.getLength());
                                    copy.setType((Type)this.fRewriter.createStringPlaceholder(commentToken + (String)typeName, type.getNodeType()));
                                }
                                result.add(copy);
                                fragments = statement.fragments();
                                if (!fragments.isEmpty()) {
                                    ArrayList<ExpressionStatement> newExpressionStatements = new ArrayList<ExpressionStatement>();
                                    typeName = fragments.iterator();
                                    while (typeName.hasNext()) {
                                        VariableDeclarationFragment fragment = (VariableDeclarationFragment)typeName.next();
                                        Expression initializer = fragment.getInitializer();
                                        if (initializer == null) continue;
                                        assignment = ast.newAssignment();
                                        assignment.setLeftHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)fragment.getName()));
                                        assignment.setRightHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)initializer));
                                        newExpressionStatements.add(ast.newExpressionStatement((Expression)assignment));
                                    }
                                    if (!newExpressionStatements.isEmpty()) {
                                        if (this.fSelectedNodes.length == 1) {
                                            expressionStatement = this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()]));
                                        } else {
                                            this.fRewriter.replace((ASTNode)statement, this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()])), null);
                                        }
                                    } else {
                                        this.fRewriter.remove((ASTNode)statement, null);
                                        selectedNodeRemoved = true;
                                    }
                                } else {
                                    this.fRewriter.remove((ASTNode)statement, null);
                                    selectedNodeRemoved = true;
                                }
                            }
                            ++n2;
                        }
                        result.add(tryStatement);
                        replacementNode = result.size() == 1 ? (ASTNode)result.get(0) : this.fRewriter.createGroupNode(result.toArray(new ASTNode[result.size()]));
                        node = this.fSelectedNodes[0];
                        ArrayList<Statement> coveredStatements = new ArrayList<Statement>();
                        statement = this.fSelectedNodes;
                        int ast = this.fSelectedNodes.length;
                        int n3 = 0;
                        while (n3 < ast) {
                            ASTNode coveredNode = statement[n3];
                            Statement statement2 = ASTResolving.findParentStatement(coveredNode);
                            if (statement2 != null && !coveredStatements.contains(statement2)) {
                                coveredStatements.add(statement2);
                            }
                            ++n3;
                        }
                        Selection nodesInRangeSelection = this.fAnalyzer.getSelection();
                        if (!this.fAutoClosableNodes.isEmpty()) {
                            ASTNode parentBodyDeclaration = node instanceof Block || node instanceof BodyDeclaration ? node : ASTNodes.getFirstAncestorOrNull(node, Block.class, BodyDeclaration.class);
                            int start = this.fAutoClosableNodes.get(0).getStartPosition();
                            ASTNode lastSelectedNode = this.fSelectedNodes[this.fSelectedNodes.length - 1];
                            int end = lastSelectedNode.getStartPosition() + lastSelectedNode.getLength();
                            for (ASTNode astNode : this.fAutoClosableNodes) {
                                int n4 = this.findEndPosition(astNode);
                                end = Math.max(end, n4);
                            }
                            nodesInRange = SurroundWithTryWithResourcesRefactoringCore.findNodesInRange(parentBodyDeclaration, start, end);
                            int oldEnd = end;
                            int newEnd = end;
                            while (true) {
                                newEnd = oldEnd;
                                for (ASTNode aSTNode : nodesInRange) {
                                    int endPosition = this.findEndPosition(aSTNode);
                                    newEnd = Math.max(newEnd, endPosition);
                                }
                                if (newEnd <= oldEnd) break;
                                oldEnd = newEnd;
                                nodesInRange = SurroundWithTryWithResourcesRefactoringCore.findNodesInRange(parentBodyDeclaration, start, newEnd);
                            }
                            if (nodesInRange.size() > 0) {
                                ASTNode aSTNode = (ASTNode)nodesInRange.get(nodesInRange.size() - 1);
                                nodesInRangeSelection = Selection.createFromStartEnd(start, aSTNode.getStartPosition() + aSTNode.getLength());
                                exceptions = this.fAnalyzer.getExceptions(nodesInRangeSelection);
                            }
                            nodesInRange.removeAll(this.fAutoClosableNodes);
                            nodesInRange.removeAll(Arrays.asList(this.fSelectedNodes));
                        }
                    }
                    CompilationUnit cu = (CompilationUnit)this.fSelectedNodes[0].getRoot();
                    AST ast = this.fSelectedNodes[0].getAST();
                    HashSet<String> resourceNameList = new HashSet<String>();
                    ArrayList<ITypeBinding> allExceptions = new ArrayList<ITypeBinding>(Arrays.asList(exceptions));
                    for (ASTNode coveredNode : this.fAutoClosableNodes) {
                        IMethodBinding close;
                        Type type2;
                        ITypeBinding typeBinding;
                        ASTNode findAncestor = ASTResolving.findAncestor(coveredNode, 60);
                        if (findAncestor == null) {
                            findAncestor = ASTResolving.findAncestor(coveredNode, 7);
                        }
                        if (!(findAncestor instanceof VariableDeclarationStatement)) continue;
                        VariableDeclarationStatement vds = (VariableDeclarationStatement)findAncestor;
                        Object commentToken = null;
                        int extendedStatementStart = cu.getExtendedStartPosition((ASTNode)vds);
                        if (vds.getStartPosition() > extendedStatementStart) {
                            commentToken = buffer.getText(extendedStatementStart, vds.getStartPosition() - extendedStatementStart);
                        }
                        if ((typeBinding = (type2 = vds.getType()).resolveBinding()) != null && (close = SurroundWithTryWithResourcesRefactoringCore.findAutocloseMethod(typeBinding)) != null) {
                            assignment = close.getExceptionTypes();
                            int initializer = ((ITypeBinding[])assignment).length;
                            int typeName = 0;
                            while (typeName < initializer) {
                                ITypeBinding exceptionType = assignment[typeName];
                                if (!allExceptions.contains(exceptionType)) {
                                    allExceptions.add(exceptionType);
                                }
                                ++typeName;
                            }
                        }
                        String typeName = buffer.getText(type2.getStartPosition(), type2.getLength());
                        for (Object object : vds.fragments()) {
                            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)object;
                            VariableDeclarationFragment newVariableDeclarationFragment = ast.newVariableDeclarationFragment();
                            SimpleName vdsName = variableDeclarationFragment.getName();
                            if (commentToken == null) {
                                int extendedStart = cu.getExtendedStartPosition((ASTNode)variableDeclarationFragment);
                                commentToken = buffer.getText(extendedStart, variableDeclarationFragment.getStartPosition() - extendedStart);
                            }
                            commentToken = (String)commentToken + (((String)(commentToken = Strings.trimTrailingTabsAndSpaces((String)commentToken))).isEmpty() ? "" : " ");
                            newVariableDeclarationFragment.setName(ast.newSimpleName(vdsName.getIdentifier()));
                            Expression newExpression = null;
                            Expression initializer = variableDeclarationFragment.getInitializer();
                            if (initializer == null) {
                                this.fRewriter.remove(coveredNode, null);
                                continue;
                            }
                            newExpression = (Expression)this.fRewriter.createMoveTarget((ASTNode)initializer);
                            resourceNameList.add(vdsName.getIdentifier());
                            newVariableDeclarationFragment.setInitializer(newExpression);
                            VariableDeclarationExpression newVariableDeclarationExpression = ast.newVariableDeclarationExpression(newVariableDeclarationFragment);
                            newVariableDeclarationExpression.setType((Type)this.fRewriter.createStringPlaceholder((String)commentToken + typeName, type2.getNodeType()));
                            if (modifyExistingTry) {
                                if (enclosingTry.resources().isEmpty()) {
                                    resourcesRewriter.insertFirst((ASTNode)newVariableDeclarationExpression, null);
                                } else {
                                    resourcesRewriter.insertLast((ASTNode)newVariableDeclarationExpression, null);
                                }
                            } else {
                                tryStatement.resources().add(newVariableDeclarationExpression);
                            }
                            commentToken = null;
                        }
                    }
                    ArrayList<ITypeBinding> mustRethrowList = new ArrayList<ITypeBinding>();
                    List<ITypeBinding> catchExceptions = this.fAnalyzer.calculateCatchesAndRethrows(ASTNodes.filterSubtypes(allExceptions), mustRethrowList);
                    List<ITypeBinding> filteredExceptions = ASTNodes.filterSubtypes(catchExceptions);
                    if (catchExceptions.size() > 0) {
                        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
                        int i = 0;
                        if (!modifyExistingTry) {
                            for (ITypeBinding mustThrow : mustRethrowList) {
                                CatchClause newClause = ast.newCatchClause();
                                SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
                                newDecl.setName(ast.newSimpleName(name));
                                Type importType = this.fImportRewrite.addImport(mustThrow, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                                newDecl.setType(importType);
                                newClause.setException(newDecl);
                                ThrowStatement newThrowStatement = ast.newThrowStatement();
                                newThrowStatement.setExpression((Expression)ast.newSimpleName(name));
                                linkedProposalModel.getPositionGroup(GROUP_EXC_NAME + i, true).addPosition(this.fRewriter.track((ASTNode)decl.getName()), false);
                                newClause.getBody().statements().add(newThrowStatement);
                                tryStatement.catchClauses().add(newClause);
                                ++i;
                            }
                        }
                        UnionType unionType = this.getAST().newUnionType();
                        List list = unionType.types();
                        for (ITypeBinding exception : filteredExceptions) {
                            type = this.fImportRewrite.addImport(exception, this.getAST(), (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                            list.add(type);
                            this.fLinkedProposalModel.getPositionGroup(GROUP_EXC_TYPE + i, true).addPosition(this.fRewriter.track((ASTNode)type), i == 0);
                            ++i;
                        }
                        decl.setType((Type)unionType);
                        catchClause.setException(decl);
                        this.fLinkedProposalModel.getPositionGroup("exc_name0", true).addPosition(this.fRewriter.track((ASTNode)decl.getName()), false);
                        Statement st = this.getCatchBody("Exception", name, lineDelimiter);
                        if (st != null) {
                            catchClause.getBody().statements().add(st);
                        }
                        if (modifyExistingTry) {
                            clausesRewriter.insertLast((ASTNode)catchClause, null);
                        } else {
                            tryStatement.catchClauses().add(catchClause);
                        }
                    }
                    if (this.fSelectedNodes.length != 1 || !this.fAutoClosableNodes.isEmpty()) break block52;
                    ASTNode selectedNode = this.fSelectedNodes[0];
                    if (selectedNode instanceof MethodReference) {
                        MethodReference methodReference = (MethodReference)selectedNode;
                        IMethodBinding functionalMethod = QuickAssistProcessorUtil.getFunctionalMethodForMethodReference(methodReference);
                        Assert.isTrue((functionalMethod != null && !functionalMethod.isGenericMethod() ? 1 : 0) != 0);
                        LambdaExpression lambdaExpression = QuickAssistProcessorUtil.convertMethodRefernceToLambda(methodReference, functionalMethod, this.fRootNode, this.fRewriter, null, true);
                        ASTNode statementInBlock = (ASTNode)((Block)lambdaExpression.getBody()).statements().get(0);
                        this.fRewriter.replace(statementInBlock, replacementNode, null);
                        statements.insertLast(statementInBlock, null);
                        return;
                    }
                    LambdaExpression enclosingLambda = ASTResolving.findEnclosingLambdaExpression(selectedNode);
                    if (enclosingLambda != null && selectedNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY && enclosingLambda.resolveMethodBinding() != null) {
                        QuickAssistProcessorUtil.changeLambdaBodyToBlock(enclosingLambda, this.getAST(), this.fRewriter);
                        Block blockBody = (Block)this.fRewriter.get((ASTNode)enclosingLambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY);
                        ASTNode aSTNode = (ASTNode)blockBody.statements().get(0);
                        this.fRewriter.replace(aSTNode, replacementNode, null);
                        statements.insertLast(aSTNode, null);
                        return;
                    }
                    if (expressionStatement != null) {
                        statements.insertLast(expressionStatement, null);
                    } else if (!selectedNodeRemoved) {
                        statements.insertLast(this.fRewriter.createMoveTarget(selectedNode), null);
                    }
                    this.fRewriter.replace(selectedNode, replacementNode, null);
                    break block53;
                }
                if (!modifyExistingTry) break block54;
                ListRewrite source = this.fRewriter.getListRewrite((ASTNode)enclosingTry.getBody(), Block.STATEMENTS_PROPERTY);
                for (ASTNode node : this.fAutoClosableNodes) {
                    source.remove(node, null);
                }
                break block53;
            }
            ListRewrite source = this.fRewriter.getListRewrite(this.fSelectedNodes[0].getParent(), (ChildListPropertyDescriptor)this.fSelectedNodes[0].getLocationInParent());
            ArrayList<ASTNode> nodes = new ArrayList<ASTNode>(Arrays.asList(this.fSelectedNodes));
            if (!nodesInRange.isEmpty()) {
                nodes.addAll(nodesInRange);
            }
            if ((index = this.fAutoClosableNodes.size()) < nodes.size()) {
                ASTNode aSTNode = source.createMoveTarget((ASTNode)nodes.get(index), (ASTNode)nodes.get(nodes.size() - 1), (ASTNode)(index == 0 ? replacementNode : null), null);
                statements.insertLast(aSTNode, null);
            }
            if (index <= 0) break block53;
            source.replace(this.fAutoClosableNodes.get(0), replacementNode, null);
            boolean bl = true;
            while (var30_77 < index) {
                source.remove(this.fAutoClosableNodes.get((int)var30_77), null);
                ++var30_77;
            }
        }
    }

    public static IMethodBinding findAutocloseMethod(ITypeBinding type) {
        while (type != null) {
            IMethodBinding[] methods;
            IMethodBinding[] iMethodBindingArray = methods = type.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if ("close".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return method;
                }
                ++n2;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private int findEndPosition(ASTNode node) {
        int end = node.getStartPosition() + node.getLength();
        Map<SimpleName, IVariableBinding> nodeSimpleNameBindings = this.fAnalyzer.getVariableStatementBinding(node);
        ArrayList<SimpleName> nodeNames = new ArrayList<SimpleName>(nodeSimpleNameBindings.keySet());
        if (nodeNames.isEmpty()) {
            return -1;
        }
        SimpleName nodeSimpleName = (SimpleName)nodeNames.get(0);
        SimpleName[] coveredNodeBindings = LinkedNodeFinder.findByNode(node.getRoot(), nodeSimpleName);
        if (coveredNodeBindings.length == 0) {
            return -1;
        }
        SimpleName[] simpleNameArray = coveredNodeBindings;
        int n = coveredNodeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName astNode = simpleNameArray[n2];
            end = Math.max(end, astNode.getStartPosition() + astNode.getLength());
            ++n2;
        }
        return end;
    }

    public static List<ASTNode> findNodesInRange(final ASTNode astNode, final int start, final int end) {
        final ArrayList<ASTNode> nodesInRange = new ArrayList<ASTNode>();
        astNode.accept(new ASTVisitor(){
            int pre;
            {
                this.pre = n;
            }

            public void preVisit(ASTNode preNode) {
                this.pre = preNode.getStartPosition();
                super.preVisit(preNode);
            }

            public void postVisit(ASTNode postNode) {
                int post = postNode.getStartPosition() + postNode.getLength();
                if (this.pre >= start && post <= end) {
                    Statement statement = ASTResolving.findParentStatement(postNode);
                    while (statement != null && statement.getParent() != astNode) {
                        ASTNode parent = statement.getParent();
                        if (parent == null) {
                            return;
                        }
                        statement = ASTResolving.findParentStatement(parent);
                    }
                    if (statement != null && !nodesInRange.contains(statement)) {
                        nodesInRange.add(statement);
                    }
                }
                super.postVisit(postNode);
            }
        });
        return nodesInRange;
    }

    private List<ASTNode> getSpecialVariableDeclarationStatements() {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(3);
        VariableDeclaration[] variableDeclarationArray = this.fAnalyzer.getAffectedLocals();
        int n = variableDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDeclaration local = variableDeclarationArray[n2];
            ASTNode parent = local.getParent();
            if (parent instanceof VariableDeclarationStatement && !result.contains(parent)) {
                result.add(parent);
            }
            ++n2;
        }
        return result;
    }

    private Statement getCatchBody(String type, String name, String lineSeparator) throws CoreException {
        String s = StubUtility.getCatchBodyContent(this.fCUnit, type, name, this.fSelectedNodes[0], lineSeparator);
        if (s == null) {
            return null;
        }
        return (Statement)this.fRewriter.createStringPlaceholder(s, 41);
    }
}

