"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAuthorityWithOptionalPort = exports.parseAuthorityWithPort = exports.getRemoteServerRootPath = exports.getRemoteName = exports.getRemoteAuthority = void 0;
const network_1 = require("../../../base/common/network");
function getRemoteAuthority(uri) {
    return uri.scheme === network_1.Schemas.vscodeRemote ? uri.authority : undefined;
}
exports.getRemoteAuthority = getRemoteAuthority;
function getRemoteName(authority) {
    if (!authority) {
        return undefined;
    }
    const pos = authority.indexOf('+');
    if (pos < 0) {
        // e.g. localhost:8000
        return authority;
    }
    return authority.substr(0, pos);
}
exports.getRemoteName = getRemoteName;
/**
 * The root path to use when accessing the remote server. The path contains the quality and commit of the current build.
 * @param product
 * @returns
 */
function getRemoteServerRootPath(product) {
    var _a, _b;
    return `/${(_a = product.quality) !== null && _a !== void 0 ? _a : 'oss'}-${(_b = product.commit) !== null && _b !== void 0 ? _b : 'dev'}`;
}
exports.getRemoteServerRootPath = getRemoteServerRootPath;
function parseAuthorityWithPort(authority) {
    const { host, port } = parseAuthority(authority);
    if (typeof port === 'undefined') {
        throw new Error(`Remote authority doesn't contain a port!`);
    }
    return { host, port };
}
exports.parseAuthorityWithPort = parseAuthorityWithPort;
function parseAuthorityWithOptionalPort(authority, defaultPort) {
    let { host, port } = parseAuthority(authority);
    if (typeof port === 'undefined') {
        port = defaultPort;
    }
    return { host, port };
}
exports.parseAuthorityWithOptionalPort = parseAuthorityWithOptionalPort;
function parseAuthority(authority) {
    // check for ipv6 with port
    const m1 = authority.match(/^(\[[0-9a-z:]+\]):(\d+)$/);
    if (m1) {
        return { host: m1[1], port: parseInt(m1[2], 10) };
    }
    // check for ipv6 without port
    const m2 = authority.match(/^(\[[0-9a-z:]+\])$/);
    if (m2) {
        return { host: m2[1], port: undefined };
    }
    // anything with a trailing port
    const m3 = authority.match(/(.*):(\d+)$/);
    if (m3) {
        return { host: m3[1], port: parseInt(m3[2], 10) };
    }
    // doesn't contain a port
    return { host: authority, port: undefined };
}
//# sourceMappingURL=remoteHosts.js.map