"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadOnlyMessageController = void 0;
const lifecycle_1 = require("../../../../base/common/lifecycle");
const editorExtensions_1 = require("../../../browser/editorExtensions");
const messageController_1 = require("../../message/browser/messageController");
const nls = require("../../../../nls");
class ReadOnlyMessageController extends lifecycle_1.Disposable {
    constructor(editor) {
        super();
        this.editor = editor;
        this._register(this.editor.onDidAttemptReadOnlyEdit(() => this._onDidAttemptReadOnlyEdit()));
    }
    _onDidAttemptReadOnlyEdit() {
        const messageController = messageController_1.MessageController.get(this.editor);
        if (messageController && this.editor.hasModel()) {
            if (this.editor.isSimpleWidget) {
                messageController.showMessage(nls.localize('editor.simple.readonly', "Cannot edit in read-only input"), this.editor.getPosition());
            }
            else {
                messageController.showMessage(nls.localize('editor.readonly', "Cannot edit in read-only editor"), this.editor.getPosition());
            }
        }
    }
}
exports.ReadOnlyMessageController = ReadOnlyMessageController;
ReadOnlyMessageController.ID = 'editor.contrib.readOnlyMessageController';
(0, editorExtensions_1.registerEditorContribution)(ReadOnlyMessageController.ID, ReadOnlyMessageController);
//# sourceMappingURL=contribution.js.map