"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
const editorExtensions_1 = require("../../../browser/editorExtensions");
const editorConfigurationSchema_1 = require("../../../common/config/editorConfigurationSchema");
const copyPasteController_1 = require("./copyPasteController");
const nls = require("../../../../nls");
const configurationRegistry_1 = require("../../../../platform/configuration/common/configurationRegistry");
const platform_1 = require("../../../../platform/registry/common/platform");
(0, editorExtensions_1.registerEditorContribution)(copyPasteController_1.CopyPasteController.ID, copyPasteController_1.CopyPasteController);
platform_1.Registry.as(configurationRegistry_1.Extensions.Configuration).registerConfiguration(Object.assign(Object.assign({}, editorConfigurationSchema_1.editorConfigurationBaseNode), { properties: {
        'editor.experimental.pasteActions.enabled': {
            type: 'boolean',
            scope: 5 /* ConfigurationScope.LANGUAGE_OVERRIDABLE */,
            description: nls.localize('pasteActions', "Enable/disable running edits from extensions on paste."),
            default: false,
        },
    } }));
//# sourceMappingURL=copyPasteContribution.js.map