"use strict";
// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolbarMenuNodeWrapper = exports.TOOLBAR_WRAPPER_ID_SUFFIX = void 0;
const tab_bar_toolbar_types_1 = require("./tab-bar-toolbar-types");
exports.TOOLBAR_WRAPPER_ID_SUFFIX = '-as-tabbar-toolbar-item';
class ToolbarMenuNodeWrapper {
    constructor(menuNode, group, menuPath) {
        this.menuNode = menuNode;
        this.group = group;
        this.menuPath = menuPath;
    }
    get id() { return this.menuNode.id + exports.TOOLBAR_WRAPPER_ID_SUFFIX; }
    get command() { var _a; return (_a = this.menuNode.command) !== null && _a !== void 0 ? _a : ''; }
    ;
    get icon() { return this.menuNode.icon; }
    get tooltip() { return this.menuNode.label; }
    get when() { return this.menuNode.when; }
    get text() { return (this.group === tab_bar_toolbar_types_1.NAVIGATION || this.group === undefined) ? undefined : this.menuNode.label; }
}
exports.ToolbarMenuNodeWrapper = ToolbarMenuNodeWrapper;
//# sourceMappingURL=tab-bar-toolbar-menu-adapters.js.map