/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.QuickFixProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.RefactorProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.AssignToVariableAssistCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.NonProjectFixProcessor;
import org.eclipse.jdt.ls.core.internal.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactoringCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionHandler {
    public static final String COMMAND_ID_APPLY_EDIT = "java.apply.workspaceEdit";
    private QuickFixProcessor quickFixProcessor;
    private RefactorProcessor refactorProcessor;
    private QuickAssistProcessor quickAssistProcessor;
    private SourceAssistProcessor sourceAssistProcessor;
    private NonProjectFixProcessor nonProjectFixProcessor;
    private PreferenceManager preferenceManager;

    public CodeActionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.quickFixProcessor = new QuickFixProcessor();
        this.sourceAssistProcessor = new SourceAssistProcessor(preferenceManager);
        this.quickAssistProcessor = new QuickAssistProcessor(preferenceManager);
        this.refactorProcessor = new RefactorProcessor(preferenceManager);
        this.nonProjectFixProcessor = new NonProjectFixProcessor(preferenceManager);
    }

    public List<Either<Command, CodeAction>> getCodeActionCommands(CodeActionParams params, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        CompilationUnit astRoot = CodeActionHandler.getASTRoot(unit, monitor);
        if (astRoot == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        context.setASTRoot(astRoot);
        IProblemLocationCore[] locations = CodeActionHandler.getProblemLocationCores(unit, params.getContext().getDiagnostics());
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<String> codeActionKinds = new ArrayList<String>();
        if (params.getContext().getOnly() != null && !params.getContext().getOnly().isEmpty()) {
            codeActionKinds.addAll(params.getContext().getOnly());
        } else {
            List<String> defaultCodeActionKinds = Arrays.asList("quickfix", "refactor", "quickassist", "source");
            codeActionKinds.addAll(defaultCodeActionKinds);
        }
        ArrayList<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();
        ArrayList<ChangeCorrectionProposal> proposals = new ArrayList<ChangeCorrectionProposal>();
        ChangeCorrectionProposalComparator comparator = new ChangeCorrectionProposalComparator();
        if (CodeActionHandler.containsKind(codeActionKinds, "quickfix")) {
            try {
                codeActions.addAll(this.nonProjectFixProcessor.getCorrections(params, context, locations));
                List<ChangeCorrectionProposal> quickfixProposals = this.quickFixProcessor.getCorrections(context, locations);
                quickfixProposals.sort(comparator);
                proposals.addAll(quickfixProposals);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving quick fix code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "refactor")) {
            try {
                List<ChangeCorrectionProposal> refactorProposals = this.refactorProcessor.getProposals(params, context, locations);
                refactorProposals.sort(comparator);
                proposals.addAll(refactorProposals);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving refactor code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "quickassist")) {
            try {
                List<ChangeCorrectionProposal> quickassistProposals = this.quickAssistProcessor.getAssists(params, context, locations);
                quickassistProposals.sort(comparator);
                proposals.addAll(quickassistProposals);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving quick assist code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        try {
            for (ChangeCorrectionProposal proposal : proposals) {
                Optional<Either<Command, CodeAction>> codeActionFromProposal = this.getCodeActionFromProposal(proposal, params.getContext());
                if (!codeActionFromProposal.isPresent() || codeActions.contains(codeActionFromProposal.get())) continue;
                codeActions.add(codeActionFromProposal.get());
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem converting proposal to code actions", e);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "source")) {
            codeActions.addAll(this.sourceAssistProcessor.getSourceActionCommands(params, context, locations, monitor));
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return codeActions;
    }

    private Optional<Either<Command, CodeAction>> getCodeActionFromProposal(ChangeCorrectionProposal proposal, CodeActionContext context) throws CoreException {
        Command command;
        CUCorrectionProposal commandProposal;
        String name = proposal.getName();
        if (proposal instanceof CUCorrectionCommandProposal) {
            commandProposal = (CUCorrectionCommandProposal)proposal;
            command = new Command(name, ((CUCorrectionCommandProposal)commandProposal).getCommand(), ((CUCorrectionCommandProposal)commandProposal).getCommandArguments());
        } else if (proposal instanceof RefactoringCorrectionCommandProposal) {
            commandProposal = (RefactoringCorrectionCommandProposal)proposal;
            command = new Command(name, ((RefactoringCorrectionCommandProposal)commandProposal).getCommand(), ((RefactoringCorrectionCommandProposal)commandProposal).getCommandArguments());
        } else if (proposal instanceof AssignToVariableAssistCommandProposal) {
            commandProposal = (AssignToVariableAssistCommandProposal)proposal;
            command = new Command(name, ((AssignToVariableAssistCommandProposal)commandProposal).getCommand(), ((AssignToVariableAssistCommandProposal)commandProposal).getCommandArguments());
        } else {
            WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange());
            if (!ChangeUtil.hasChanges(edit)) {
                return Optional.empty();
            }
            command = new Command(name, COMMAND_ID_APPLY_EDIT, Collections.singletonList(edit));
        }
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(proposal.getKind())) {
            CodeAction codeAction = new CodeAction(name);
            codeAction.setKind(proposal.getKind());
            codeAction.setCommand(command);
            codeAction.setDiagnostics(context.getDiagnostics());
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    public static IProblemLocationCore[] getProblemLocationCores(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        IProblemLocationCore[] locations = new IProblemLocationCore[diagnostics.size()];
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = diagnostics.get(i);
            int problemId = CodeActionHandler.getProblemId(diagnostic);
            int start = DiagnosticsHelper.getStartOffset(unit, diagnostic.getRange());
            int end = DiagnosticsHelper.getEndOffset(unit, diagnostic.getRange());
            boolean isError = diagnostic.getSeverity() == DiagnosticSeverity.Error;
            locations[i] = new ProblemLocationCore(start, end - start, problemId, new String[0], isError, "org.eclipse.jdt.core.problem");
            ++i;
        }
        return locations;
    }

    private static int getProblemId(Diagnostic diagnostic) {
        int $ = 0;
        try {
            Either code = diagnostic.getCode();
            if (code != null) {
                if (code.getLeft() != null) {
                    $ = Integer.parseInt((String)code.getLeft());
                } else if (code.getRight() != null) {
                    $ = ((Number)code.getRight()).intValue();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return $;
    }

    public static CompilationUnit getASTRoot(ICompilationUnit unit) {
        return CodeActionHandler.getASTRoot(unit, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CompilationUnit getASTRoot(ICompilationUnit unit, IProgressMonitor monitor) {
        return CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
    }

    private static boolean containsKind(List<String> codeActionKinds, String baseKind) {
        return codeActionKinds.stream().anyMatch(kind -> kind.startsWith(baseKind));
    }

    private static class ChangeCorrectionProposalComparator
    implements Comparator<ChangeCorrectionProposal> {
        private ChangeCorrectionProposalComparator() {
        }

        @Override
        public int compare(ChangeCorrectionProposal p1, ChangeCorrectionProposal p2) {
            String k1 = p1.getKind();
            String k2 = p2.getKind();
            if (!(StringUtils.isBlank((CharSequence)k1) || StringUtils.isBlank((CharSequence)k2) || k1.equals(k2))) {
                return k1.compareTo(k2);
            }
            int r1 = p1.getRelevance();
            int r2 = p2.getRelevance();
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
            return p1.getName().compareToIgnoreCase(p2.getName());
        }
    }
}

