"use strict";
// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandMenuNode = exports.CompoundMenuNode = exports.ACCOUNTS_SUBMENU = exports.ACCOUNTS_MENU = exports.SETTINGS_MENU = exports.MAIN_MENU_BAR = exports.MenuAction = void 0;
var MenuAction;
(function (MenuAction) {
    /* Determine whether object is a MenuAction */
    function is(arg) {
        return !!arg && typeof arg === 'object' && 'commandId' in arg;
    }
    MenuAction.is = is;
})(MenuAction = exports.MenuAction || (exports.MenuAction = {}));
exports.MAIN_MENU_BAR = ['menubar'];
exports.SETTINGS_MENU = ['settings_menu'];
exports.ACCOUNTS_MENU = ['accounts_menu'];
exports.ACCOUNTS_SUBMENU = [...exports.ACCOUNTS_MENU, '1_accounts_submenu'];
var CompoundMenuNode;
(function (CompoundMenuNode) {
    function is(node) { return Array.isArray(node.children); }
    CompoundMenuNode.is = is;
    function getRole(node) {
        var _a;
        if (!is(node)) {
            return undefined;
        }
        return (_a = node.role) !== null && _a !== void 0 ? _a : (node.label ? 0 /* Submenu */ : 1 /* Group */);
    }
    CompoundMenuNode.getRole = getRole;
    function sortChildren(m1, m2) {
        // The navigation group is special as it will always be sorted to the top/beginning of a menu.
        if (isNavigationGroup(m1)) {
            return -1;
        }
        if (isNavigationGroup(m2)) {
            return 1;
        }
        return m1.sortString.localeCompare(m2.sortString);
    }
    CompoundMenuNode.sortChildren = sortChildren;
    /** Collapses the children of any subemenus with role {@link CompoundMenuNodeRole Flat} and sorts */
    function getFlatChildren(children) {
        const childrenToMerge = [];
        return children.filter(child => {
            if (getRole(child) === 2 /* Flat */) {
                childrenToMerge.push(child.children);
                return false;
            }
            return true;
        }).concat(...childrenToMerge).sort(sortChildren);
    }
    CompoundMenuNode.getFlatChildren = getFlatChildren;
    /**
     * Indicates whether the given node is the special `navigation` menu.
     *
     * @param node the menu node to check.
     * @returns `true` when the given node is a {@link CompoundMenuNode} with id `navigation`,
     * `false` otherwise.
     */
    function isNavigationGroup(node) {
        return is(node) && node.id === 'navigation';
    }
    CompoundMenuNode.isNavigationGroup = isNavigationGroup;
})(CompoundMenuNode = exports.CompoundMenuNode || (exports.CompoundMenuNode = {}));
var CommandMenuNode;
(function (CommandMenuNode) {
    function is(candidate) { return Boolean(candidate.command); }
    CommandMenuNode.is = is;
})(CommandMenuNode = exports.CommandMenuNode || (exports.CommandMenuNode = {}));
//# sourceMappingURL=menu-types.js.map