/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.RuntimeEnvironment;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;

public class JVMConfigurator
implements IVMInstallChangedListener {
    public static boolean configureDefaultVM(String javaHome) throws CoreException {
        if (StringUtils.isBlank((CharSequence)javaHome)) {
            return false;
        }
        File jvmHome = new File(javaHome);
        if (jvmHome.isDirectory()) {
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            if (defaultVM != null && jvmHome.equals(defaultVM.getInstallLocation())) {
                return false;
            }
        } else {
            JavaLanguageServerPlugin.logInfo("java.home " + jvmHome + " is not a directory");
            return false;
        }
        IVMInstall vm = JVMConfigurator.findVM(jvmHome, null);
        if (vm == null) {
            IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
            long unique = System.currentTimeMillis();
            while (installType.findVMInstall(String.valueOf(unique)) != null) {
                ++unique;
            }
            String vmId = String.valueOf(unique);
            VMStandin vmStandin = new VMStandin(installType, vmId);
            String name = (String)StringUtils.defaultIfBlank((CharSequence)jvmHome.getName(), (CharSequence)"JRE");
            vmStandin.setName(name);
            vmStandin.setInstallLocation(jvmHome);
            vm = vmStandin.convertToRealVM();
        }
        JavaLanguageServerPlugin.logInfo("Setting java.home " + jvmHome + " as default global VM");
        JavaRuntime.setDefaultVMInstall((IVMInstall)vm, (IProgressMonitor)new NullProgressMonitor());
        JDTUtils.setCompatibleVMs(vm.getId());
        return true;
    }

    public static boolean configureJVMs(Preferences preferences) throws CoreException {
        return JVMConfigurator.configureJVMs(preferences, null);
    }

    public static boolean configureJVMs(Preferences preferences, JavaClientConnection connection) throws CoreException {
        boolean changed = false;
        boolean defaultVMSet = false;
        Set<RuntimeEnvironment> runtimes = preferences.getRuntimes();
        for (RuntimeEnvironment runtime : runtimes) {
            if (!runtime.isValid()) continue;
            File file = runtime.getInstallationFile();
            if (file != null && file.isDirectory()) {
                VMStandin vmStandin;
                URL javadocURL = runtime.getJavadocURL();
                IPath sourcePath = runtime.getSourcePath();
                IVMInstall vm = JVMConfigurator.findVM(file, runtime.getName());
                IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
                if (vm == null) {
                    long unique = System.currentTimeMillis();
                    while (installType.findVMInstall(String.valueOf(unique)) != null) {
                        ++unique;
                    }
                    String vmId = String.valueOf(unique);
                    vmStandin = new VMStandin(installType, vmId);
                    changed = true;
                } else {
                    vmStandin = new VMStandin(vm);
                    changed = changed || !runtime.getName().equals(vm.getName()) || !runtime.getInstallationFile().equals(vm.getInstallLocation());
                }
                IStatus status = installType.validateInstallLocation(file);
                if (!status.isOK()) {
                    if (Objects.equals(file.getName(), "bin")) {
                        JVMConfigurator.sendNotification(connection, "Invalid runtime for " + runtime.getName() + ": 'bin' should be removed from the path (" + runtime.getPath() + ").");
                    } else {
                        JVMConfigurator.sendNotification(connection, "Invalid runtime for " + runtime.getName() + ": The path (" + runtime.getPath() + ") does not point to a JDK.");
                    }
                    JavaLanguageServerPlugin.log(status);
                    continue;
                }
                vmStandin.setName(runtime.getName());
                vmStandin.setInstallLocation(file);
                if (sourcePath != null || javadocURL != null) {
                    LibraryLocation[] libs;
                    if (vm != null && vm.getLibraryLocations() != null) {
                        libs = vm.getLibraryLocations();
                    } else {
                        StandardVMType svt = (StandardVMType)installType;
                        libs = svt.getDefaultLibraryLocations(file);
                    }
                    boolean libChanged = false;
                    if (libs != null) {
                        int i = 0;
                        while (i < libs.length) {
                            LibraryLocation lib = libs[i];
                            IPath systemSourcePath = sourcePath != null ? sourcePath : lib.getSystemLibrarySourcePath();
                            URL javadocLocation = javadocURL != null ? javadocURL : lib.getJavadocLocation();
                            LibraryLocation newLib = new LibraryLocation(lib.getSystemLibraryPath(), systemSourcePath, lib.getPackageRootPath(), javadocLocation, lib.getIndexLocation(), lib.getExternalAnnotationsPath());
                            libChanged = libChanged || !newLib.equals((Object)lib);
                            libs[i] = newLib;
                            ++i;
                        }
                    }
                    if (libChanged) {
                        LibraryLocation[] newLibs = Arrays.copyOf(libs, libs.length);
                        vmStandin.setLibraryLocations(newLibs);
                        changed = true;
                    }
                }
                vm = vmStandin.convertToRealVM();
                if (runtime.isDefault()) {
                    defaultVMSet = true;
                    if (!Objects.equals(vm, JavaRuntime.getDefaultVMInstall())) {
                        JavaLanguageServerPlugin.logInfo("Setting runtime " + runtime.getName() + "-" + runtime.getInstallationFile() + " as default global VM");
                        JavaRuntime.setDefaultVMInstall((IVMInstall)vm, (IProgressMonitor)new NullProgressMonitor());
                        changed = true;
                    }
                }
                if (JVMConfigurator.setDefaultEnvironmentVM(vm, runtime.getName())) continue;
                JVMConfigurator.sendNotification(connection, "Invalid runtime for " + runtime.getName() + ": Runtime at '" + runtime.getPath() + "' is not compatible with the '" + runtime.getName() + "' environment.");
                JavaLanguageServerPlugin.logError("Runtime at '" + runtime.getPath() + "' is not compatible with the '" + runtime.getName() + "' environment");
                continue;
            }
            JVMConfigurator.sendNotification(connection, "Invalid runtime for " + runtime.getName() + ": The path points to a missing or inaccessible folder (" + runtime.getPath() + ").");
            JavaLanguageServerPlugin.logInfo("Invalid runtime: " + runtime);
        }
        if (!defaultVMSet) {
            boolean bl = changed = JVMConfigurator.configureDefaultVM(preferences.getJavaHome()) || changed;
        }
        if (changed) {
            JavaLanguageServerPlugin.logInfo("JVM Runtimes changed, saving new configuration");
            JavaRuntime.saveVMConfiguration();
        }
        return changed;
    }

    private static void sendNotification(JavaClientConnection connection, String message) {
        if (connection == null) {
            return;
        }
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager != null && preferencesManager.getClientPreferences().isActionableRuntimeNotificationSupport()) {
            ActionableNotification runtimeNotification = new ActionableNotification().withSeverity(Preferences.Severity.error.toMessageType()).withMessage(message).withCommands(Arrays.asList(new Command("Open Settings", "java.runtimeValidation.open", null)));
            connection.sendActionableNotification(runtimeNotification);
            return;
        }
        connection.showNotificationMessage(MessageType.Error, message);
    }

    private static boolean setDefaultEnvironmentVM(IVMInstall vm, String name) {
        IExecutionEnvironment environment = JVMConfigurator.getExecutionEnvironment(name);
        if (environment != null) {
            IVMInstall[] compatibleVMs;
            if (Objects.equals(vm, environment.getDefaultVM())) {
                return true;
            }
            IVMInstall[] iVMInstallArray = compatibleVMs = environment.getCompatibleVMs();
            int n = compatibleVMs.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall compatibleVM = iVMInstallArray[n2];
                if (compatibleVM.equals(vm)) {
                    if (!environment.isStrictlyCompatible(vm)) {
                        JavaLanguageServerPlugin.logInfo("Runtime at '" + vm.getInstallLocation().toString() + "' is not strictly compatible with the '" + name + "' environment");
                    }
                    JavaLanguageServerPlugin.logInfo("Setting " + compatibleVM.getInstallLocation() + " as '" + name + "' environment (id:" + compatibleVM.getId() + ")");
                    environment.setDefaultVM(compatibleVM);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static IExecutionEnvironment getExecutionEnvironment(String name) {
        IExecutionEnvironment[] environments;
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = environments = manager.getExecutionEnvironments();
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            if (environment.getId().equals(name)) {
                return environment;
            }
            ++n2;
        }
        return null;
    }

    public static IVMInstall findVM(File file, String name) {
        IVMInstallType[] types;
        IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] installs;
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = installs = type.getVMInstalls();
            int n3 = installs.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall install = iVMInstallArray[n4];
                if (name != null && name.equals(install.getName())) {
                    return install;
                }
                if (file != null && file.equals(install.getInstallLocation())) {
                    return install;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        IProject[] projects;
        if (Objects.equals(previous, current)) {
            return;
        }
        String prev = previous == null ? null : String.valueOf(previous.getId()) + "-" + previous.getInstallLocation();
        String curr = current == null ? null : String.valueOf(current.getId()) + "-" + current.getInstallLocation();
        JavaLanguageServerPlugin.logInfo("Default VM Install changed from  " + prev + " to " + curr);
        AbstractVMInstall jvm = (AbstractVMInstall)current;
        long jdkLevel = CompilerOptions.versionToJdkLevel((String)jvm.getJavaVersion());
        String compliance = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)compliance, (Map)options);
        JavaCore.setOptions((Hashtable)options);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectsManager projectsManager;
            IProject project = iProjectArray[n2];
            if (!ProjectUtils.isVisibleProject(project) && ProjectUtils.isJavaProject(project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                JVMConfigurator.configureJVMSettings(javaProject, current);
            }
            if ((projectsManager = JavaLanguageServerPlugin.getProjectsManager()) != null) {
                JavaLanguageServerPlugin.logInfo("defaultVMInstallChanged -> force update of " + project.getName());
                projectsManager.updateProject(project, true);
            }
            ++n2;
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
    }

    public void vmAdded(IVMInstall vm) {
    }

    public void vmRemoved(IVMInstall vm) {
    }

    public static void configureJVMSettings(IJavaProject javaProject) {
        JVMConfigurator.configureJVMSettings(javaProject, JavaRuntime.getDefaultVMInstall());
    }

    public static void configureJVMSettings(IJavaProject javaProject, IVMInstall vmInstall) {
        if (javaProject == null) {
            return;
        }
        String version = "";
        if (vmInstall instanceof AbstractVMInstall) {
            AbstractVMInstall jvm = (AbstractVMInstall)vmInstall;
            version = jvm.getJavaVersion();
            long jdkLevel = CompilerOptions.versionToJdkLevel((String)jvm.getJavaVersion());
            String compliance = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
            Map options = javaProject.getOptions(false);
            JavaCore.setComplianceOptions((String)compliance, (Map)options);
        }
        if (JavaCore.compareJavaVersions((String)version, (String)JavaCore.latestSupportedJavaVersion()) >= 0) {
            javaProject.setOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
            javaProject.setOption("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        } else {
            javaProject.setOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        }
    }
}

