/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;

public class RedundantNullnessTypeAnnotationsFilter {
    private static final IAnnotationBinding[] NO_ANNOTATIONS = new IAnnotationBinding[0];
    private static final EnumSet<ImportRewrite.TypeLocation> NEVER_NULLNESS_LOCATIONS = EnumSet.of(ImportRewrite.TypeLocation.LOCAL_VARIABLE, new ImportRewrite.TypeLocation[]{ImportRewrite.TypeLocation.CAST, ImportRewrite.TypeLocation.EXCEPTION, ImportRewrite.TypeLocation.NEW, ImportRewrite.TypeLocation.INSTANCEOF, ImportRewrite.TypeLocation.RECEIVER});
    private final String fNonNullAnnotationName;
    private final String fNullableAnnotationName;
    private final EnumSet<ImportRewrite.TypeLocation> fNonNullByDefaultLocations;

    public static RedundantNullnessTypeAnnotationsFilter createIfConfigured(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode root = node.getRoot();
        if (root instanceof CompilationUnit) {
            IJavaProject javaProject;
            CompilationUnit compilationUnit = (CompilationUnit)root;
            IJavaElement javaElement = compilationUnit.getJavaElement();
            IJavaProject iJavaProject = javaProject = javaElement == null ? null : javaElement.getJavaProject();
            if (javaProject != null && "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true))) {
                String nonNullAnnotationName = javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nonnull", true);
                String nullableAnnotationName = javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullable", true);
                Set<String> nonNullByDefaultNames = RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultNames(javaProject);
                if (nonNullAnnotationName == null || nullableAnnotationName == null || nonNullByDefaultNames == null) {
                    return null;
                }
                EnumSet<ImportRewrite.TypeLocation> nonNullByDefaultLocations = RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultLocations(node, nonNullByDefaultNames);
                return new RedundantNullnessTypeAnnotationsFilter(nonNullAnnotationName, nullableAnnotationName, nonNullByDefaultLocations);
            }
        }
        return null;
    }

    public static Set<String> determineNonNullByDefaultNames(IJavaProject javaProject) {
        String nonNullByDefaultName = javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", true);
        if (nonNullByDefaultName == null) {
            return null;
        }
        LinkedHashSet<String> nonNullByDefaultNames = new LinkedHashSet<String>();
        nonNullByDefaultNames.add(nonNullByDefaultName);
        String secondaryNNBDNames = javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary", true);
        if (secondaryNNBDNames != null) {
            String[] stringArray = secondaryNNBDNames.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if ((string = string.trim()).length() > 0) {
                    nonNullByDefaultNames.add(string);
                }
                ++n2;
            }
        }
        return nonNullByDefaultNames;
    }

    public static EnumSet<ImportRewrite.TypeLocation> determineNonNullByDefaultLocations(ASTNode astNode, Set<String> nonNullByDefaultNames) {
        while (astNode != null) {
            List<IAnnotationBinding> annots = RedundantNullnessTypeAnnotationsFilter.getNNBDAnnotations(astNode, nonNullByDefaultNames);
            if (annots != null) {
                return RedundantNullnessTypeAnnotationsFilter.determineNNBDValue(annots);
            }
            astNode = astNode.getParent();
        }
        return EnumSet.noneOf(ImportRewrite.TypeLocation.class);
    }

    private static EnumSet<ImportRewrite.TypeLocation> determineNNBDValue(List<IAnnotationBinding> annots) {
        EnumSet<ImportRewrite.TypeLocation> result = EnumSet.noneOf(ImportRewrite.TypeLocation.class);
        for (IAnnotationBinding annot : annots) {
            IMemberValuePairBinding[] pairs = annot.getAllMemberValuePairs();
            if (pairs.length == 0) {
                ITypeBinding annotationType = annot.getAnnotationType();
                boolean foundTypeQualifierDefault = false;
                if (annotationType != null) {
                    IAnnotationBinding[] annotationAnnotations;
                    IAnnotationBinding[] iAnnotationBindingArray = annotationAnnotations = annotationType.getAnnotations();
                    int n = annotationAnnotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotationBinding nestedBinding = iAnnotationBindingArray[n2];
                        ITypeBinding nestedAnnotationType = nestedBinding.getAnnotationType();
                        if (nestedAnnotationType != null && nestedAnnotationType.getName().equals("TypeQualifierDefault")) {
                            foundTypeQualifierDefault = true;
                            IMemberValuePairBinding[] iMemberValuePairBindingArray = nestedBinding.getAllMemberValuePairs();
                            int n3 = iMemberValuePairBindingArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n4];
                                if (pair.getKey() == null || pair.getKey().equals("value")) {
                                    Object value = pair.getValue();
                                    if (value instanceof Object[]) {
                                        Object[] values;
                                        Object[] objectArray = values = (Object[])value;
                                        int n5 = values.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            Object elem = objectArray[n6];
                                            RedundantNullnessTypeAnnotationsFilter.addElementTypesAsTypeLocationValues(result, elem);
                                            ++n6;
                                        }
                                    } else {
                                        RedundantNullnessTypeAnnotationsFilter.addElementTypesAsTypeLocationValues(result, value);
                                    }
                                }
                                ++n4;
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                if (foundTypeQualifierDefault) continue;
                RedundantNullnessTypeAnnotationsFilter.addAsTypeLocationValues(result, Boolean.TRUE);
                continue;
            }
            IMemberValuePairBinding[] iMemberValuePairBindingArray = pairs;
            int n = pairs.length;
            int n7 = 0;
            while (n7 < n) {
                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n7];
                if (pair.getKey() == null || pair.getKey().equals("value")) {
                    Object value = pair.getValue();
                    if (value instanceof Object[]) {
                        Object[] values;
                        Object[] objectArray = values = (Object[])value;
                        int n8 = values.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            Object elem = objectArray[n9];
                            RedundantNullnessTypeAnnotationsFilter.addAsTypeLocationValues(result, elem);
                            ++n9;
                        }
                    } else {
                        RedundantNullnessTypeAnnotationsFilter.addAsTypeLocationValues(result, value);
                    }
                }
                ++n7;
            }
        }
        return result;
    }

    private static void addAsTypeLocationValues(EnumSet<ImportRewrite.TypeLocation> result, Object value) {
        if (value instanceof IVariableBinding) {
            String name = ((IVariableBinding)value).getName();
            try {
                result.add(ImportRewrite.TypeLocation.valueOf((String)name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (Boolean.TRUE.equals(value)) {
            result.add(ImportRewrite.TypeLocation.RETURN_TYPE);
            result.add(ImportRewrite.TypeLocation.PARAMETER);
            result.add(ImportRewrite.TypeLocation.FIELD);
        }
    }

    private static void addElementTypesAsTypeLocationValues(EnumSet<ImportRewrite.TypeLocation> result, Object value) {
        if (value instanceof IVariableBinding) {
            String name = ((IVariableBinding)value).getName();
            if (ElementType.PARAMETER.name().equals(name)) {
                result.add(ImportRewrite.TypeLocation.PARAMETER);
            } else if (ElementType.METHOD.name().equals(name)) {
                result.add(ImportRewrite.TypeLocation.RETURN_TYPE);
            } else if (ElementType.FIELD.name().equals(name)) {
                result.add(ImportRewrite.TypeLocation.FIELD);
            }
        }
    }

    private static List<IAnnotationBinding> getNNBDAnnotations(ASTNode astNode, Set<String> nonNullByDefaultNames) {
        List extendsMods = null;
        ArrayList<Object> list = null;
        switch (astNode.getNodeType()) {
            case 15: {
                IPackageBinding packageBinding;
                PackageDeclaration packageDeclaration = ((CompilationUnit)astNode).getPackage();
                if (packageDeclaration != null && (packageBinding = packageDeclaration.resolveBinding()) != null) {
                    IAnnotationBinding[] iAnnotationBindingArray = packageBinding.getAnnotations();
                    int n = iAnnotationBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                        ITypeBinding annotationType = annotationBinding.getAnnotationType();
                        if (annotationType != null && nonNullByDefaultNames.contains(annotationType.getQualifiedName())) {
                            if (list == null) {
                                list = new ArrayList<IAnnotationBinding>();
                            }
                            list.add(annotationBinding);
                        }
                        ++n2;
                    }
                    if (list != null) {
                        return list;
                    }
                    IModuleBinding module = packageBinding.getModule();
                    if (module != null) {
                        IAnnotationBinding[] iAnnotationBindingArray2 = module.getAnnotations();
                        int n3 = iAnnotationBindingArray2.length;
                        n = 0;
                        while (n < n3) {
                            IAnnotationBinding annotationBinding = iAnnotationBindingArray2[n];
                            ITypeBinding annotationType = annotationBinding.getAnnotationType();
                            if (annotationType != null && nonNullByDefaultNames.contains(annotationType.getQualifiedName())) {
                                if (list == null) {
                                    list = new ArrayList();
                                }
                                list.add(annotationBinding);
                            }
                            ++n;
                        }
                        if (list != null) {
                            return list;
                        }
                    }
                }
                return null;
            }
            case 23: 
            case 31: 
            case 55: 
            case 71: 
            case 72: 
            case 81: 
            case 82: {
                extendsMods = ((BodyDeclaration)astNode).modifiers();
                break;
            }
            case 60: {
                extendsMods = ((VariableDeclarationStatement)astNode).modifiers();
                break;
            }
            case 58: {
                extendsMods = ((VariableDeclarationExpression)astNode).modifiers();
                break;
            }
            case 44: {
                extendsMods = ((SingleVariableDeclaration)astNode).modifiers();
                break;
            }
            case 59: {
                ASTNode parent = ((VariableDeclarationFragment)astNode).getParent();
                if (!(parent instanceof BodyDeclaration)) break;
                extendsMods = ((BodyDeclaration)parent).modifiers();
                break;
            }
            default: {
                return null;
            }
        }
        if (extendsMods != null) {
            for (IExtendedModifier extMod : extendsMods) {
                ITypeBinding annotationType;
                Annotation annotation;
                IAnnotationBinding annotationBinding;
                if (!extMod.isAnnotation() || (annotationBinding = (annotation = (Annotation)extMod).resolveAnnotationBinding()) == null || (annotationType = annotationBinding.getAnnotationType()) == null || !nonNullByDefaultNames.contains(annotationType.getQualifiedName())) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(annotationBinding);
            }
            if (list != null) {
                return list;
            }
        }
        return null;
    }

    public RedundantNullnessTypeAnnotationsFilter(String nonNullAnnotationName, String nullableAnnotationName, EnumSet<ImportRewrite.TypeLocation> nonNullByDefaultLocations) {
        this.fNonNullAnnotationName = nonNullAnnotationName;
        this.fNullableAnnotationName = nullableAnnotationName;
        this.fNonNullByDefaultLocations = nonNullByDefaultLocations;
    }

    public IAnnotationBinding[] removeUnwantedTypeAnnotations(IAnnotationBinding[] annotations, ImportRewrite.TypeLocation location, ITypeBinding type) {
        if (location == ImportRewrite.TypeLocation.OTHER) {
            return NO_ANNOTATIONS;
        }
        if (type.isTypeVariable() || type.isWildcardType()) {
            return annotations;
        }
        boolean excludeAllNullAnnotations = NEVER_NULLNESS_LOCATIONS.contains(location);
        if (excludeAllNullAnnotations || this.fNonNullByDefaultLocations.contains(location)) {
            ArrayList<IAnnotationBinding> list = new ArrayList<IAnnotationBinding>(annotations.length);
            IAnnotationBinding[] iAnnotationBindingArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                ITypeBinding annotationType = annotation.getAnnotationType();
                if (!(annotationType != null && (annotationType.getQualifiedName().equals(this.fNonNullAnnotationName) || excludeAllNullAnnotations && annotationType.getQualifiedName().equals(this.fNullableAnnotationName)))) {
                    list.add(annotation);
                }
                ++n2;
            }
            return list.size() == annotations.length ? annotations : list.toArray(new IAnnotationBinding[list.size()]);
        }
        return annotations;
    }
}

