/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.MalformedTreeException;

public class OverrideCompletionProposal {
    private IJavaProject fJavaProject;
    private String fMethodName;
    private String[] fParamTypes;
    private ICompilationUnit fCompilationUnit;
    private String replacementString;

    public OverrideCompletionProposal(ICompilationUnit cu, String methodName, String[] paramTypes, String completionProposal) {
        this.fCompilationUnit = cu;
        Assert.isNotNull((Object)cu.getJavaProject());
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)paramTypes);
        Assert.isNotNull((Object)cu);
        this.fParamTypes = paramTypes;
        this.fMethodName = methodName;
        this.fJavaProject = cu.getJavaProject();
        StringBuilder buffer = new StringBuilder();
        buffer.append(completionProposal);
        buffer.append(" {};");
        this.replacementString = buffer.toString();
    }

    private CompilationUnit getRecoveredAST(IDocument document, int offset, Document recoveredDocument) {
        CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)this.fCompilationUnit, CoreASTProvider.WAIT_YES, null);
        if (ast != null) {
            recoveredDocument.set(document.get());
            return ast;
        }
        char[] content = document.get().toCharArray();
        int index = offset - 1;
        while (index >= 0 && Character.isJavaIdentifierPart(content[index])) {
            content[index] = 32;
            --index;
        }
        recoveredDocument.set(new String(content));
        ASTParser parser = ASTParser.newParser((int)15);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setSource(content);
        parser.setUnitName(this.fCompilationUnit.getElementName());
        parser.setProject(this.fCompilationUnit.getJavaProject());
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    public String updateReplacementString(IDocument document, int offset, ImportRewrite importRewrite, boolean snippetStringSupport) throws CoreException, BadLocationException {
        Document recoveredDocument = new Document();
        CompilationUnit unit = this.getRecoveredAST(document, offset, recoveredDocument);
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(unit, offset, importRewrite);
        ITypeBinding declaringType = null;
        ChildListPropertyDescriptor descriptor = null;
        ASTNode node = NodeFinder.perform((ASTNode)unit, (int)offset, (int)1);
        node = ASTResolving.findParentType((ASTNode)node);
        String result = null;
        if (node instanceof AnonymousClassDeclaration) {
            declaringType = ((AnonymousClassDeclaration)node).resolveBinding();
            descriptor = AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        } else if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)node;
            descriptor = declaration.getBodyDeclarationsProperty();
            declaringType = declaration.resolveBinding();
        }
        if (declaringType != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)unit.getAST());
            IMethodBinding methodToOverride = Bindings.findMethodInHierarchy((ITypeBinding)declaringType, (String)this.fMethodName, (String[])this.fParamTypes);
            if (methodToOverride == null && declaringType.isInterface()) {
                methodToOverride = Bindings.findMethodInType((ITypeBinding)node.getAST().resolveWellKnownType("java.lang.Object"), (String)this.fMethodName, (String[])this.fParamTypes);
            }
            if (methodToOverride != null) {
                CodeGenerationSettings settings = PreferenceManager.getCodeGenerationSettings((IResource)this.fJavaProject.getProject());
                MethodDeclaration stub = StubUtility2Core.createImplementationStubCore((ICompilationUnit)this.fCompilationUnit, (ASTRewrite)rewrite, (ImportRewrite)importRewrite, (ImportRewrite.ImportRewriteContext)context, (IMethodBinding)methodToOverride, (ITypeBinding)declaringType, (CodeGenerationSettings)settings, (boolean)declaringType.isInterface(), (ASTNode)node, (boolean)snippetStringSupport);
                ListRewrite rewriter = rewrite.getListRewrite(node, descriptor);
                rewriter.insertFirst((ASTNode)stub, null);
                ITrackedNodePosition position = rewrite.track((ASTNode)stub);
                try {
                    Map options = this.fJavaProject.getOptions(true);
                    rewrite.rewriteAST((IDocument)recoveredDocument, options).apply((IDocument)recoveredDocument);
                    String generatedCode = recoveredDocument.get(position.getStartPosition(), position.getLength());
                    String indentAt = OverrideCompletionProposal.getIndentAt((IDocument)recoveredDocument, position.getStartPosition(), settings);
                    int generatedIndent = IndentManipulation.measureIndentUnits((CharSequence)indentAt, (int)settings.tabWidth, (int)settings.indentWidth);
                    generatedIndent = Math.max(1, generatedIndent);
                    String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    result = IndentManipulation.changeIndent((String)generatedCode, (int)generatedIndent, (int)settings.tabWidth, (int)settings.indentWidth, (String)"", (String)delimiter);
                }
                catch (BadLocationException | MalformedTreeException exception) {
                    JavaLanguageServerPlugin.logException("Unable to compute override proposal", exception);
                }
            }
        }
        if (result == null) {
            return this.replacementString;
        }
        return result;
    }

    private static String getIndentAt(IDocument document, int offset, CodeGenerationSettings settings) {
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            return IndentManipulation.extractIndentString((String)document.get(region.getOffset(), region.getLength()), (int)settings.tabWidth, (int)settings.indentWidth);
        }
        catch (BadLocationException e) {
            return "";
        }
    }
}

