"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractViewContribution = exports.bindViewContribution = void 0;
const inversify_1 = require("inversify");
const common_1 = require("../../common");
const keybinding_1 = require("../keybinding");
const widget_manager_1 = require("../widget-manager");
const common_frontend_contribution_1 = require("../common-frontend-contribution");
const application_shell_1 = require("./application-shell");
const quick_input_1 = require("../quick-input");
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function bindViewContribution(bind, identifier) {
    const syntax = bind(identifier).toSelf().inSingletonScope();
    bind(common_1.CommandContribution).toService(identifier);
    bind(keybinding_1.KeybindingContribution).toService(identifier);
    bind(common_1.MenuContribution).toService(identifier);
    return syntax;
}
exports.bindViewContribution = bindViewContribution;
/**
 * An abstract superclass for frontend contributions that add a view to the application shell.
 */
let AbstractViewContribution = class AbstractViewContribution {
    constructor(options) {
        this.options = options;
        if (options.toggleCommandId) {
            this.toggleCommand = {
                id: options.toggleCommandId,
                label: 'Toggle ' + this.viewLabel + ' View'
            };
        }
    }
    get viewId() {
        return this.options.widgetId;
    }
    get viewLabel() {
        return this.options.widgetName;
    }
    get defaultViewOptions() {
        return this.options.defaultWidgetOptions;
    }
    get widget() {
        return this.widgetManager.getOrCreateWidget(this.viewId);
    }
    tryGetWidget() {
        return this.widgetManager.tryGetWidget(this.viewId);
    }
    async openView(args = {}) {
        const shell = this.shell;
        const widget = await this.widgetManager.getOrCreateWidget(this.options.viewContainerId || this.viewId);
        const tabBar = shell.getTabBarFor(widget);
        const area = shell.getAreaFor(widget);
        if (!tabBar) {
            // The widget is not attached yet, so add it to the shell
            const widgetArgs = Object.assign(Object.assign({}, this.defaultViewOptions), args);
            await shell.addWidget(widget, widgetArgs);
        }
        else if (args.toggle && area && shell.isExpanded(area) && tabBar.currentTitle === widget.title) {
            // The widget is attached and visible, so collapse the containing panel (toggle)
            switch (area) {
                case 'left':
                case 'right':
                    await shell.collapsePanel(area);
                    break;
                case 'bottom':
                    // Don't collapse the bottom panel if it's currently split
                    if (shell.bottomAreaTabBars.length === 1) {
                        await shell.collapsePanel('bottom');
                    }
                    break;
                default:
                    // The main area cannot be collapsed, so close the widget
                    await this.closeView();
            }
            return this.widget;
        }
        if (widget.isAttached && args.activate) {
            await shell.activateWidget(this.viewId);
        }
        else if (widget.isAttached && args.reveal) {
            await shell.revealWidget(this.viewId);
        }
        return this.widget;
    }
    registerCommands(commands) {
        var _a;
        if (this.toggleCommand) {
            commands.registerCommand(this.toggleCommand, {
                execute: () => this.toggleView()
            });
        }
        (_a = this.quickView) === null || _a === void 0 ? void 0 : _a.registerItem({
            label: this.viewLabel,
            open: () => this.openView({ activate: true })
        });
    }
    async closeView() {
        const widget = await this.shell.closeWidget(this.viewId);
        return widget;
    }
    toggleView() {
        return this.openView({
            toggle: true,
            activate: true
        });
    }
    registerMenus(menus) {
        if (this.toggleCommand) {
            menus.registerMenuAction(common_frontend_contribution_1.CommonMenus.VIEW_VIEWS, {
                commandId: this.toggleCommand.id,
                label: this.viewLabel
            });
        }
    }
    registerKeybindings(keybindings) {
        if (this.toggleCommand && this.options.toggleKeybinding) {
            keybindings.registerKeybinding({
                command: this.toggleCommand.id,
                keybinding: this.options.toggleKeybinding
            });
        }
    }
};
__decorate([
    (0, inversify_1.inject)(widget_manager_1.WidgetManager),
    __metadata("design:type", widget_manager_1.WidgetManager)
], AbstractViewContribution.prototype, "widgetManager", void 0);
__decorate([
    (0, inversify_1.inject)(application_shell_1.ApplicationShell),
    __metadata("design:type", application_shell_1.ApplicationShell)
], AbstractViewContribution.prototype, "shell", void 0);
__decorate([
    (0, inversify_1.inject)(quick_input_1.QuickViewService),
    (0, inversify_1.optional)(),
    __metadata("design:type", quick_input_1.QuickViewService)
], AbstractViewContribution.prototype, "quickView", void 0);
AbstractViewContribution = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [Object])
], AbstractViewContribution);
exports.AbstractViewContribution = AbstractViewContribution;
//# sourceMappingURL=view-contribution.js.map