/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as nls from '../../../nls';
import { Emitter } from '../../../base/common/event';
import { Registry } from '../../registry/common/platform';
import * as types from '../../../base/common/types';
import { Extensions as JSONExtensions } from '../../jsonschemas/common/jsonContributionRegistry';
export var Extensions = {
    Configuration: 'base.contributions.configuration'
};
export var allSettings = { properties: {}, patternProperties: {} };
export var applicationSettings = { properties: {}, patternProperties: {} };
export var machineSettings = { properties: {}, patternProperties: {} };
export var machineOverridableSettings = { properties: {}, patternProperties: {} };
export var windowSettings = { properties: {}, patternProperties: {} };
export var resourceSettings = { properties: {}, patternProperties: {} };
export var resourceLanguageSettingsSchemaId = 'vscode://schemas/settings/resourceLanguage';
var contributionRegistry = Registry.as(JSONExtensions.JSONContribution);
var ConfigurationRegistry = /** @class */ (function () {
    function ConfigurationRegistry() {
        this.overrideIdentifiers = new Set();
        this._onDidSchemaChange = new Emitter();
        this.onDidSchemaChange = this._onDidSchemaChange.event;
        this._onDidUpdateConfiguration = new Emitter();
        this.onDidUpdateConfiguration = this._onDidUpdateConfiguration.event;
        this.defaultValues = {};
        this.defaultLanguageConfigurationOverridesNode = {
            id: 'defaultOverrides',
            title: nls.localize('defaultLanguageConfigurationOverrides.title', "Default Language Configuration Overrides"),
            properties: {}
        };
        this.configurationContributors = [this.defaultLanguageConfigurationOverridesNode];
        this.resourceLanguageSettingsSchema = { properties: {}, patternProperties: {}, additionalProperties: false, errorMessage: 'Unknown editor configuration setting', allowTrailingCommas: true, allowComments: true };
        this.configurationProperties = {};
        this.excludedConfigurationProperties = {};
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
    }
    ConfigurationRegistry.prototype.registerConfiguration = function (configuration, validate) {
        if (validate === void 0) { validate = true; }
        this.registerConfigurations([configuration], validate);
    };
    ConfigurationRegistry.prototype.registerConfigurations = function (configurations, validate) {
        var _this = this;
        if (validate === void 0) { validate = true; }
        var properties = [];
        configurations.forEach(function (configuration) {
            properties.push.apply(properties, __spreadArray([], __read(_this.validateAndRegisterProperties(configuration, validate)))); // fills in defaults
            _this.configurationContributors.push(configuration);
            _this.registerJSONConfiguration(configuration);
        });
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire(properties);
    };
    ConfigurationRegistry.prototype.deregisterConfigurations = function (configurations) {
        var e_1, _a;
        var _this = this;
        var properties = [];
        var deregisterConfiguration = function (configuration) {
            if (configuration.properties) {
                for (var key in configuration.properties) {
                    properties.push(key);
                    delete _this.configurationProperties[key];
                    _this.removeFromSchema(key, configuration.properties[key]);
                }
            }
            if (configuration.allOf) {
                configuration.allOf.forEach(function (node) { return deregisterConfiguration(node); });
            }
        };
        try {
            for (var configurations_1 = __values(configurations), configurations_1_1 = configurations_1.next(); !configurations_1_1.done; configurations_1_1 = configurations_1.next()) {
                var configuration = configurations_1_1.value;
                deregisterConfiguration(configuration);
                var index = this.configurationContributors.indexOf(configuration);
                if (index !== -1) {
                    this.configurationContributors.splice(index, 1);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (configurations_1_1 && !configurations_1_1.done && (_a = configurations_1.return)) _a.call(configurations_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire(properties);
    };
    ConfigurationRegistry.prototype.registerDefaultConfigurations = function (defaultConfigurations) {
        var e_2, _a;
        var properties = [];
        var overrideIdentifiers = [];
        try {
            for (var defaultConfigurations_1 = __values(defaultConfigurations), defaultConfigurations_1_1 = defaultConfigurations_1.next(); !defaultConfigurations_1_1.done; defaultConfigurations_1_1 = defaultConfigurations_1.next()) {
                var defaultConfiguration = defaultConfigurations_1_1.value;
                for (var key in defaultConfiguration) {
                    properties.push(key);
                    if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
                        this.defaultValues[key] = __assign(__assign({}, (this.defaultValues[key] || {})), defaultConfiguration[key]);
                        var property = {
                            type: 'object',
                            default: this.defaultValues[key],
                            description: nls.localize('defaultLanguageConfiguration.description', "Configure settings to be overridden for {0} language.", key),
                            $ref: resourceLanguageSettingsSchemaId
                        };
                        overrideIdentifiers.push(overrideIdentifierFromKey(key));
                        this.configurationProperties[key] = property;
                        this.defaultLanguageConfigurationOverridesNode.properties[key] = property;
                    }
                    else {
                        this.defaultValues[key] = defaultConfiguration[key];
                        var property = this.configurationProperties[key];
                        if (property) {
                            this.updatePropertyDefaultValue(key, property);
                            this.updateSchema(key, property);
                        }
                    }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (defaultConfigurations_1_1 && !defaultConfigurations_1_1.done && (_a = defaultConfigurations_1.return)) _a.call(defaultConfigurations_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        this.registerOverrideIdentifiers(overrideIdentifiers);
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire(properties);
    };
    ConfigurationRegistry.prototype.deregisterDefaultConfigurations = function (defaultConfigurations) {
        var e_3, _a;
        var properties = [];
        try {
            for (var defaultConfigurations_2 = __values(defaultConfigurations), defaultConfigurations_2_1 = defaultConfigurations_2.next(); !defaultConfigurations_2_1.done; defaultConfigurations_2_1 = defaultConfigurations_2.next()) {
                var defaultConfiguration = defaultConfigurations_2_1.value;
                for (var key in defaultConfiguration) {
                    properties.push(key);
                    delete this.defaultValues[key];
                    if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
                        delete this.configurationProperties[key];
                        delete this.defaultLanguageConfigurationOverridesNode.properties[key];
                    }
                    else {
                        var property = this.configurationProperties[key];
                        if (property) {
                            this.updatePropertyDefaultValue(key, property);
                            this.updateSchema(key, property);
                        }
                    }
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (defaultConfigurations_2_1 && !defaultConfigurations_2_1.done && (_a = defaultConfigurations_2.return)) _a.call(defaultConfigurations_2);
            }
            finally { if (e_3) throw e_3.error; }
        }
        this.updateOverridePropertyPatternKey();
        this._onDidSchemaChange.fire();
        this._onDidUpdateConfiguration.fire(properties);
    };
    ConfigurationRegistry.prototype.notifyConfigurationSchemaUpdated = function () {
        var configurations = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            configurations[_i] = arguments[_i];
        }
        this._onDidSchemaChange.fire();
    };
    ConfigurationRegistry.prototype.registerOverrideIdentifiers = function (overrideIdentifiers) {
        var e_4, _a;
        try {
            for (var overrideIdentifiers_1 = __values(overrideIdentifiers), overrideIdentifiers_1_1 = overrideIdentifiers_1.next(); !overrideIdentifiers_1_1.done; overrideIdentifiers_1_1 = overrideIdentifiers_1.next()) {
                var overrideIdentifier = overrideIdentifiers_1_1.value;
                this.overrideIdentifiers.add(overrideIdentifier);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (overrideIdentifiers_1_1 && !overrideIdentifiers_1_1.done && (_a = overrideIdentifiers_1.return)) _a.call(overrideIdentifiers_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
        this.updateOverridePropertyPatternKey();
    };
    ConfigurationRegistry.prototype.validateAndRegisterProperties = function (configuration, validate, scope) {
        var e_5, _a;
        if (validate === void 0) { validate = true; }
        if (scope === void 0) { scope = 3 /* WINDOW */; }
        scope = types.isUndefinedOrNull(configuration.scope) ? scope : configuration.scope;
        var propertyKeys = [];
        var properties = configuration.properties;
        if (properties) {
            for (var key in properties) {
                if (validate && validateProperty(key)) {
                    delete properties[key];
                    continue;
                }
                var property = properties[key];
                // update default value
                this.updatePropertyDefaultValue(key, property);
                // update scope
                if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
                    property.scope = undefined; // No scope for overridable properties `[${identifier}]`
                }
                else {
                    property.scope = types.isUndefinedOrNull(property.scope) ? scope : property.scope;
                }
                // Add to properties maps
                // Property is included by default if 'included' is unspecified
                if (properties[key].hasOwnProperty('included') && !properties[key].included) {
                    this.excludedConfigurationProperties[key] = properties[key];
                    delete properties[key];
                    continue;
                }
                else {
                    this.configurationProperties[key] = properties[key];
                }
                if (!properties[key].deprecationMessage && properties[key].markdownDeprecationMessage) {
                    // If not set, default deprecationMessage to the markdown source
                    properties[key].deprecationMessage = properties[key].markdownDeprecationMessage;
                }
                propertyKeys.push(key);
            }
        }
        var subNodes = configuration.allOf;
        if (subNodes) {
            try {
                for (var subNodes_1 = __values(subNodes), subNodes_1_1 = subNodes_1.next(); !subNodes_1_1.done; subNodes_1_1 = subNodes_1.next()) {
                    var node = subNodes_1_1.value;
                    propertyKeys.push.apply(propertyKeys, __spreadArray([], __read(this.validateAndRegisterProperties(node, validate, scope))));
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (subNodes_1_1 && !subNodes_1_1.done && (_a = subNodes_1.return)) _a.call(subNodes_1);
                }
                finally { if (e_5) throw e_5.error; }
            }
        }
        return propertyKeys;
    };
    ConfigurationRegistry.prototype.getConfigurations = function () {
        return this.configurationContributors;
    };
    ConfigurationRegistry.prototype.getConfigurationProperties = function () {
        return this.configurationProperties;
    };
    ConfigurationRegistry.prototype.getExcludedConfigurationProperties = function () {
        return this.excludedConfigurationProperties;
    };
    ConfigurationRegistry.prototype.registerJSONConfiguration = function (configuration) {
        var _this = this;
        var register = function (configuration) {
            var properties = configuration.properties;
            if (properties) {
                for (var key in properties) {
                    _this.updateSchema(key, properties[key]);
                }
            }
            var subNodes = configuration.allOf;
            if (subNodes) {
                subNodes.forEach(register);
            }
        };
        register(configuration);
    };
    ConfigurationRegistry.prototype.updateSchema = function (key, property) {
        allSettings.properties[key] = property;
        switch (property.scope) {
            case 1 /* APPLICATION */:
                applicationSettings.properties[key] = property;
                break;
            case 2 /* MACHINE */:
                machineSettings.properties[key] = property;
                break;
            case 6 /* MACHINE_OVERRIDABLE */:
                machineOverridableSettings.properties[key] = property;
                break;
            case 3 /* WINDOW */:
                windowSettings.properties[key] = property;
                break;
            case 4 /* RESOURCE */:
                resourceSettings.properties[key] = property;
                break;
            case 5 /* LANGUAGE_OVERRIDABLE */:
                resourceSettings.properties[key] = property;
                this.resourceLanguageSettingsSchema.properties[key] = property;
                break;
        }
    };
    ConfigurationRegistry.prototype.removeFromSchema = function (key, property) {
        delete allSettings.properties[key];
        switch (property.scope) {
            case 1 /* APPLICATION */:
                delete applicationSettings.properties[key];
                break;
            case 2 /* MACHINE */:
                delete machineSettings.properties[key];
                break;
            case 6 /* MACHINE_OVERRIDABLE */:
                delete machineOverridableSettings.properties[key];
                break;
            case 3 /* WINDOW */:
                delete windowSettings.properties[key];
                break;
            case 4 /* RESOURCE */:
            case 5 /* LANGUAGE_OVERRIDABLE */:
                delete resourceSettings.properties[key];
                break;
        }
    };
    ConfigurationRegistry.prototype.updateOverridePropertyPatternKey = function () {
        var e_6, _a;
        try {
            for (var _b = __values(this.overrideIdentifiers.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var overrideIdentifier = _c.value;
                var overrideIdentifierProperty = "[" + overrideIdentifier + "]";
                var resourceLanguagePropertiesSchema = {
                    type: 'object',
                    description: nls.localize('overrideSettings.defaultDescription', "Configure editor settings to be overridden for a language."),
                    errorMessage: nls.localize('overrideSettings.errorMessage', "This setting does not support per-language configuration."),
                    $ref: resourceLanguageSettingsSchemaId,
                };
                this.updatePropertyDefaultValue(overrideIdentifierProperty, resourceLanguagePropertiesSchema);
                allSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
                applicationSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
                machineSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
                machineOverridableSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
                windowSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
                resourceSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_6) throw e_6.error; }
        }
        this._onDidSchemaChange.fire();
    };
    ConfigurationRegistry.prototype.updatePropertyDefaultValue = function (key, property) {
        var defaultValue = this.defaultValues[key];
        if (types.isUndefined(defaultValue)) {
            defaultValue = property.default;
        }
        if (types.isUndefined(defaultValue)) {
            defaultValue = getDefaultValue(property.type);
        }
        property.default = defaultValue;
    };
    return ConfigurationRegistry;
}());
var OVERRIDE_PROPERTY = '\\[.*\\]$';
export var OVERRIDE_PROPERTY_PATTERN = new RegExp(OVERRIDE_PROPERTY);
export function overrideIdentifierFromKey(key) {
    return key.substring(1, key.length - 1);
}
export function getDefaultValue(type) {
    var t = Array.isArray(type) ? type[0] : type;
    switch (t) {
        case 'boolean':
            return false;
        case 'integer':
        case 'number':
            return 0;
        case 'string':
            return '';
        case 'array':
            return [];
        case 'object':
            return {};
        default:
            return null;
    }
}
var configurationRegistry = new ConfigurationRegistry();
Registry.add(Extensions.Configuration, configurationRegistry);
export function validateProperty(property) {
    if (!property.trim()) {
        return nls.localize('config.property.empty', "Cannot register an empty property");
    }
    if (OVERRIDE_PROPERTY_PATTERN.test(property)) {
        return nls.localize('config.property.languageDefault', "Cannot register '{0}'. This matches property pattern '\\\\[.*\\\\]$' for describing language specific editor settings. Use 'configurationDefaults' contribution.", property);
    }
    if (configurationRegistry.getConfigurationProperties()[property] !== undefined) {
        return nls.localize('config.property.duplicate', "Cannot register '{0}'. This property is already registered.", property);
    }
    return null;
}
export function getScopes() {
    var e_7, _a;
    var scopes = [];
    var configurationProperties = configurationRegistry.getConfigurationProperties();
    try {
        for (var _b = __values(Object.keys(configurationProperties)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            scopes.push([key, configurationProperties[key].scope]);
        }
    }
    catch (e_7_1) { e_7 = { error: e_7_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_7) throw e_7.error; }
    }
    scopes.push(['launch', 4 /* RESOURCE */]);
    scopes.push(['task', 4 /* RESOURCE */]);
    return scopes;
}
