/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { Action, Separator, SubmenuAction } from '../../../base/common/actions';
import { createSyncDescriptor } from '../../instantiation/common/descriptors';
import { createDecorator } from '../../instantiation/common/instantiation';
import { KeybindingsRegistry } from '../../keybinding/common/keybindingsRegistry';
import { ContextKeyExpr, IContextKeyService } from '../../contextkey/common/contextkey';
import { ICommandService, CommandsRegistry } from '../../commands/common/commands';
import { DisposableStore, toDisposable } from '../../../base/common/lifecycle';
import { Emitter } from '../../../base/common/event';
import { ThemeIcon } from '../../theme/common/themeService';
import { Iterable } from '../../../base/common/iterator';
import { LinkedList } from '../../../base/common/linkedList';
import { CSSIcon } from '../../../base/common/codicons';
export function isIMenuItem(item) {
    return item.command !== undefined;
}
export function isISubmenuItem(item) {
    return item.submenu !== undefined;
}
var MenuId = /** @class */ (function () {
    function MenuId(debugName) {
        this.id = MenuId._idPool++;
        this._debugName = debugName;
    }
    MenuId._idPool = 0;
    MenuId.CommandPalette = new MenuId('CommandPalette');
    MenuId.DebugBreakpointsContext = new MenuId('DebugBreakpointsContext');
    MenuId.DebugCallStackContext = new MenuId('DebugCallStackContext');
    MenuId.DebugConsoleContext = new MenuId('DebugConsoleContext');
    MenuId.DebugVariablesContext = new MenuId('DebugVariablesContext');
    MenuId.DebugWatchContext = new MenuId('DebugWatchContext');
    MenuId.DebugToolBar = new MenuId('DebugToolBar');
    MenuId.EditorContext = new MenuId('EditorContext');
    MenuId.EditorContextPeek = new MenuId('EditorContextPeek');
    MenuId.EditorTitle = new MenuId('EditorTitle');
    MenuId.EditorTitleRun = new MenuId('EditorTitleRun');
    MenuId.EditorTitleContext = new MenuId('EditorTitleContext');
    MenuId.EmptyEditorGroupContext = new MenuId('EmptyEditorGroupContext');
    MenuId.ExplorerContext = new MenuId('ExplorerContext');
    MenuId.ExtensionContext = new MenuId('ExtensionContext');
    MenuId.GlobalActivity = new MenuId('GlobalActivity');
    MenuId.MenubarAppearanceMenu = new MenuId('MenubarAppearanceMenu');
    MenuId.MenubarDebugMenu = new MenuId('MenubarDebugMenu');
    MenuId.MenubarEditMenu = new MenuId('MenubarEditMenu');
    MenuId.MenubarFileMenu = new MenuId('MenubarFileMenu');
    MenuId.MenubarGoMenu = new MenuId('MenubarGoMenu');
    MenuId.MenubarHelpMenu = new MenuId('MenubarHelpMenu');
    MenuId.MenubarLayoutMenu = new MenuId('MenubarLayoutMenu');
    MenuId.MenubarNewBreakpointMenu = new MenuId('MenubarNewBreakpointMenu');
    MenuId.MenubarPreferencesMenu = new MenuId('MenubarPreferencesMenu');
    MenuId.MenubarRecentMenu = new MenuId('MenubarRecentMenu');
    MenuId.MenubarSelectionMenu = new MenuId('MenubarSelectionMenu');
    MenuId.MenubarSwitchEditorMenu = new MenuId('MenubarSwitchEditorMenu');
    MenuId.MenubarSwitchGroupMenu = new MenuId('MenubarSwitchGroupMenu');
    MenuId.MenubarTerminalMenu = new MenuId('MenubarTerminalMenu');
    MenuId.MenubarViewMenu = new MenuId('MenubarViewMenu');
    MenuId.MenubarHomeMenu = new MenuId('MenubarHomeMenu');
    MenuId.OpenEditorsContext = new MenuId('OpenEditorsContext');
    MenuId.ProblemsPanelContext = new MenuId('ProblemsPanelContext');
    MenuId.SCMChangeContext = new MenuId('SCMChangeContext');
    MenuId.SCMResourceContext = new MenuId('SCMResourceContext');
    MenuId.SCMResourceFolderContext = new MenuId('SCMResourceFolderContext');
    MenuId.SCMResourceGroupContext = new MenuId('SCMResourceGroupContext');
    MenuId.SCMSourceControl = new MenuId('SCMSourceControl');
    MenuId.SCMTitle = new MenuId('SCMTitle');
    MenuId.SearchContext = new MenuId('SearchContext');
    MenuId.StatusBarWindowIndicatorMenu = new MenuId('StatusBarWindowIndicatorMenu');
    MenuId.TestItem = new MenuId('TestItem');
    MenuId.TouchBarContext = new MenuId('TouchBarContext');
    MenuId.TitleBarContext = new MenuId('TitleBarContext');
    MenuId.TunnelContext = new MenuId('TunnelContext');
    MenuId.TunnelPortInline = new MenuId('TunnelInline');
    MenuId.TunnelTitle = new MenuId('TunnelTitle');
    MenuId.TunnelLocalAddressInline = new MenuId('TunnelLocalAddressInline');
    MenuId.TunnelOriginInline = new MenuId('TunnelOriginInline');
    MenuId.ViewItemContext = new MenuId('ViewItemContext');
    MenuId.ViewContainerTitle = new MenuId('ViewContainerTitle');
    MenuId.ViewContainerTitleContext = new MenuId('ViewContainerTitleContext');
    MenuId.ViewTitle = new MenuId('ViewTitle');
    MenuId.ViewTitleContext = new MenuId('ViewTitleContext');
    MenuId.CommentThreadTitle = new MenuId('CommentThreadTitle');
    MenuId.CommentThreadActions = new MenuId('CommentThreadActions');
    MenuId.CommentTitle = new MenuId('CommentTitle');
    MenuId.CommentActions = new MenuId('CommentActions');
    MenuId.NotebookCellTitle = new MenuId('NotebookCellTitle');
    MenuId.NotebookCellInsert = new MenuId('NotebookCellInsert');
    MenuId.NotebookCellBetween = new MenuId('NotebookCellBetween');
    MenuId.NotebookCellListTop = new MenuId('NotebookCellTop');
    MenuId.NotebookDiffCellInputTitle = new MenuId('NotebookDiffCellInputTitle');
    MenuId.NotebookDiffCellMetadataTitle = new MenuId('NotebookDiffCellMetadataTitle');
    MenuId.NotebookDiffCellOutputsTitle = new MenuId('NotebookDiffCellOutputsTitle');
    MenuId.BulkEditTitle = new MenuId('BulkEditTitle');
    MenuId.BulkEditContext = new MenuId('BulkEditContext');
    MenuId.TimelineItemContext = new MenuId('TimelineItemContext');
    MenuId.TimelineTitle = new MenuId('TimelineTitle');
    MenuId.TimelineTitleContext = new MenuId('TimelineTitleContext');
    MenuId.AccountsContext = new MenuId('AccountsContext');
    MenuId.PanelTitle = new MenuId('PanelTitle');
    MenuId.TerminalContext = new MenuId('TerminalContext');
    return MenuId;
}());
export { MenuId };
export var IMenuService = createDecorator('menuService');
export var MenuRegistry = new /** @class */ (function () {
    function class_1() {
        this._commands = new Map();
        this._menuItems = new Map();
        this._onDidChangeMenu = new Emitter();
        this.onDidChangeMenu = this._onDidChangeMenu.event;
        this._commandPaletteChangeEvent = {
            has: function (id) { return id === MenuId.CommandPalette; }
        };
    }
    class_1.prototype.addCommand = function (command) {
        return this.addCommands(Iterable.single(command));
    };
    class_1.prototype.addCommands = function (commands) {
        var e_1, _a;
        var _this = this;
        try {
            for (var commands_1 = __values(commands), commands_1_1 = commands_1.next(); !commands_1_1.done; commands_1_1 = commands_1.next()) {
                var command = commands_1_1.value;
                this._commands.set(command.id, command);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (commands_1_1 && !commands_1_1.done && (_a = commands_1.return)) _a.call(commands_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._onDidChangeMenu.fire(this._commandPaletteChangeEvent);
        return toDisposable(function () {
            var e_2, _a;
            var didChange = false;
            try {
                for (var commands_2 = __values(commands), commands_2_1 = commands_2.next(); !commands_2_1.done; commands_2_1 = commands_2.next()) {
                    var command = commands_2_1.value;
                    didChange = _this._commands.delete(command.id) || didChange;
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (commands_2_1 && !commands_2_1.done && (_a = commands_2.return)) _a.call(commands_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
            if (didChange) {
                _this._onDidChangeMenu.fire(_this._commandPaletteChangeEvent);
            }
        });
    };
    class_1.prototype.getCommand = function (id) {
        return this._commands.get(id);
    };
    class_1.prototype.getCommands = function () {
        var map = new Map();
        this._commands.forEach(function (value, key) { return map.set(key, value); });
        return map;
    };
    class_1.prototype.appendMenuItem = function (id, item) {
        return this.appendMenuItems(Iterable.single({ id: id, item: item }));
    };
    class_1.prototype.appendMenuItems = function (items) {
        var e_3, _a;
        var _this = this;
        var changedIds = new Set();
        var toRemove = new LinkedList();
        try {
            for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                var _b = items_1_1.value, id = _b.id, item = _b.item;
                var list = this._menuItems.get(id);
                if (!list) {
                    list = new LinkedList();
                    this._menuItems.set(id, list);
                }
                toRemove.push(list.push(item));
                changedIds.add(id);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        this._onDidChangeMenu.fire(changedIds);
        return toDisposable(function () {
            var e_4, _a;
            if (toRemove.size > 0) {
                try {
                    for (var toRemove_1 = __values(toRemove), toRemove_1_1 = toRemove_1.next(); !toRemove_1_1.done; toRemove_1_1 = toRemove_1.next()) {
                        var fn = toRemove_1_1.value;
                        fn();
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (toRemove_1_1 && !toRemove_1_1.done && (_a = toRemove_1.return)) _a.call(toRemove_1);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
                _this._onDidChangeMenu.fire(changedIds);
                toRemove.clear();
            }
        });
    };
    class_1.prototype.getMenuItems = function (id) {
        var result;
        if (this._menuItems.has(id)) {
            result = __spreadArray([], __read(this._menuItems.get(id)));
        }
        else {
            result = [];
        }
        if (id === MenuId.CommandPalette) {
            // CommandPalette is special because it shows
            // all commands by default
            this._appendImplicitItems(result);
        }
        return result;
    };
    class_1.prototype._appendImplicitItems = function (result) {
        var e_5, _a;
        var set = new Set();
        try {
            for (var result_1 = __values(result), result_1_1 = result_1.next(); !result_1_1.done; result_1_1 = result_1.next()) {
                var item = result_1_1.value;
                if (isIMenuItem(item)) {
                    set.add(item.command.id);
                    if (item.alt) {
                        set.add(item.alt.id);
                    }
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (result_1_1 && !result_1_1.done && (_a = result_1.return)) _a.call(result_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
        this._commands.forEach(function (command, id) {
            if (!set.has(id)) {
                result.push({ command: command });
            }
        });
    };
    return class_1;
}());
var ExecuteCommandAction = /** @class */ (function (_super) {
    __extends(ExecuteCommandAction, _super);
    function ExecuteCommandAction(id, label, _commandService) {
        var _this = _super.call(this, id, label) || this;
        _this._commandService = _commandService;
        return _this;
    }
    ExecuteCommandAction.prototype.run = function () {
        var _a;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return (_a = this._commandService).executeCommand.apply(_a, __spreadArray([this.id], __read(args)));
    };
    ExecuteCommandAction = __decorate([
        __param(2, ICommandService)
    ], ExecuteCommandAction);
    return ExecuteCommandAction;
}(Action));
export { ExecuteCommandAction };
var SubmenuItemAction = /** @class */ (function (_super) {
    __extends(SubmenuItemAction, _super);
    function SubmenuItemAction(item, _menuService, _contextKeyService, _options) {
        var _this = _super.call(this, "submenuitem." + item.submenu.id, typeof item.title === 'string' ? item.title : item.title.value, [], 'submenu') || this;
        _this.item = item;
        _this._menuService = _menuService;
        _this._contextKeyService = _contextKeyService;
        _this._options = _options;
        return _this;
    }
    Object.defineProperty(SubmenuItemAction.prototype, "actions", {
        get: function () {
            var e_6, _a;
            var result = [];
            var menu = this._menuService.createMenu(this.item.submenu, this._contextKeyService);
            var groups = menu.getActions(this._options);
            menu.dispose();
            try {
                for (var groups_1 = __values(groups), groups_1_1 = groups_1.next(); !groups_1_1.done; groups_1_1 = groups_1.next()) {
                    var _b = __read(groups_1_1.value, 2), actions = _b[1];
                    if (actions.length > 0) {
                        result.push.apply(result, __spreadArray([], __read(actions)));
                        result.push(new Separator());
                    }
                }
            }
            catch (e_6_1) { e_6 = { error: e_6_1 }; }
            finally {
                try {
                    if (groups_1_1 && !groups_1_1.done && (_a = groups_1.return)) _a.call(groups_1);
                }
                finally { if (e_6) throw e_6.error; }
            }
            if (result.length) {
                result.pop(); // remove last separator
            }
            return result;
        },
        enumerable: false,
        configurable: true
    });
    return SubmenuItemAction;
}(SubmenuAction));
export { SubmenuItemAction };
// implements IAction, does NOT extend Action, so that no one
// subscribes to events of Action or modified properties
var MenuItemAction = /** @class */ (function () {
    function MenuItemAction(item, alt, options, contextKeyService, _commandService) {
        var _a;
        this._commandService = _commandService;
        this.id = item.id;
        this.label = typeof item.title === 'string' ? item.title : item.title.value;
        this.tooltip = (_a = item.tooltip) !== null && _a !== void 0 ? _a : '';
        this.enabled = !item.precondition || contextKeyService.contextMatchesRules(item.precondition);
        this.checked = false;
        if (item.toggled) {
            var toggled = (item.toggled.condition ? item.toggled : { condition: item.toggled });
            this.checked = contextKeyService.contextMatchesRules(toggled.condition);
            if (this.checked && toggled.tooltip) {
                this.tooltip = typeof toggled.tooltip === 'string' ? toggled.tooltip : toggled.tooltip.value;
            }
        }
        this.item = item;
        this.alt = alt ? new MenuItemAction(alt, undefined, options, contextKeyService, _commandService) : undefined;
        this._options = options;
        if (ThemeIcon.isThemeIcon(item.icon)) {
            this.class = CSSIcon.asClassName(item.icon);
        }
    }
    MenuItemAction.prototype.dispose = function () {
        // there is NOTHING to dispose and the MenuItemAction should
        // never have anything to dispose as it is a convenience type
        // to bridge into the rendering world.
    };
    MenuItemAction.prototype.run = function () {
        var _a;
        var _b, _c;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var runArgs = [];
        if ((_b = this._options) === null || _b === void 0 ? void 0 : _b.arg) {
            runArgs = __spreadArray(__spreadArray([], __read(runArgs)), [this._options.arg]);
        }
        if ((_c = this._options) === null || _c === void 0 ? void 0 : _c.shouldForwardArgs) {
            runArgs = __spreadArray(__spreadArray([], __read(runArgs)), __read(args));
        }
        return (_a = this._commandService).executeCommand.apply(_a, __spreadArray([this.id], __read(runArgs)));
    };
    MenuItemAction = __decorate([
        __param(3, IContextKeyService),
        __param(4, ICommandService)
    ], MenuItemAction);
    return MenuItemAction;
}());
export { MenuItemAction };
var SyncActionDescriptor = /** @class */ (function () {
    function SyncActionDescriptor(ctor, id, label, keybindings, keybindingContext, keybindingWeight) {
        this._id = id;
        this._label = label;
        this._keybindings = keybindings;
        this._keybindingContext = keybindingContext;
        this._keybindingWeight = keybindingWeight;
        this._descriptor = createSyncDescriptor(ctor, this._id, this._label);
    }
    SyncActionDescriptor.create = function (ctor, id, label, keybindings, keybindingContext, keybindingWeight) {
        return new SyncActionDescriptor(ctor, id, label, keybindings, keybindingContext, keybindingWeight);
    };
    SyncActionDescriptor.from = function (ctor, keybindings, keybindingContext, keybindingWeight) {
        return SyncActionDescriptor.create(ctor, ctor.ID, ctor.LABEL, keybindings, keybindingContext, keybindingWeight);
    };
    Object.defineProperty(SyncActionDescriptor.prototype, "syncDescriptor", {
        get: function () {
            return this._descriptor;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SyncActionDescriptor.prototype, "id", {
        get: function () {
            return this._id;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SyncActionDescriptor.prototype, "label", {
        get: function () {
            return this._label;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SyncActionDescriptor.prototype, "keybindings", {
        get: function () {
            return this._keybindings;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SyncActionDescriptor.prototype, "keybindingContext", {
        get: function () {
            return this._keybindingContext;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SyncActionDescriptor.prototype, "keybindingWeight", {
        get: function () {
            return this._keybindingWeight;
        },
        enumerable: false,
        configurable: true
    });
    return SyncActionDescriptor;
}());
export { SyncActionDescriptor };
var Action2 = /** @class */ (function () {
    function Action2(desc) {
        this.desc = desc;
    }
    return Action2;
}());
export { Action2 };
export function registerAction2(ctor) {
    var e_7, _a;
    var disposables = new DisposableStore();
    var action = new ctor();
    var _b = action.desc, f1 = _b.f1, menu = _b.menu, keybinding = _b.keybinding, description = _b.description, command = __rest(_b, ["f1", "menu", "keybinding", "description"]);
    // command
    disposables.add(CommandsRegistry.registerCommand({
        id: command.id,
        handler: function (accessor) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            return action.run.apply(action, __spreadArray([accessor], __read(args)));
        },
        description: description,
    }));
    // menu
    if (Array.isArray(menu)) {
        disposables.add(MenuRegistry.appendMenuItems(menu.map(function (item) { return ({ id: item.id, item: __assign({ command: command }, item) }); })));
    }
    else if (menu) {
        disposables.add(MenuRegistry.appendMenuItem(menu.id, __assign({ command: command }, menu)));
    }
    if (f1) {
        disposables.add(MenuRegistry.appendMenuItem(MenuId.CommandPalette, { command: command, when: command.precondition }));
        disposables.add(MenuRegistry.addCommand(command));
    }
    // keybinding
    if (Array.isArray(keybinding)) {
        try {
            for (var keybinding_1 = __values(keybinding), keybinding_1_1 = keybinding_1.next(); !keybinding_1_1.done; keybinding_1_1 = keybinding_1.next()) {
                var item = keybinding_1_1.value;
                KeybindingsRegistry.registerKeybindingRule(__assign(__assign({}, item), { id: command.id, when: command.precondition ? ContextKeyExpr.and(command.precondition, item.when) : item.when }));
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (keybinding_1_1 && !keybinding_1_1.done && (_a = keybinding_1.return)) _a.call(keybinding_1);
            }
            finally { if (e_7) throw e_7.error; }
        }
    }
    else if (keybinding) {
        KeybindingsRegistry.registerKeybindingRule(__assign(__assign({}, keybinding), { id: command.id, when: command.precondition ? ContextKeyExpr.and(command.precondition, keybinding.when) : keybinding.when }));
    }
    return disposables;
}
//#endregion
