/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as nls from '../../../nls';
import { KeyChord } from '../../../base/common/keyCodes';
import { EditorAction, registerEditorAction } from '../../browser/editorExtensions';
import { Range } from '../../common/core/range';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { BlockCommentCommand } from './blockCommentCommand';
import { LineCommentCommand } from './lineCommentCommand';
import { MenuId } from '../../../platform/actions/common/actions';
var CommentLineAction = /** @class */ (function (_super) {
    __extends(CommentLineAction, _super);
    function CommentLineAction(type, opts) {
        var _this = _super.call(this, opts) || this;
        _this._type = type;
        return _this;
    }
    CommentLineAction.prototype.run = function (accessor, editor) {
        var e_1, _a;
        if (!editor.hasModel()) {
            return;
        }
        var model = editor.getModel();
        var commands = [];
        var modelOptions = model.getOptions();
        var commentsOptions = editor.getOption(16 /* comments */);
        var selections = editor.getSelections().map(function (selection, index) { return ({ selection: selection, index: index, ignoreFirstLine: false }); });
        selections.sort(function (a, b) { return Range.compareRangesUsingStarts(a.selection, b.selection); });
        // Remove selections that would result in copying the same line
        var prev = selections[0];
        for (var i = 1; i < selections.length; i++) {
            var curr = selections[i];
            if (prev.selection.endLineNumber === curr.selection.startLineNumber) {
                // these two selections would copy the same line
                if (prev.index < curr.index) {
                    // prev wins
                    curr.ignoreFirstLine = true;
                }
                else {
                    // curr wins
                    prev.ignoreFirstLine = true;
                    prev = curr;
                }
            }
        }
        try {
            for (var selections_1 = __values(selections), selections_1_1 = selections_1.next(); !selections_1_1.done; selections_1_1 = selections_1.next()) {
                var selection = selections_1_1.value;
                commands.push(new LineCommentCommand(selection.selection, modelOptions.tabSize, this._type, commentsOptions.insertSpace, commentsOptions.ignoreEmptyLines, selection.ignoreFirstLine));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (selections_1_1 && !selections_1_1.done && (_a = selections_1.return)) _a.call(selections_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        editor.pushUndoStop();
        editor.executeCommands(this.id, commands);
        editor.pushUndoStop();
    };
    return CommentLineAction;
}(EditorAction));
var ToggleCommentLineAction = /** @class */ (function (_super) {
    __extends(ToggleCommentLineAction, _super);
    function ToggleCommentLineAction() {
        return _super.call(this, 0 /* Toggle */, {
            id: 'editor.action.commentLine',
            label: nls.localize('comment.line', "Toggle Line Comment"),
            alias: 'Toggle Line Comment',
            precondition: EditorContextKeys.writable,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: 2048 /* CtrlCmd */ | 85 /* US_SLASH */,
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MenuId.MenubarEditMenu,
                group: '5_insert',
                title: nls.localize({ key: 'miToggleLineComment', comment: ['&& denotes a mnemonic'] }, "&&Toggle Line Comment"),
                order: 1
            }
        }) || this;
    }
    return ToggleCommentLineAction;
}(CommentLineAction));
var AddLineCommentAction = /** @class */ (function (_super) {
    __extends(AddLineCommentAction, _super);
    function AddLineCommentAction() {
        return _super.call(this, 1 /* ForceAdd */, {
            id: 'editor.action.addCommentLine',
            label: nls.localize('comment.line.add', "Add Line Comment"),
            alias: 'Add Line Comment',
            precondition: EditorContextKeys.writable,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: KeyChord(2048 /* CtrlCmd */ | 41 /* KEY_K */, 2048 /* CtrlCmd */ | 33 /* KEY_C */),
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    return AddLineCommentAction;
}(CommentLineAction));
var RemoveLineCommentAction = /** @class */ (function (_super) {
    __extends(RemoveLineCommentAction, _super);
    function RemoveLineCommentAction() {
        return _super.call(this, 2 /* ForceRemove */, {
            id: 'editor.action.removeCommentLine',
            label: nls.localize('comment.line.remove', "Remove Line Comment"),
            alias: 'Remove Line Comment',
            precondition: EditorContextKeys.writable,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: KeyChord(2048 /* CtrlCmd */ | 41 /* KEY_K */, 2048 /* CtrlCmd */ | 51 /* KEY_U */),
                weight: 100 /* EditorContrib */
            }
        }) || this;
    }
    return RemoveLineCommentAction;
}(CommentLineAction));
var BlockCommentAction = /** @class */ (function (_super) {
    __extends(BlockCommentAction, _super);
    function BlockCommentAction() {
        return _super.call(this, {
            id: 'editor.action.blockComment',
            label: nls.localize('comment.block', "Toggle Block Comment"),
            alias: 'Toggle Block Comment',
            precondition: EditorContextKeys.writable,
            kbOpts: {
                kbExpr: EditorContextKeys.editorTextFocus,
                primary: 1024 /* Shift */ | 512 /* Alt */ | 31 /* KEY_A */,
                linux: { primary: 2048 /* CtrlCmd */ | 1024 /* Shift */ | 31 /* KEY_A */ },
                weight: 100 /* EditorContrib */
            },
            menuOpts: {
                menuId: MenuId.MenubarEditMenu,
                group: '5_insert',
                title: nls.localize({ key: 'miToggleBlockComment', comment: ['&& denotes a mnemonic'] }, "Toggle &&Block Comment"),
                order: 2
            }
        }) || this;
    }
    BlockCommentAction.prototype.run = function (accessor, editor) {
        var e_2, _a;
        if (!editor.hasModel()) {
            return;
        }
        var commentsOptions = editor.getOption(16 /* comments */);
        var commands = [];
        var selections = editor.getSelections();
        try {
            for (var selections_2 = __values(selections), selections_2_1 = selections_2.next(); !selections_2_1.done; selections_2_1 = selections_2.next()) {
                var selection = selections_2_1.value;
                commands.push(new BlockCommentCommand(selection, commentsOptions.insertSpace));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (selections_2_1 && !selections_2_1.done && (_a = selections_2.return)) _a.call(selections_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        editor.pushUndoStop();
        editor.executeCommands(this.id, commands);
        editor.pushUndoStop();
    };
    return BlockCommentAction;
}(EditorAction));
registerEditorAction(ToggleCommentLineAction);
registerEditorAction(AddLineCommentAction);
registerEditorAction(RemoveLineCommentAction);
registerEditorAction(BlockCommentAction);
