/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { Emitter } from '../../../base/common/event';
import { Disposable } from '../../../base/common/lifecycle';
var AbstractCodeEditorService = /** @class */ (function (_super) {
    __extends(AbstractCodeEditorService, _super);
    function AbstractCodeEditorService() {
        var _this = _super.call(this) || this;
        _this._onCodeEditorAdd = _this._register(new Emitter());
        _this.onCodeEditorAdd = _this._onCodeEditorAdd.event;
        _this._onCodeEditorRemove = _this._register(new Emitter());
        _this.onCodeEditorRemove = _this._onCodeEditorRemove.event;
        _this._onDiffEditorAdd = _this._register(new Emitter());
        _this.onDiffEditorAdd = _this._onDiffEditorAdd.event;
        _this._onDiffEditorRemove = _this._register(new Emitter());
        _this.onDiffEditorRemove = _this._onDiffEditorRemove.event;
        _this._onDidChangeTransientModelProperty = _this._register(new Emitter());
        _this.onDidChangeTransientModelProperty = _this._onDidChangeTransientModelProperty.event;
        _this._onDecorationTypeRegistered = _this._register(new Emitter());
        _this.onDecorationTypeRegistered = _this._onDecorationTypeRegistered.event;
        _this._transientWatchers = {};
        _this._modelProperties = new Map();
        _this._codeEditors = Object.create(null);
        _this._diffEditors = Object.create(null);
        return _this;
    }
    AbstractCodeEditorService.prototype.addCodeEditor = function (editor) {
        this._codeEditors[editor.getId()] = editor;
        this._onCodeEditorAdd.fire(editor);
    };
    AbstractCodeEditorService.prototype.removeCodeEditor = function (editor) {
        if (delete this._codeEditors[editor.getId()]) {
            this._onCodeEditorRemove.fire(editor);
        }
    };
    AbstractCodeEditorService.prototype.listCodeEditors = function () {
        var _this = this;
        return Object.keys(this._codeEditors).map(function (id) { return _this._codeEditors[id]; });
    };
    AbstractCodeEditorService.prototype.addDiffEditor = function (editor) {
        this._diffEditors[editor.getId()] = editor;
        this._onDiffEditorAdd.fire(editor);
    };
    AbstractCodeEditorService.prototype.removeDiffEditor = function (editor) {
        if (delete this._diffEditors[editor.getId()]) {
            this._onDiffEditorRemove.fire(editor);
        }
    };
    AbstractCodeEditorService.prototype.listDiffEditors = function () {
        var _this = this;
        return Object.keys(this._diffEditors).map(function (id) { return _this._diffEditors[id]; });
    };
    AbstractCodeEditorService.prototype.getFocusedCodeEditor = function () {
        var e_1, _a;
        var editorWithWidgetFocus = null;
        var editors = this.listCodeEditors();
        try {
            for (var editors_1 = __values(editors), editors_1_1 = editors_1.next(); !editors_1_1.done; editors_1_1 = editors_1.next()) {
                var editor = editors_1_1.value;
                if (editor.hasTextFocus()) {
                    // bingo!
                    return editor;
                }
                if (editor.hasWidgetFocus()) {
                    editorWithWidgetFocus = editor;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (editors_1_1 && !editors_1_1.done && (_a = editors_1.return)) _a.call(editors_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return editorWithWidgetFocus;
    };
    AbstractCodeEditorService.prototype.setModelProperty = function (resource, key, value) {
        var key1 = resource.toString();
        var dest;
        if (this._modelProperties.has(key1)) {
            dest = this._modelProperties.get(key1);
        }
        else {
            dest = new Map();
            this._modelProperties.set(key1, dest);
        }
        dest.set(key, value);
    };
    AbstractCodeEditorService.prototype.getModelProperty = function (resource, key) {
        var key1 = resource.toString();
        if (this._modelProperties.has(key1)) {
            var innerMap = this._modelProperties.get(key1);
            return innerMap.get(key);
        }
        return undefined;
    };
    AbstractCodeEditorService.prototype.setTransientModelProperty = function (model, key, value) {
        var uri = model.uri.toString();
        var w;
        if (this._transientWatchers.hasOwnProperty(uri)) {
            w = this._transientWatchers[uri];
        }
        else {
            w = new ModelTransientSettingWatcher(uri, model, this);
            this._transientWatchers[uri] = w;
        }
        w.set(key, value);
        this._onDidChangeTransientModelProperty.fire(model);
    };
    AbstractCodeEditorService.prototype.getTransientModelProperty = function (model, key) {
        var uri = model.uri.toString();
        if (!this._transientWatchers.hasOwnProperty(uri)) {
            return undefined;
        }
        return this._transientWatchers[uri].get(key);
    };
    AbstractCodeEditorService.prototype.getTransientModelProperties = function (model) {
        var _this = this;
        var uri = model.uri.toString();
        if (!this._transientWatchers.hasOwnProperty(uri)) {
            return undefined;
        }
        return this._transientWatchers[uri].keys().map(function (key) { return [key, _this._transientWatchers[uri].get(key)]; });
    };
    AbstractCodeEditorService.prototype._removeWatcher = function (w) {
        delete this._transientWatchers[w.uri];
    };
    return AbstractCodeEditorService;
}(Disposable));
export { AbstractCodeEditorService };
var ModelTransientSettingWatcher = /** @class */ (function () {
    function ModelTransientSettingWatcher(uri, model, owner) {
        var _this = this;
        this.uri = uri;
        this._values = {};
        model.onWillDispose(function () { return owner._removeWatcher(_this); });
    }
    ModelTransientSettingWatcher.prototype.set = function (key, value) {
        this._values[key] = value;
    };
    ModelTransientSettingWatcher.prototype.get = function (key) {
        return this._values[key];
    };
    ModelTransientSettingWatcher.prototype.keys = function () {
        return Object.keys(this._values);
    };
    return ModelTransientSettingWatcher;
}());
export { ModelTransientSettingWatcher };
