"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReconnectingFileSystemWatcherServer = exports.FileSystemWatcherServerProxy = exports.FileSystemWatcherServer = exports.FileSystemWatcherService = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
exports.FileSystemWatcherService = Symbol('FileSystemWatcherServer2');
exports.FileSystemWatcherServer = Symbol('FileSystemWatcherServer');
exports.FileSystemWatcherServerProxy = Symbol('FileSystemWatcherServerProxy');
/**
 * @deprecated not used internally anymore.
 */
let ReconnectingFileSystemWatcherServer = class ReconnectingFileSystemWatcherServer {
    constructor(proxy) {
        this.proxy = proxy;
        this.watcherSequence = 1;
        this.watchParams = new Map();
        this.localToRemoteWatcher = new Map();
        const onInitialized = this.proxy.onDidOpenConnection(() => {
            // skip reconnection on the first connection
            onInitialized.dispose();
            this.proxy.onDidOpenConnection(() => this.reconnect());
        });
    }
    reconnect() {
        for (const [watcher, { uri, options }] of this.watchParams.entries()) {
            this.doWatchFileChanges(watcher, uri, options);
        }
    }
    dispose() {
        this.proxy.dispose();
    }
    watchFileChanges(uri, options) {
        const watcher = this.watcherSequence++;
        this.watchParams.set(watcher, { uri, options });
        return this.doWatchFileChanges(watcher, uri, options);
    }
    doWatchFileChanges(watcher, uri, options) {
        return this.proxy.watchFileChanges(uri, options).then(remote => {
            this.localToRemoteWatcher.set(watcher, remote);
            return watcher;
        });
    }
    unwatchFileChanges(watcher) {
        this.watchParams.delete(watcher);
        const remote = this.localToRemoteWatcher.get(watcher);
        if (remote) {
            this.localToRemoteWatcher.delete(watcher);
            return this.proxy.unwatchFileChanges(remote);
        }
        return Promise.resolve();
    }
    setClient(client) {
        this.proxy.setClient(client);
    }
};
ReconnectingFileSystemWatcherServer = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(exports.FileSystemWatcherServerProxy)),
    __metadata("design:paramtypes", [Object])
], ReconnectingFileSystemWatcherServer);
exports.ReconnectingFileSystemWatcherServer = ReconnectingFileSystemWatcherServer;
//# sourceMappingURL=filesystem-watcher-protocol.js.map