"use strict";
// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
const jsdom_1 = require("../browser/test/jsdom");
let disableJSDOM = (0, jsdom_1.enableJSDOM)();
const lib_1 = require("@theia/application-package/lib/");
const chai_1 = require("chai");
const frontend_application_config_provider_1 = require("./frontend-application-config-provider");
disableJSDOM();
const { DEFAULT } = lib_1.FrontendApplicationConfig;
describe('FrontendApplicationConfigProvider', function () {
    before(() => disableJSDOM = (0, jsdom_1.enableJSDOM)());
    after(() => disableJSDOM());
    it('should use defaults when calling `set`', function () {
        frontend_application_config_provider_1.FrontendApplicationConfigProvider.set({
            applicationName: DEFAULT.applicationName + ' Something Else',
            electron: {
                disallowReloadKeybinding: !DEFAULT.electron.disallowReloadKeybinding
            }
        });
        const config = frontend_application_config_provider_1.FrontendApplicationConfigProvider.get();
        // custom values
        (0, chai_1.expect)(config.applicationName).not.equal(DEFAULT.applicationName);
        (0, chai_1.expect)(config.electron.disallowReloadKeybinding).not.equal(DEFAULT.electron.disallowReloadKeybinding);
        // defaults
        (0, chai_1.expect)(config.defaultIconTheme).equal(DEFAULT.defaultIconTheme);
        (0, chai_1.expect)(config.defaultTheme).equal(DEFAULT.defaultTheme);
        (0, chai_1.expect)(config.electron.windowOptions).deep.equal(DEFAULT.electron.windowOptions);
    });
});
//# sourceMappingURL=frontend-application-config-provider.spec.js.map