/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { createDecorator } from '../../instantiation/common/instantiation';
import { Emitter, PauseableEmitter } from '../../../base/common/event';
import { Disposable, dispose, MutableDisposable } from '../../../base/common/lifecycle';
import { isUndefinedOrNull } from '../../../base/common/types';
import { InMemoryStorageDatabase, Storage } from '../../../base/parts/storage/common/storage';
import { Promises, RunOnceScheduler, runWhenIdle } from '../../../base/common/async';
export var IS_NEW_KEY = '__$__isNewStorageMarker';
var TARGET_KEY = '__$__targetStorageMarker';
export var IStorageService = createDecorator('storageService');
export var WillSaveStateReason;
(function (WillSaveStateReason) {
    /**
     * No specific reason to save state.
     */
    WillSaveStateReason[WillSaveStateReason["NONE"] = 0] = "NONE";
    /**
     * A hint that the workbench is about to shutdown.
     */
    WillSaveStateReason[WillSaveStateReason["SHUTDOWN"] = 1] = "SHUTDOWN";
})(WillSaveStateReason || (WillSaveStateReason = {}));
var AbstractStorageService = /** @class */ (function (_super) {
    __extends(AbstractStorageService, _super);
    function AbstractStorageService(options) {
        if (options === void 0) { options = { flushInterval: AbstractStorageService.DEFAULT_FLUSH_INTERVAL }; }
        var _this = _super.call(this) || this;
        _this.options = options;
        _this._onDidChangeValue = _this._register(new PauseableEmitter());
        _this.onDidChangeValue = _this._onDidChangeValue.event;
        _this._onDidChangeTarget = _this._register(new PauseableEmitter());
        _this.onDidChangeTarget = _this._onDidChangeTarget.event;
        _this._onWillSaveState = _this._register(new Emitter());
        _this.onWillSaveState = _this._onWillSaveState.event;
        _this.flushWhenIdleScheduler = _this._register(new RunOnceScheduler(function () { return _this.doFlushWhenIdle(); }, _this.options.flushInterval));
        _this.runFlushWhenIdle = _this._register(new MutableDisposable());
        _this._workspaceKeyTargets = undefined;
        _this._globalKeyTargets = undefined;
        return _this;
    }
    AbstractStorageService.prototype.doFlushWhenIdle = function () {
        var _this = this;
        this.runFlushWhenIdle.value = runWhenIdle(function () {
            if (_this.shouldFlushWhenIdle()) {
                _this.flush();
            }
            // repeat
            _this.flushWhenIdleScheduler.schedule();
        });
    };
    AbstractStorageService.prototype.shouldFlushWhenIdle = function () {
        return true;
    };
    AbstractStorageService.prototype.stopFlushWhenIdle = function () {
        dispose([this.runFlushWhenIdle, this.flushWhenIdleScheduler]);
    };
    AbstractStorageService.prototype.initialize = function () {
        var _this = this;
        if (!this.initializationPromise) {
            this.initializationPromise = (function () { return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: 
                        // Ask subclasses to initialize storage
                        return [4 /*yield*/, this.doInitialize()];
                        case 1:
                            // Ask subclasses to initialize storage
                            _a.sent();
                            // On some OS we do not get enough time to persist state on shutdown (e.g. when
                            // Windows restarts after applying updates). In other cases, VSCode might crash,
                            // so we periodically save state to reduce the chance of loosing any state.
                            // In the browser we do not have support for long running unload sequences. As such,
                            // we cannot ask for saving state in that moment, because that would result in a
                            // long running operation.
                            // Instead, periodically ask customers to save save. The library will be clever enough
                            // to only save state that has actually changed.
                            this.flushWhenIdleScheduler.schedule();
                            return [2 /*return*/];
                    }
                });
            }); })();
        }
        return this.initializationPromise;
    };
    AbstractStorageService.prototype.emitDidChangeValue = function (scope, key) {
        // Specially handle `TARGET_KEY`
        if (key === TARGET_KEY) {
            // Clear our cached version which is now out of date
            if (scope === 0 /* GLOBAL */) {
                this._globalKeyTargets = undefined;
            }
            else if (scope === 1 /* WORKSPACE */) {
                this._workspaceKeyTargets = undefined;
            }
            // Emit as `didChangeTarget` event
            this._onDidChangeTarget.fire({ scope: scope });
        }
        // Emit any other key to outside
        else {
            this._onDidChangeValue.fire({ scope: scope, key: key, target: this.getKeyTargets(scope)[key] });
        }
    };
    AbstractStorageService.prototype.emitWillSaveState = function (reason) {
        this._onWillSaveState.fire({ reason: reason });
    };
    AbstractStorageService.prototype.get = function (key, scope, fallbackValue) {
        var _a;
        return (_a = this.getStorage(scope)) === null || _a === void 0 ? void 0 : _a.get(key, fallbackValue);
    };
    AbstractStorageService.prototype.getBoolean = function (key, scope, fallbackValue) {
        var _a;
        return (_a = this.getStorage(scope)) === null || _a === void 0 ? void 0 : _a.getBoolean(key, fallbackValue);
    };
    AbstractStorageService.prototype.getNumber = function (key, scope, fallbackValue) {
        var _a;
        return (_a = this.getStorage(scope)) === null || _a === void 0 ? void 0 : _a.getNumber(key, fallbackValue);
    };
    AbstractStorageService.prototype.store = function (key, value, scope, target) {
        var _this = this;
        // We remove the key for undefined/null values
        if (isUndefinedOrNull(value)) {
            this.remove(key, scope);
            return;
        }
        // Update our datastructures but send events only after
        this.withPausedEmitters(function () {
            var _a;
            // Update key-target map
            _this.updateKeyTarget(key, scope, target);
            // Store actual value
            (_a = _this.getStorage(scope)) === null || _a === void 0 ? void 0 : _a.set(key, value);
        });
    };
    AbstractStorageService.prototype.remove = function (key, scope) {
        var _this = this;
        // Update our datastructures but send events only after
        this.withPausedEmitters(function () {
            var _a;
            // Update key-target map
            _this.updateKeyTarget(key, scope, undefined);
            // Remove actual key
            (_a = _this.getStorage(scope)) === null || _a === void 0 ? void 0 : _a.delete(key);
        });
    };
    AbstractStorageService.prototype.withPausedEmitters = function (fn) {
        // Pause emitters
        this._onDidChangeValue.pause();
        this._onDidChangeTarget.pause();
        try {
            fn();
        }
        finally {
            // Resume emitters
            this._onDidChangeValue.resume();
            this._onDidChangeTarget.resume();
        }
    };
    AbstractStorageService.prototype.keys = function (scope, target) {
        var e_1, _a;
        var keys = [];
        var keyTargets = this.getKeyTargets(scope);
        try {
            for (var _b = __values(Object.keys(keyTargets)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                var keyTarget = keyTargets[key];
                if (keyTarget === target) {
                    keys.push(key);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return keys;
    };
    AbstractStorageService.prototype.updateKeyTarget = function (key, scope, target) {
        var _a, _b;
        // Add
        var keyTargets = this.getKeyTargets(scope);
        if (typeof target === 'number') {
            if (keyTargets[key] !== target) {
                keyTargets[key] = target;
                (_a = this.getStorage(scope)) === null || _a === void 0 ? void 0 : _a.set(TARGET_KEY, JSON.stringify(keyTargets));
            }
        }
        // Remove
        else {
            if (typeof keyTargets[key] === 'number') {
                delete keyTargets[key];
                (_b = this.getStorage(scope)) === null || _b === void 0 ? void 0 : _b.set(TARGET_KEY, JSON.stringify(keyTargets));
            }
        }
    };
    Object.defineProperty(AbstractStorageService.prototype, "workspaceKeyTargets", {
        get: function () {
            if (!this._workspaceKeyTargets) {
                this._workspaceKeyTargets = this.loadKeyTargets(1 /* WORKSPACE */);
            }
            return this._workspaceKeyTargets;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AbstractStorageService.prototype, "globalKeyTargets", {
        get: function () {
            if (!this._globalKeyTargets) {
                this._globalKeyTargets = this.loadKeyTargets(0 /* GLOBAL */);
            }
            return this._globalKeyTargets;
        },
        enumerable: false,
        configurable: true
    });
    AbstractStorageService.prototype.getKeyTargets = function (scope) {
        return scope === 0 /* GLOBAL */ ? this.globalKeyTargets : this.workspaceKeyTargets;
    };
    AbstractStorageService.prototype.loadKeyTargets = function (scope) {
        var keysRaw = this.get(TARGET_KEY, scope);
        if (keysRaw) {
            try {
                return JSON.parse(keysRaw);
            }
            catch (error) {
                // Fail gracefully
            }
        }
        return Object.create(null);
    };
    AbstractStorageService.prototype.isNew = function (scope) {
        return this.getBoolean(IS_NEW_KEY, scope) === true;
    };
    AbstractStorageService.prototype.flush = function () {
        var _a, _b, _c, _d;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        // Signal event to collect changes
                        this._onWillSaveState.fire({ reason: WillSaveStateReason.NONE });
                        // Await flush
                        return [4 /*yield*/, Promises.settled([
                                (_b = (_a = this.getStorage(0 /* GLOBAL */)) === null || _a === void 0 ? void 0 : _a.whenFlushed()) !== null && _b !== void 0 ? _b : Promise.resolve(),
                                (_d = (_c = this.getStorage(1 /* WORKSPACE */)) === null || _c === void 0 ? void 0 : _c.whenFlushed()) !== null && _d !== void 0 ? _d : Promise.resolve()
                            ])];
                    case 1:
                        // Await flush
                        _e.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    AbstractStorageService.prototype.logStorage = function () {
        var _a, _b, _c, _d, _e, _f;
        return __awaiter(this, void 0, void 0, function () {
            var globalItems, workspaceItems;
            return __generator(this, function (_g) {
                globalItems = (_b = (_a = this.getStorage(0 /* GLOBAL */)) === null || _a === void 0 ? void 0 : _a.items) !== null && _b !== void 0 ? _b : new Map();
                workspaceItems = (_d = (_c = this.getStorage(1 /* WORKSPACE */)) === null || _c === void 0 ? void 0 : _c.items) !== null && _d !== void 0 ? _d : new Map();
                return [2 /*return*/, logStorage(globalItems, workspaceItems, (_e = this.getLogDetails(0 /* GLOBAL */)) !== null && _e !== void 0 ? _e : '', (_f = this.getLogDetails(1 /* WORKSPACE */)) !== null && _f !== void 0 ? _f : '')];
            });
        });
    };
    AbstractStorageService.DEFAULT_FLUSH_INTERVAL = 60 * 1000; // every minute
    return AbstractStorageService;
}(Disposable));
export { AbstractStorageService };
var InMemoryStorageService = /** @class */ (function (_super) {
    __extends(InMemoryStorageService, _super);
    function InMemoryStorageService() {
        var _this = _super.call(this) || this;
        _this.globalStorage = new Storage(new InMemoryStorageDatabase());
        _this.workspaceStorage = new Storage(new InMemoryStorageDatabase());
        _this._register(_this.workspaceStorage.onDidChangeStorage(function (key) { return _this.emitDidChangeValue(1 /* WORKSPACE */, key); }));
        _this._register(_this.globalStorage.onDidChangeStorage(function (key) { return _this.emitDidChangeValue(0 /* GLOBAL */, key); }));
        return _this;
    }
    InMemoryStorageService.prototype.getStorage = function (scope) {
        return scope === 0 /* GLOBAL */ ? this.globalStorage : this.workspaceStorage;
    };
    InMemoryStorageService.prototype.getLogDetails = function (scope) {
        return scope === 0 /* GLOBAL */ ? 'inMemory (global)' : 'inMemory (workspace)';
    };
    InMemoryStorageService.prototype.doInitialize = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    InMemoryStorageService.prototype.migrate = function (toWorkspace) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/];
            });
        });
    };
    return InMemoryStorageService;
}(AbstractStorageService));
export { InMemoryStorageService };
export function logStorage(global, workspace, globalPath, workspacePath) {
    return __awaiter(this, void 0, void 0, function () {
        var safeParse, globalItems, globalItemsParsed, workspaceItems, workspaceItemsParsed, globalValues, workspaceValues;
        return __generator(this, function (_a) {
            safeParse = function (value) {
                try {
                    return JSON.parse(value);
                }
                catch (error) {
                    return value;
                }
            };
            globalItems = new Map();
            globalItemsParsed = new Map();
            global.forEach(function (value, key) {
                globalItems.set(key, value);
                globalItemsParsed.set(key, safeParse(value));
            });
            workspaceItems = new Map();
            workspaceItemsParsed = new Map();
            workspace.forEach(function (value, key) {
                workspaceItems.set(key, value);
                workspaceItemsParsed.set(key, safeParse(value));
            });
            console.group("Storage: Global (path: " + globalPath + ")");
            globalValues = [];
            globalItems.forEach(function (value, key) {
                globalValues.push({ key: key, value: value });
            });
            console.table(globalValues);
            console.groupEnd();
            console.log(globalItemsParsed);
            console.group("Storage: Workspace (path: " + workspacePath + ")");
            workspaceValues = [];
            workspaceItems.forEach(function (value, key) {
                workspaceValues.push({ key: key, value: value });
            });
            console.table(workspaceValues);
            console.groupEnd();
            console.log(workspaceItemsParsed);
            return [2 /*return*/];
        });
    });
}
