/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as nls from '../../../nls';
import * as dom from '../../../base/browser/dom';
import { toDisposable, DisposableStore, Disposable } from '../../../base/common/lifecycle';
import { Range } from '../../common/core/range';
import { isNonEmptyArray } from '../../../base/common/arrays';
import { IMarkerData, MarkerSeverity } from '../../../platform/markers/common/markers';
import { basename } from '../../../base/common/resources';
import { IMarkerDecorationsService } from '../../common/services/markersDecorationService';
import { onUnexpectedError } from '../../../base/common/errors';
import { IOpenerService } from '../../../platform/opener/common/opener';
import { MarkerController, NextMarkerAction } from '../gotoError/gotoError';
import { IKeybindingService } from '../../../platform/keybinding/common/keybinding';
import { createCancelablePromise, disposableTimeout } from '../../../base/common/async';
import { getCodeActions } from '../codeAction/codeAction';
import { QuickFixAction, QuickFixController } from '../codeAction/codeActionCommands';
import { CodeActionKind } from '../codeAction/types';
import { Progress } from '../../../platform/progress/common/progress';
import { renderHoverAction } from '../../../base/browser/ui/hover/hoverWidget';
var $ = dom.$;
var MarkerHover = /** @class */ (function () {
    function MarkerHover(range, marker) {
        this.range = range;
        this.marker = marker;
    }
    MarkerHover.prototype.equals = function (other) {
        if (other instanceof MarkerHover) {
            return IMarkerData.makeKey(this.marker) === IMarkerData.makeKey(other.marker);
        }
        return false;
    };
    return MarkerHover;
}());
export { MarkerHover };
var markerCodeActionTrigger = {
    type: 2 /* Manual */,
    filter: { include: CodeActionKind.QuickFix }
};
var MarkerHoverParticipant = /** @class */ (function () {
    function MarkerHoverParticipant(_editor, _hover, _markerDecorationsService, _keybindingService, _openerService) {
        this._editor = _editor;
        this._hover = _hover;
        this._markerDecorationsService = _markerDecorationsService;
        this._keybindingService = _keybindingService;
        this._openerService = _openerService;
        this.recentMarkerCodeActionsInfo = undefined;
    }
    MarkerHoverParticipant.prototype.computeSync = function (hoverRange, lineDecorations) {
        var e_1, _a;
        if (!this._editor.hasModel()) {
            return [];
        }
        var model = this._editor.getModel();
        var lineNumber = hoverRange.startLineNumber;
        var maxColumn = model.getLineMaxColumn(lineNumber);
        var result = [];
        try {
            for (var lineDecorations_1 = __values(lineDecorations), lineDecorations_1_1 = lineDecorations_1.next(); !lineDecorations_1_1.done; lineDecorations_1_1 = lineDecorations_1.next()) {
                var d = lineDecorations_1_1.value;
                var startColumn = (d.range.startLineNumber === lineNumber) ? d.range.startColumn : 1;
                var endColumn = (d.range.endLineNumber === lineNumber) ? d.range.endColumn : maxColumn;
                var marker = this._markerDecorationsService.getMarker(model.uri, d);
                if (!marker) {
                    continue;
                }
                var range = new Range(hoverRange.startLineNumber, startColumn, hoverRange.startLineNumber, endColumn);
                result.push(new MarkerHover(range, marker));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (lineDecorations_1_1 && !lineDecorations_1_1.done && (_a = lineDecorations_1.return)) _a.call(lineDecorations_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    MarkerHoverParticipant.prototype.renderHoverParts = function (hoverParts, fragment) {
        var _this = this;
        if (!hoverParts.length) {
            return Disposable.None;
        }
        var disposables = new DisposableStore();
        hoverParts.forEach(function (msg) { return fragment.appendChild(_this.renderMarkerHover(msg, disposables)); });
        var markerHoverForStatusbar = hoverParts.length === 1 ? hoverParts[0] : hoverParts.sort(function (a, b) { return MarkerSeverity.compare(a.marker.severity, b.marker.severity); })[0];
        fragment.appendChild(this.renderMarkerStatusbar(markerHoverForStatusbar, disposables));
        return disposables;
    };
    MarkerHoverParticipant.prototype.renderMarkerHover = function (markerHover, disposables) {
        var e_2, _a;
        var _this = this;
        var hoverElement = $('div.hover-row');
        var markerElement = dom.append(hoverElement, $('div.marker.hover-contents'));
        var _b = markerHover.marker, source = _b.source, message = _b.message, code = _b.code, relatedInformation = _b.relatedInformation;
        this._editor.applyFontInfo(markerElement);
        var messageElement = dom.append(markerElement, $('span'));
        messageElement.style.whiteSpace = 'pre-wrap';
        messageElement.innerText = message;
        if (source || code) {
            // Code has link
            if (code && typeof code !== 'string') {
                var sourceAndCodeElement = $('span');
                if (source) {
                    var sourceElement = dom.append(sourceAndCodeElement, $('span'));
                    sourceElement.innerText = source;
                }
                var codeLink = dom.append(sourceAndCodeElement, $('a.code-link'));
                codeLink.setAttribute('href', code.target.toString());
                disposables.add(dom.addDisposableListener(codeLink, 'click', function (e) {
                    _this._openerService.open(code.target);
                    e.preventDefault();
                    e.stopPropagation();
                }));
                var codeElement = dom.append(codeLink, $('span'));
                codeElement.innerText = code.value;
                var detailsElement = dom.append(markerElement, sourceAndCodeElement);
                detailsElement.style.opacity = '0.6';
                detailsElement.style.paddingLeft = '6px';
            }
            else {
                var detailsElement = dom.append(markerElement, $('span'));
                detailsElement.style.opacity = '0.6';
                detailsElement.style.paddingLeft = '6px';
                detailsElement.innerText = source && code ? source + "(" + code + ")" : source ? source : "(" + code + ")";
            }
        }
        if (isNonEmptyArray(relatedInformation)) {
            var _loop_1 = function (message_1, resource, startLineNumber, startColumn) {
                var relatedInfoContainer = dom.append(markerElement, $('div'));
                relatedInfoContainer.style.marginTop = '8px';
                var a = dom.append(relatedInfoContainer, $('a'));
                a.innerText = basename(resource) + "(" + startLineNumber + ", " + startColumn + "): ";
                a.style.cursor = 'pointer';
                disposables.add(dom.addDisposableListener(a, 'click', function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                    if (_this._openerService) {
                        _this._openerService.open(resource, {
                            fromUserGesture: true,
                            editorOptions: { selection: { startLineNumber: startLineNumber, startColumn: startColumn } }
                        }).catch(onUnexpectedError);
                    }
                }));
                var messageElement_1 = dom.append(relatedInfoContainer, $('span'));
                messageElement_1.innerText = message_1;
                this_1._editor.applyFontInfo(messageElement_1);
            };
            var this_1 = this;
            try {
                for (var relatedInformation_1 = __values(relatedInformation), relatedInformation_1_1 = relatedInformation_1.next(); !relatedInformation_1_1.done; relatedInformation_1_1 = relatedInformation_1.next()) {
                    var _c = relatedInformation_1_1.value, message_1 = _c.message, resource = _c.resource, startLineNumber = _c.startLineNumber, startColumn = _c.startColumn;
                    _loop_1(message_1, resource, startLineNumber, startColumn);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (relatedInformation_1_1 && !relatedInformation_1_1.done && (_a = relatedInformation_1.return)) _a.call(relatedInformation_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        return hoverElement;
    };
    MarkerHoverParticipant.prototype.renderMarkerStatusbar = function (markerHover, disposables) {
        var _this = this;
        var hoverElement = $('div.hover-row.status-bar');
        var actionsElement = dom.append(hoverElement, $('div.actions'));
        if (markerHover.marker.severity === MarkerSeverity.Error || markerHover.marker.severity === MarkerSeverity.Warning || markerHover.marker.severity === MarkerSeverity.Info) {
            disposables.add(this.renderAction(actionsElement, {
                label: nls.localize('view problem', "View Problem"),
                commandId: NextMarkerAction.ID,
                run: function () {
                    _this._hover.hide();
                    MarkerController.get(_this._editor).showAtMarker(markerHover.marker);
                    _this._editor.focus();
                }
            }));
        }
        if (!this._editor.getOption(75 /* readOnly */)) {
            var quickfixPlaceholderElement_1 = dom.append(actionsElement, $('div'));
            if (this.recentMarkerCodeActionsInfo) {
                if (IMarkerData.makeKey(this.recentMarkerCodeActionsInfo.marker) === IMarkerData.makeKey(markerHover.marker)) {
                    if (!this.recentMarkerCodeActionsInfo.hasCodeActions) {
                        quickfixPlaceholderElement_1.textContent = nls.localize('noQuickFixes', "No quick fixes available");
                    }
                }
                else {
                    this.recentMarkerCodeActionsInfo = undefined;
                }
            }
            var updatePlaceholderDisposable_1 = this.recentMarkerCodeActionsInfo && !this.recentMarkerCodeActionsInfo.hasCodeActions ? Disposable.None : disposables.add(disposableTimeout(function () { return quickfixPlaceholderElement_1.textContent = nls.localize('checkingForQuickFixes', "Checking for quick fixes..."); }, 200));
            if (!quickfixPlaceholderElement_1.textContent) {
                // Have some content in here to avoid flickering
                quickfixPlaceholderElement_1.textContent = String.fromCharCode(0xA0); // &nbsp;
            }
            var codeActionsPromise_1 = this.getCodeActions(markerHover.marker);
            disposables.add(toDisposable(function () { return codeActionsPromise_1.cancel(); }));
            codeActionsPromise_1.then(function (actions) {
                updatePlaceholderDisposable_1.dispose();
                _this.recentMarkerCodeActionsInfo = { marker: markerHover.marker, hasCodeActions: actions.validActions.length > 0 };
                if (!_this.recentMarkerCodeActionsInfo.hasCodeActions) {
                    actions.dispose();
                    quickfixPlaceholderElement_1.textContent = nls.localize('noQuickFixes', "No quick fixes available");
                    return;
                }
                quickfixPlaceholderElement_1.style.display = 'none';
                var showing = false;
                disposables.add(toDisposable(function () {
                    if (!showing) {
                        actions.dispose();
                    }
                }));
                disposables.add(_this.renderAction(actionsElement, {
                    label: nls.localize('quick fixes', "Quick Fix..."),
                    commandId: QuickFixAction.Id,
                    run: function (target) {
                        showing = true;
                        var controller = QuickFixController.get(_this._editor);
                        var elementPosition = dom.getDomNodePagePosition(target);
                        // Hide the hover pre-emptively, otherwise the editor can close the code actions
                        // context menu as well when using keyboard navigation
                        _this._hover.hide();
                        controller.showCodeActions(markerCodeActionTrigger, actions, {
                            x: elementPosition.left + 6,
                            y: elementPosition.top + elementPosition.height + 6
                        });
                    }
                }));
            });
        }
        return hoverElement;
    };
    MarkerHoverParticipant.prototype.renderAction = function (parent, actionOptions) {
        var keybinding = this._keybindingService.lookupKeybinding(actionOptions.commandId);
        var keybindingLabel = keybinding ? keybinding.getLabel() : null;
        return renderHoverAction(parent, actionOptions, keybindingLabel);
    };
    MarkerHoverParticipant.prototype.getCodeActions = function (marker) {
        var _this = this;
        return createCancelablePromise(function (cancellationToken) {
            return getCodeActions(_this._editor.getModel(), new Range(marker.startLineNumber, marker.startColumn, marker.endLineNumber, marker.endColumn), markerCodeActionTrigger, Progress.None, cancellationToken);
        });
    };
    MarkerHoverParticipant = __decorate([
        __param(2, IMarkerDecorationsService),
        __param(3, IKeybindingService),
        __param(4, IOpenerService)
    ], MarkerHoverParticipant);
    return MarkerHoverParticipant;
}());
export { MarkerHoverParticipant };
