/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { createCancelablePromise, TimeoutTimer } from '../../../base/common/async';
import { isPromiseCanceledError } from '../../../base/common/errors';
import { Emitter } from '../../../base/common/event';
import { Disposable, MutableDisposable } from '../../../base/common/lifecycle';
import { isEqual } from '../../../base/common/resources';
import { Range } from '../../common/core/range';
import { CodeActionProviderRegistry } from '../../common/modes';
import { RawContextKey } from '../../../platform/contextkey/common/contextkey';
import { Progress } from '../../../platform/progress/common/progress';
import { getCodeActions } from './codeAction';
export var SUPPORTED_CODE_ACTIONS = new RawContextKey('supportedCodeAction', '');
var CodeActionOracle = /** @class */ (function (_super) {
    __extends(CodeActionOracle, _super);
    function CodeActionOracle(_editor, _markerService, _signalChange, _delay) {
        if (_delay === void 0) { _delay = 250; }
        var _this = _super.call(this) || this;
        _this._editor = _editor;
        _this._markerService = _markerService;
        _this._signalChange = _signalChange;
        _this._delay = _delay;
        _this._autoTriggerTimer = _this._register(new TimeoutTimer());
        _this._register(_this._markerService.onMarkerChanged(function (e) { return _this._onMarkerChanges(e); }));
        _this._register(_this._editor.onDidChangeCursorPosition(function () { return _this._onCursorChange(); }));
        return _this;
    }
    CodeActionOracle.prototype.trigger = function (trigger) {
        var selection = this._getRangeOfSelectionUnlessWhitespaceEnclosed(trigger);
        return this._createEventAndSignalChange(trigger, selection);
    };
    CodeActionOracle.prototype._onMarkerChanges = function (resources) {
        var _this = this;
        var model = this._editor.getModel();
        if (!model) {
            return;
        }
        if (resources.some(function (resource) { return isEqual(resource, model.uri); })) {
            this._autoTriggerTimer.cancelAndSet(function () {
                _this.trigger({ type: 1 /* Auto */ });
            }, this._delay);
        }
    };
    CodeActionOracle.prototype._onCursorChange = function () {
        var _this = this;
        this._autoTriggerTimer.cancelAndSet(function () {
            _this.trigger({ type: 1 /* Auto */ });
        }, this._delay);
    };
    CodeActionOracle.prototype._getRangeOfMarker = function (selection) {
        var e_1, _a;
        var model = this._editor.getModel();
        if (!model) {
            return undefined;
        }
        try {
            for (var _b = __values(this._markerService.read({ resource: model.uri })), _c = _b.next(); !_c.done; _c = _b.next()) {
                var marker = _c.value;
                var markerRange = model.validateRange(marker);
                if (Range.intersectRanges(markerRange, selection)) {
                    return Range.lift(markerRange);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return undefined;
    };
    CodeActionOracle.prototype._getRangeOfSelectionUnlessWhitespaceEnclosed = function (trigger) {
        if (!this._editor.hasModel()) {
            return undefined;
        }
        var model = this._editor.getModel();
        var selection = this._editor.getSelection();
        if (selection.isEmpty() && trigger.type === 1 /* Auto */) {
            var _a = selection.getPosition(), lineNumber = _a.lineNumber, column = _a.column;
            var line = model.getLineContent(lineNumber);
            if (line.length === 0) {
                // empty line
                return undefined;
            }
            else if (column === 1) {
                // look only right
                if (/\s/.test(line[0])) {
                    return undefined;
                }
            }
            else if (column === model.getLineMaxColumn(lineNumber)) {
                // look only left
                if (/\s/.test(line[line.length - 1])) {
                    return undefined;
                }
            }
            else {
                // look left and right
                if (/\s/.test(line[column - 2]) && /\s/.test(line[column - 1])) {
                    return undefined;
                }
            }
        }
        return selection;
    };
    CodeActionOracle.prototype._createEventAndSignalChange = function (trigger, selection) {
        var model = this._editor.getModel();
        if (!selection || !model) {
            // cancel
            this._signalChange(undefined);
            return undefined;
        }
        var markerRange = this._getRangeOfMarker(selection);
        var position = markerRange ? markerRange.getStartPosition() : selection.getStartPosition();
        var e = {
            trigger: trigger,
            selection: selection,
            position: position
        };
        this._signalChange(e);
        return e;
    };
    return CodeActionOracle;
}(Disposable));
export var CodeActionsState;
(function (CodeActionsState) {
    CodeActionsState.Empty = { type: 0 /* Empty */ };
    var Triggered = /** @class */ (function () {
        function Triggered(trigger, rangeOrSelection, position, _cancellablePromise) {
            this.trigger = trigger;
            this.rangeOrSelection = rangeOrSelection;
            this.position = position;
            this._cancellablePromise = _cancellablePromise;
            this.type = 1 /* Triggered */;
            this.actions = _cancellablePromise.catch(function (e) {
                if (isPromiseCanceledError(e)) {
                    return emptyCodeActionSet;
                }
                throw e;
            });
        }
        Triggered.prototype.cancel = function () {
            this._cancellablePromise.cancel();
        };
        return Triggered;
    }());
    CodeActionsState.Triggered = Triggered;
})(CodeActionsState || (CodeActionsState = {}));
var emptyCodeActionSet = {
    allActions: [],
    validActions: [],
    dispose: function () { },
    documentation: [],
    hasAutoFix: false
};
var CodeActionModel = /** @class */ (function (_super) {
    __extends(CodeActionModel, _super);
    function CodeActionModel(_editor, _markerService, contextKeyService, _progressService) {
        var _this = _super.call(this) || this;
        _this._editor = _editor;
        _this._markerService = _markerService;
        _this._progressService = _progressService;
        _this._codeActionOracle = _this._register(new MutableDisposable());
        _this._state = CodeActionsState.Empty;
        _this._onDidChangeState = _this._register(new Emitter());
        _this.onDidChangeState = _this._onDidChangeState.event;
        _this.isDisposed = false;
        _this._supportedCodeActions = SUPPORTED_CODE_ACTIONS.bindTo(contextKeyService);
        _this._register(_this._editor.onDidChangeModel(function () { return _this._update(); }));
        _this._register(_this._editor.onDidChangeModelLanguage(function () { return _this._update(); }));
        _this._register(CodeActionProviderRegistry.onDidChange(function () { return _this._update(); }));
        _this._update();
        return _this;
    }
    CodeActionModel.prototype.dispose = function () {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        _super.prototype.dispose.call(this);
        this.setState(CodeActionsState.Empty, true);
    };
    CodeActionModel.prototype._update = function () {
        var e_2, _a;
        var _this = this;
        if (this.isDisposed) {
            return;
        }
        this._codeActionOracle.value = undefined;
        this.setState(CodeActionsState.Empty);
        var model = this._editor.getModel();
        if (model
            && CodeActionProviderRegistry.has(model)
            && !this._editor.getOption(75 /* readOnly */)) {
            var supportedActions = [];
            try {
                for (var _b = __values(CodeActionProviderRegistry.all(model)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var provider = _c.value;
                    if (Array.isArray(provider.providedCodeActionKinds)) {
                        supportedActions.push.apply(supportedActions, __spreadArray([], __read(provider.providedCodeActionKinds)));
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
            this._supportedCodeActions.set(supportedActions.join(' '));
            this._codeActionOracle.value = new CodeActionOracle(this._editor, this._markerService, function (trigger) {
                var _a;
                if (!trigger) {
                    _this.setState(CodeActionsState.Empty);
                    return;
                }
                var actions = createCancelablePromise(function (token) { return getCodeActions(model, trigger.selection, trigger.trigger, Progress.None, token); });
                if (trigger.trigger.type === 2 /* Manual */) {
                    (_a = _this._progressService) === null || _a === void 0 ? void 0 : _a.showWhile(actions, 250);
                }
                _this.setState(new CodeActionsState.Triggered(trigger.trigger, trigger.selection, trigger.position, actions));
            }, undefined);
            this._codeActionOracle.value.trigger({ type: 1 /* Auto */ });
        }
        else {
            this._supportedCodeActions.reset();
        }
    };
    CodeActionModel.prototype.trigger = function (trigger) {
        if (this._codeActionOracle.value) {
            this._codeActionOracle.value.trigger(trigger);
        }
    };
    CodeActionModel.prototype.setState = function (newState, skipNotify) {
        if (newState === this._state) {
            return;
        }
        // Cancel old request
        if (this._state.type === 1 /* Triggered */) {
            this._state.cancel();
        }
        this._state = newState;
        if (!skipNotify && !this.isDisposed) {
            this._onDidChangeState.fire(newState);
        }
    };
    return CodeActionModel;
}(Disposable));
export { CodeActionModel };
