/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import * as strings from '../../../../base/common/strings';
import * as stringBuilder from '../../core/stringBuilder';
import { Range } from '../../core/range';
var RichEditBracket = /** @class */ (function () {
    function RichEditBracket(languageIdentifier, index, open, close, forwardRegex, reversedRegex) {
        this.languageIdentifier = languageIdentifier;
        this.index = index;
        this.open = open;
        this.close = close;
        this.forwardRegex = forwardRegex;
        this.reversedRegex = reversedRegex;
        this._openSet = RichEditBracket._toSet(this.open);
        this._closeSet = RichEditBracket._toSet(this.close);
    }
    RichEditBracket.prototype.isOpen = function (text) {
        return this._openSet.has(text);
    };
    RichEditBracket.prototype.isClose = function (text) {
        return this._closeSet.has(text);
    };
    RichEditBracket._toSet = function (arr) {
        var e_1, _a;
        var result = new Set();
        try {
            for (var arr_1 = __values(arr), arr_1_1 = arr_1.next(); !arr_1_1.done; arr_1_1 = arr_1.next()) {
                var element = arr_1_1.value;
                result.add(element);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (arr_1_1 && !arr_1_1.done && (_a = arr_1.return)) _a.call(arr_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    return RichEditBracket;
}());
export { RichEditBracket };
function groupFuzzyBrackets(brackets) {
    var N = brackets.length;
    brackets = brackets.map(function (b) { return [b[0].toLowerCase(), b[1].toLowerCase()]; });
    var group = [];
    for (var i = 0; i < N; i++) {
        group[i] = i;
    }
    var areOverlapping = function (a, b) {
        var _a = __read(a, 2), aOpen = _a[0], aClose = _a[1];
        var _b = __read(b, 2), bOpen = _b[0], bClose = _b[1];
        return (aOpen === bOpen || aOpen === bClose || aClose === bOpen || aClose === bClose);
    };
    var mergeGroups = function (g1, g2) {
        var newG = Math.min(g1, g2);
        var oldG = Math.max(g1, g2);
        for (var i = 0; i < N; i++) {
            if (group[i] === oldG) {
                group[i] = newG;
            }
        }
    };
    // group together brackets that have the same open or the same close sequence
    for (var i = 0; i < N; i++) {
        var a = brackets[i];
        for (var j = i + 1; j < N; j++) {
            var b = brackets[j];
            if (areOverlapping(a, b)) {
                mergeGroups(group[i], group[j]);
            }
        }
    }
    var result = [];
    for (var g = 0; g < N; g++) {
        var currentOpen = [];
        var currentClose = [];
        for (var i = 0; i < N; i++) {
            if (group[i] === g) {
                var _a = __read(brackets[i], 2), open_1 = _a[0], close_1 = _a[1];
                currentOpen.push(open_1);
                currentClose.push(close_1);
            }
        }
        if (currentOpen.length > 0) {
            result.push({
                open: currentOpen,
                close: currentClose
            });
        }
    }
    return result;
}
var RichEditBrackets = /** @class */ (function () {
    function RichEditBrackets(languageIdentifier, _brackets) {
        var e_2, _a, e_3, _b, e_4, _c;
        var brackets = groupFuzzyBrackets(_brackets);
        this.brackets = brackets.map(function (b, index) {
            return new RichEditBracket(languageIdentifier, index, b.open, b.close, getRegexForBracketPair(b.open, b.close, brackets, index), getReversedRegexForBracketPair(b.open, b.close, brackets, index));
        });
        this.forwardRegex = getRegexForBrackets(this.brackets);
        this.reversedRegex = getReversedRegexForBrackets(this.brackets);
        this.textIsBracket = {};
        this.textIsOpenBracket = {};
        this.maxBracketLength = 0;
        try {
            for (var _d = __values(this.brackets), _e = _d.next(); !_e.done; _e = _d.next()) {
                var bracket = _e.value;
                try {
                    for (var _f = (e_3 = void 0, __values(bracket.open)), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var open_2 = _g.value;
                        this.textIsBracket[open_2] = bracket;
                        this.textIsOpenBracket[open_2] = true;
                        this.maxBracketLength = Math.max(this.maxBracketLength, open_2.length);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                try {
                    for (var _h = (e_4 = void 0, __values(bracket.close)), _j = _h.next(); !_j.done; _j = _h.next()) {
                        var close_2 = _j.value;
                        this.textIsBracket[close_2] = bracket;
                        this.textIsOpenBracket[close_2] = false;
                        this.maxBracketLength = Math.max(this.maxBracketLength, close_2.length);
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_j && !_j.done && (_c = _h.return)) _c.call(_h);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    return RichEditBrackets;
}());
export { RichEditBrackets };
function collectSuperstrings(str, brackets, currentIndex, dest) {
    var e_5, _a, e_6, _b;
    for (var i = 0, len = brackets.length; i < len; i++) {
        if (i === currentIndex) {
            continue;
        }
        var bracket = brackets[i];
        try {
            for (var _c = (e_5 = void 0, __values(bracket.open)), _d = _c.next(); !_d.done; _d = _c.next()) {
                var open_3 = _d.value;
                if (open_3.indexOf(str) >= 0) {
                    dest.push(open_3);
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_5) throw e_5.error; }
        }
        try {
            for (var _e = (e_6 = void 0, __values(bracket.close)), _f = _e.next(); !_f.done; _f = _e.next()) {
                var close_3 = _f.value;
                if (close_3.indexOf(str) >= 0) {
                    dest.push(close_3);
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_6) throw e_6.error; }
        }
    }
}
function lengthcmp(a, b) {
    return a.length - b.length;
}
function unique(arr) {
    var e_7, _a;
    if (arr.length <= 1) {
        return arr;
    }
    var result = [];
    var seen = new Set();
    try {
        for (var arr_2 = __values(arr), arr_2_1 = arr_2.next(); !arr_2_1.done; arr_2_1 = arr_2.next()) {
            var element = arr_2_1.value;
            if (seen.has(element)) {
                continue;
            }
            result.push(element);
            seen.add(element);
        }
    }
    catch (e_7_1) { e_7 = { error: e_7_1 }; }
    finally {
        try {
            if (arr_2_1 && !arr_2_1.done && (_a = arr_2.return)) _a.call(arr_2);
        }
        finally { if (e_7) throw e_7.error; }
    }
    return result;
}
function getRegexForBracketPair(open, close, brackets, currentIndex) {
    // search in all brackets for other brackets that are a superstring of these brackets
    var pieces = [];
    pieces = pieces.concat(open);
    pieces = pieces.concat(close);
    for (var i = 0, len = pieces.length; i < len; i++) {
        collectSuperstrings(pieces[i], brackets, currentIndex, pieces);
    }
    pieces = unique(pieces);
    pieces.sort(lengthcmp);
    pieces.reverse();
    return createBracketOrRegExp(pieces);
}
function getReversedRegexForBracketPair(open, close, brackets, currentIndex) {
    // search in all brackets for other brackets that are a superstring of these brackets
    var pieces = [];
    pieces = pieces.concat(open);
    pieces = pieces.concat(close);
    for (var i = 0, len = pieces.length; i < len; i++) {
        collectSuperstrings(pieces[i], brackets, currentIndex, pieces);
    }
    pieces = unique(pieces);
    pieces.sort(lengthcmp);
    pieces.reverse();
    return createBracketOrRegExp(pieces.map(toReversedString));
}
function getRegexForBrackets(brackets) {
    var e_8, _a, e_9, _b, e_10, _c;
    var pieces = [];
    try {
        for (var brackets_1 = __values(brackets), brackets_1_1 = brackets_1.next(); !brackets_1_1.done; brackets_1_1 = brackets_1.next()) {
            var bracket = brackets_1_1.value;
            try {
                for (var _d = (e_9 = void 0, __values(bracket.open)), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var open_4 = _e.value;
                    pieces.push(open_4);
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
                }
                finally { if (e_9) throw e_9.error; }
            }
            try {
                for (var _f = (e_10 = void 0, __values(bracket.close)), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var close_4 = _g.value;
                    pieces.push(close_4);
                }
            }
            catch (e_10_1) { e_10 = { error: e_10_1 }; }
            finally {
                try {
                    if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                }
                finally { if (e_10) throw e_10.error; }
            }
        }
    }
    catch (e_8_1) { e_8 = { error: e_8_1 }; }
    finally {
        try {
            if (brackets_1_1 && !brackets_1_1.done && (_a = brackets_1.return)) _a.call(brackets_1);
        }
        finally { if (e_8) throw e_8.error; }
    }
    pieces = unique(pieces);
    return createBracketOrRegExp(pieces);
}
function getReversedRegexForBrackets(brackets) {
    var e_11, _a, e_12, _b, e_13, _c;
    var pieces = [];
    try {
        for (var brackets_2 = __values(brackets), brackets_2_1 = brackets_2.next(); !brackets_2_1.done; brackets_2_1 = brackets_2.next()) {
            var bracket = brackets_2_1.value;
            try {
                for (var _d = (e_12 = void 0, __values(bracket.open)), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var open_5 = _e.value;
                    pieces.push(open_5);
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
                }
                finally { if (e_12) throw e_12.error; }
            }
            try {
                for (var _f = (e_13 = void 0, __values(bracket.close)), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var close_5 = _g.value;
                    pieces.push(close_5);
                }
            }
            catch (e_13_1) { e_13 = { error: e_13_1 }; }
            finally {
                try {
                    if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                }
                finally { if (e_13) throw e_13.error; }
            }
        }
    }
    catch (e_11_1) { e_11 = { error: e_11_1 }; }
    finally {
        try {
            if (brackets_2_1 && !brackets_2_1.done && (_a = brackets_2.return)) _a.call(brackets_2);
        }
        finally { if (e_11) throw e_11.error; }
    }
    pieces = unique(pieces);
    return createBracketOrRegExp(pieces.map(toReversedString));
}
function prepareBracketForRegExp(str) {
    // This bracket pair uses letters like e.g. "begin" - "end"
    var insertWordBoundaries = (/^[\w ]+$/.test(str));
    str = strings.escapeRegExpCharacters(str);
    return (insertWordBoundaries ? "\\b" + str + "\\b" : str);
}
function createBracketOrRegExp(pieces) {
    var regexStr = "(" + pieces.map(prepareBracketForRegExp).join(')|(') + ")";
    return strings.createRegExp(regexStr, true);
}
var toReversedString = (function () {
    function reverse(str) {
        if (stringBuilder.hasTextDecoder) {
            // create a Uint16Array and then use a TextDecoder to create a string
            var arr = new Uint16Array(str.length);
            var offset = 0;
            for (var i = str.length - 1; i >= 0; i--) {
                arr[offset++] = str.charCodeAt(i);
            }
            return stringBuilder.getPlatformTextDecoder().decode(arr);
        }
        else {
            var result = [], resultLen = 0;
            for (var i = str.length - 1; i >= 0; i--) {
                result[resultLen++] = str.charAt(i);
            }
            return result.join('');
        }
    }
    var lastInput = null;
    var lastOutput = null;
    return function toReversedString(str) {
        if (lastInput !== str) {
            lastInput = str;
            lastOutput = reverse(lastInput);
        }
        return lastOutput;
    };
})();
var BracketsUtils = /** @class */ (function () {
    function BracketsUtils() {
    }
    BracketsUtils._findPrevBracketInText = function (reversedBracketRegex, lineNumber, reversedText, offset) {
        var m = reversedText.match(reversedBracketRegex);
        if (!m) {
            return null;
        }
        var matchOffset = reversedText.length - (m.index || 0);
        var matchLength = m[0].length;
        var absoluteMatchOffset = offset + matchOffset;
        return new Range(lineNumber, absoluteMatchOffset - matchLength + 1, lineNumber, absoluteMatchOffset + 1);
    };
    BracketsUtils.findPrevBracketInRange = function (reversedBracketRegex, lineNumber, lineText, startOffset, endOffset) {
        // Because JS does not support backwards regex search, we search forwards in a reversed string with a reversed regex ;)
        var reversedLineText = toReversedString(lineText);
        var reversedSubstr = reversedLineText.substring(lineText.length - endOffset, lineText.length - startOffset);
        return this._findPrevBracketInText(reversedBracketRegex, lineNumber, reversedSubstr, startOffset);
    };
    BracketsUtils.findNextBracketInText = function (bracketRegex, lineNumber, text, offset) {
        var m = text.match(bracketRegex);
        if (!m) {
            return null;
        }
        var matchOffset = m.index || 0;
        var matchLength = m[0].length;
        if (matchLength === 0) {
            return null;
        }
        var absoluteMatchOffset = offset + matchOffset;
        return new Range(lineNumber, absoluteMatchOffset + 1, lineNumber, absoluteMatchOffset + 1 + matchLength);
    };
    BracketsUtils.findNextBracketInRange = function (bracketRegex, lineNumber, lineText, startOffset, endOffset) {
        var substr = lineText.substring(startOffset, endOffset);
        return this.findNextBracketInText(bracketRegex, lineNumber, substr, startOffset);
    };
    return BracketsUtils;
}());
export { BracketsUtils };
