/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { Disposable } from '../../../common/lifecycle';
import { Emitter, Event } from '../../../common/event';
import { ThrottledDelayer } from '../../../common/async';
import { isUndefinedOrNull } from '../../../common/types';
export var StorageHint;
(function (StorageHint) {
    // A hint to the storage that the storage
    // does not exist on disk yet. This allows
    // the storage library to improve startup
    // time by not checking the storage for data.
    StorageHint[StorageHint["STORAGE_DOES_NOT_EXIST"] = 0] = "STORAGE_DOES_NOT_EXIST";
})(StorageHint || (StorageHint = {}));
var StorageState;
(function (StorageState) {
    StorageState[StorageState["None"] = 0] = "None";
    StorageState[StorageState["Initialized"] = 1] = "Initialized";
    StorageState[StorageState["Closed"] = 2] = "Closed";
})(StorageState || (StorageState = {}));
var Storage = /** @class */ (function (_super) {
    __extends(Storage, _super);
    function Storage(database, options) {
        if (options === void 0) { options = Object.create(null); }
        var _this = _super.call(this) || this;
        _this.database = database;
        _this.options = options;
        _this._onDidChangeStorage = _this._register(new Emitter());
        _this.onDidChangeStorage = _this._onDidChangeStorage.event;
        _this.state = StorageState.None;
        _this.cache = new Map();
        _this.flushDelayer = new ThrottledDelayer(Storage.DEFAULT_FLUSH_DELAY);
        _this.pendingDeletes = new Set();
        _this.pendingInserts = new Map();
        _this.pendingClose = undefined;
        _this.whenFlushedCallbacks = [];
        _this.registerListeners();
        return _this;
    }
    Storage.prototype.registerListeners = function () {
        var _this = this;
        this._register(this.database.onDidChangeItemsExternal(function (e) { return _this.onDidChangeItemsExternal(e); }));
    };
    Storage.prototype.onDidChangeItemsExternal = function (e) {
        var _this = this;
        var _a, _b;
        // items that change external require us to update our
        // caches with the values. we just accept the value and
        // emit an event if there is a change.
        (_a = e.changed) === null || _a === void 0 ? void 0 : _a.forEach(function (value, key) { return _this.accept(key, value); });
        (_b = e.deleted) === null || _b === void 0 ? void 0 : _b.forEach(function (key) { return _this.accept(key, undefined); });
    };
    Storage.prototype.accept = function (key, value) {
        if (this.state === StorageState.Closed) {
            return; // Return early if we are already closed
        }
        var changed = false;
        // Item got removed, check for deletion
        if (isUndefinedOrNull(value)) {
            changed = this.cache.delete(key);
        }
        // Item got updated, check for change
        else {
            var currentValue = this.cache.get(key);
            if (currentValue !== value) {
                this.cache.set(key, value);
                changed = true;
            }
        }
        // Signal to outside listeners
        if (changed) {
            this._onDidChangeStorage.fire(key);
        }
    };
    Object.defineProperty(Storage.prototype, "items", {
        get: function () {
            return this.cache;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Storage.prototype, "size", {
        get: function () {
            return this.cache.size;
        },
        enumerable: false,
        configurable: true
    });
    Storage.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (this.state !== StorageState.None) {
                            return [2 /*return*/]; // either closed or already initialized
                        }
                        this.state = StorageState.Initialized;
                        if (this.options.hint === StorageHint.STORAGE_DOES_NOT_EXIST) {
                            // return early if we know the storage file does not exist. this is a performance
                            // optimization to not load all items of the underlying storage if we know that
                            // there can be no items because the storage does not exist.
                            return [2 /*return*/];
                        }
                        _a = this;
                        return [4 /*yield*/, this.database.getItems()];
                    case 1:
                        _a.cache = _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Storage.prototype.get = function (key, fallbackValue) {
        var value = this.cache.get(key);
        if (isUndefinedOrNull(value)) {
            return fallbackValue;
        }
        return value;
    };
    Storage.prototype.getBoolean = function (key, fallbackValue) {
        var value = this.get(key);
        if (isUndefinedOrNull(value)) {
            return fallbackValue;
        }
        return value === 'true';
    };
    Storage.prototype.getNumber = function (key, fallbackValue) {
        var value = this.get(key);
        if (isUndefinedOrNull(value)) {
            return fallbackValue;
        }
        return parseInt(value, 10);
    };
    Storage.prototype.set = function (key, value) {
        return __awaiter(this, void 0, void 0, function () {
            var valueStr, currentValue;
            var _this = this;
            return __generator(this, function (_a) {
                if (this.state === StorageState.Closed) {
                    return [2 /*return*/]; // Return early if we are already closed
                }
                // We remove the key for undefined/null values
                if (isUndefinedOrNull(value)) {
                    return [2 /*return*/, this.delete(key)];
                }
                valueStr = String(value);
                currentValue = this.cache.get(key);
                if (currentValue === valueStr) {
                    return [2 /*return*/];
                }
                // Update in cache and pending
                this.cache.set(key, valueStr);
                this.pendingInserts.set(key, valueStr);
                this.pendingDeletes.delete(key);
                // Event
                this._onDidChangeStorage.fire(key);
                // Accumulate work by scheduling after timeout
                return [2 /*return*/, this.flushDelayer.trigger(function () { return _this.flushPending(); })];
            });
        });
    };
    Storage.prototype.delete = function (key) {
        return __awaiter(this, void 0, void 0, function () {
            var wasDeleted;
            var _this = this;
            return __generator(this, function (_a) {
                if (this.state === StorageState.Closed) {
                    return [2 /*return*/]; // Return early if we are already closed
                }
                wasDeleted = this.cache.delete(key);
                if (!wasDeleted) {
                    return [2 /*return*/]; // Return early if value already deleted
                }
                if (!this.pendingDeletes.has(key)) {
                    this.pendingDeletes.add(key);
                }
                this.pendingInserts.delete(key);
                // Event
                this._onDidChangeStorage.fire(key);
                // Accumulate work by scheduling after timeout
                return [2 /*return*/, this.flushDelayer.trigger(function () { return _this.flushPending(); })];
            });
        });
    };
    Storage.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (!this.pendingClose) {
                    this.pendingClose = this.doClose();
                }
                return [2 /*return*/, this.pendingClose];
            });
        });
    };
    Storage.prototype.doClose = function () {
        return __awaiter(this, void 0, void 0, function () {
            var error_1;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        // Update state
                        this.state = StorageState.Closed;
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.flushDelayer.trigger(function () { return _this.flushPending(); }, 0 /* as soon as possible */)];
                    case 2:
                        _a.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        error_1 = _a.sent();
                        return [3 /*break*/, 4];
                    case 4: return [4 /*yield*/, this.database.close(function () { return _this.cache; })];
                    case 5:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Object.defineProperty(Storage.prototype, "hasPending", {
        get: function () {
            return this.pendingInserts.size > 0 || this.pendingDeletes.size > 0;
        },
        enumerable: false,
        configurable: true
    });
    Storage.prototype.flushPending = function () {
        return __awaiter(this, void 0, void 0, function () {
            var updateRequest;
            var _this = this;
            return __generator(this, function (_a) {
                if (!this.hasPending) {
                    return [2 /*return*/]; // return early if nothing to do
                }
                updateRequest = { insert: this.pendingInserts, delete: this.pendingDeletes };
                // Reset pending data for next run
                this.pendingDeletes = new Set();
                this.pendingInserts = new Map();
                // Update in storage and release any
                // waiters we have once done
                return [2 /*return*/, this.database.updateItems(updateRequest).finally(function () {
                        var _a;
                        if (!_this.hasPending) {
                            while (_this.whenFlushedCallbacks.length) {
                                (_a = _this.whenFlushedCallbacks.pop()) === null || _a === void 0 ? void 0 : _a();
                            }
                        }
                    })];
            });
        });
    };
    Storage.prototype.whenFlushed = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                if (!this.hasPending) {
                    return [2 /*return*/]; // return early if nothing to do
                }
                return [2 /*return*/, new Promise(function (resolve) { return _this.whenFlushedCallbacks.push(resolve); })];
            });
        });
    };
    Storage.prototype.dispose = function () {
        this.flushDelayer.cancel(); // workaround https://github.com/microsoft/vscode/issues/116777
        this.flushDelayer.dispose();
        _super.prototype.dispose.call(this);
    };
    Storage.DEFAULT_FLUSH_DELAY = 100;
    return Storage;
}(Disposable));
export { Storage };
var InMemoryStorageDatabase = /** @class */ (function () {
    function InMemoryStorageDatabase() {
        this.onDidChangeItemsExternal = Event.None;
        this.items = new Map();
    }
    InMemoryStorageDatabase.prototype.getItems = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.items];
            });
        });
    };
    InMemoryStorageDatabase.prototype.updateItems = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                if (request.insert) {
                    request.insert.forEach(function (value, key) { return _this.items.set(key, value); });
                }
                if (request.delete) {
                    request.delete.forEach(function (key) { return _this.items.delete(key); });
                }
                return [2 /*return*/];
            });
        });
    };
    InMemoryStorageDatabase.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    return InMemoryStorageDatabase;
}());
export { InMemoryStorageDatabase };
