/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import './iconlabel.css';
import * as dom from '../../dom';
import { HighlightedLabel } from '../highlightedlabel/highlightedLabel';
import { Disposable } from '../../../common/lifecycle';
import { Range } from '../../../common/range';
import { equals } from '../../../common/objects';
import { isMacintosh } from '../../../common/platform';
import { isFunction, isString } from '../../../common/types';
import { domEvent } from '../../event';
import { localize } from '../../../../nls';
import { CancellationTokenSource } from '../../../common/cancellation';
var FastLabelNode = /** @class */ (function () {
    function FastLabelNode(_element) {
        this._element = _element;
    }
    Object.defineProperty(FastLabelNode.prototype, "element", {
        get: function () {
            return this._element;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FastLabelNode.prototype, "textContent", {
        set: function (content) {
            if (this.disposed || content === this._textContent) {
                return;
            }
            this._textContent = content;
            this._element.textContent = content;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FastLabelNode.prototype, "className", {
        set: function (className) {
            if (this.disposed || className === this._className) {
                return;
            }
            this._className = className;
            this._element.className = className;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FastLabelNode.prototype, "empty", {
        set: function (empty) {
            if (this.disposed || empty === this._empty) {
                return;
            }
            this._empty = empty;
            this._element.style.marginLeft = empty ? '0' : '';
        },
        enumerable: false,
        configurable: true
    });
    FastLabelNode.prototype.dispose = function () {
        this.disposed = true;
    };
    return FastLabelNode;
}());
var IconLabel = /** @class */ (function (_super) {
    __extends(IconLabel, _super);
    function IconLabel(container, options) {
        var _this = _super.call(this) || this;
        _this.hoverDelegate = undefined;
        _this.customHovers = new Map();
        _this.domNode = _this._register(new FastLabelNode(dom.append(container, dom.$('.monaco-icon-label'))));
        _this.labelContainer = dom.append(_this.domNode.element, dom.$('.monaco-icon-label-container'));
        var nameContainer = dom.append(_this.labelContainer, dom.$('span.monaco-icon-name-container'));
        _this.descriptionContainer = _this._register(new FastLabelNode(dom.append(_this.labelContainer, dom.$('span.monaco-icon-description-container'))));
        if (options === null || options === void 0 ? void 0 : options.supportHighlights) {
            _this.nameNode = new LabelWithHighlights(nameContainer, !!options.supportIcons);
        }
        else {
            _this.nameNode = new Label(nameContainer);
        }
        if (options === null || options === void 0 ? void 0 : options.supportDescriptionHighlights) {
            _this.descriptionNodeFactory = function () { return new HighlightedLabel(dom.append(_this.descriptionContainer.element, dom.$('span.label-description')), !!options.supportIcons); };
        }
        else {
            _this.descriptionNodeFactory = function () { return _this._register(new FastLabelNode(dom.append(_this.descriptionContainer.element, dom.$('span.label-description')))); };
        }
        if (options === null || options === void 0 ? void 0 : options.hoverDelegate) {
            _this.hoverDelegate = options.hoverDelegate;
        }
        return _this;
    }
    Object.defineProperty(IconLabel.prototype, "element", {
        get: function () {
            return this.domNode.element;
        },
        enumerable: false,
        configurable: true
    });
    IconLabel.prototype.setLabel = function (label, description, options) {
        var classes = ['monaco-icon-label'];
        if (options) {
            if (options.extraClasses) {
                classes.push.apply(classes, __spreadArray([], __read(options.extraClasses)));
            }
            if (options.italic) {
                classes.push('italic');
            }
            if (options.strikethrough) {
                classes.push('strikethrough');
            }
        }
        this.domNode.className = classes.join(' ');
        this.setupHover(this.labelContainer, options === null || options === void 0 ? void 0 : options.title);
        this.nameNode.setLabel(label, options);
        if (description || this.descriptionNode) {
            if (!this.descriptionNode) {
                this.descriptionNode = this.descriptionNodeFactory(); // description node is created lazily on demand
            }
            if (this.descriptionNode instanceof HighlightedLabel) {
                this.descriptionNode.set(description || '', options ? options.descriptionMatches : undefined);
                this.setupHover(this.descriptionNode.element, options === null || options === void 0 ? void 0 : options.descriptionTitle);
            }
            else {
                this.descriptionNode.textContent = description || '';
                this.setupHover(this.descriptionNode.element, (options === null || options === void 0 ? void 0 : options.descriptionTitle) || '');
                this.descriptionNode.empty = !description;
            }
        }
    };
    IconLabel.prototype.setupHover = function (htmlElement, tooltip) {
        var previousCustomHover = this.customHovers.get(htmlElement);
        if (previousCustomHover) {
            previousCustomHover.dispose();
            this.customHovers.delete(htmlElement);
        }
        if (!tooltip) {
            htmlElement.removeAttribute('title');
            return;
        }
        if (!this.hoverDelegate) {
            return this.setupNativeHover(htmlElement, tooltip);
        }
        else {
            return this.setupCustomHover(this.hoverDelegate, htmlElement, tooltip);
        }
    };
    IconLabel.adjustXAndShowCustomHover = function (hoverOptions, mouseX, hoverDelegate, isHovering) {
        if (hoverOptions && isHovering) {
            if (mouseX !== undefined) {
                hoverOptions.target.x = mouseX + 10;
            }
            return hoverDelegate.showHover(hoverOptions);
        }
        return undefined;
    };
    IconLabel.prototype.getTooltipForCustom = function (markdownTooltip) {
        var _this = this;
        if (isString(markdownTooltip)) {
            return function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                return [2 /*return*/, markdownTooltip];
            }); }); };
        }
        else if (isFunction(markdownTooltip.markdown)) {
            return markdownTooltip.markdown;
        }
        else {
            var markdown_1 = markdownTooltip.markdown;
            return function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                return [2 /*return*/, markdown_1];
            }); }); };
        }
    };
    IconLabel.prototype.setupCustomHover = function (hoverDelegate, htmlElement, markdownTooltip) {
        htmlElement.setAttribute('title', '');
        htmlElement.removeAttribute('title');
        var tooltip = this.getTooltipForCustom(markdownTooltip);
        // Testing has indicated that on Windows and Linux 500 ms matches the native hovers most closely.
        // On Mac, the delay is 1500.
        var hoverDelay = isMacintosh ? 1500 : 500;
        var hoverOptions;
        var mouseX;
        var isHovering = false;
        var tokenSource;
        var hoverDisposable;
        function mouseOver(e) {
            var _this = this;
            if (isHovering) {
                return;
            }
            tokenSource = new CancellationTokenSource();
            function mouseLeaveOrDown(e) {
                if ((e.type === dom.EventType.MOUSE_DOWN) || e.fromElement === htmlElement) {
                    hoverDisposable === null || hoverDisposable === void 0 ? void 0 : hoverDisposable.dispose();
                    hoverDisposable = undefined;
                    isHovering = false;
                    hoverOptions = undefined;
                    tokenSource.dispose(true);
                    mouseLeaveDisposable.dispose();
                    mouseDownDisposable.dispose();
                }
            }
            var mouseLeaveDisposable = domEvent(htmlElement, dom.EventType.MOUSE_LEAVE, true)(mouseLeaveOrDown.bind(htmlElement));
            var mouseDownDisposable = domEvent(htmlElement, dom.EventType.MOUSE_DOWN, true)(mouseLeaveOrDown.bind(htmlElement));
            isHovering = true;
            function mouseMove(e) {
                mouseX = e.x;
            }
            var mouseMoveDisposable = domEvent(htmlElement, dom.EventType.MOUSE_MOVE, true)(mouseMove.bind(htmlElement));
            setTimeout(function () { return __awaiter(_this, void 0, void 0, function () {
                var target, resolvedTooltip;
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            if (!(isHovering && tooltip)) return [3 /*break*/, 2];
                            if (!!hoverOptions) return [3 /*break*/, 2];
                            target = {
                                targetElements: [this],
                                dispose: function () { }
                            };
                            hoverOptions = {
                                text: localize('iconLabel.loading', "Loading..."),
                                target: target,
                                anchorPosition: 0 /* BELOW */
                            };
                            hoverDisposable = IconLabel.adjustXAndShowCustomHover(hoverOptions, mouseX, hoverDelegate, isHovering);
                            return [4 /*yield*/, tooltip(tokenSource.token)];
                        case 1:
                            resolvedTooltip = (_a = (_b.sent())) !== null && _a !== void 0 ? _a : (!isString(markdownTooltip) ? markdownTooltip.markdownNotSupportedFallback : undefined);
                            if (resolvedTooltip) {
                                hoverOptions = {
                                    text: resolvedTooltip,
                                    target: target,
                                    anchorPosition: 0 /* BELOW */
                                };
                                // awaiting the tooltip could take a while. Make sure we're still hovering.
                                hoverDisposable = IconLabel.adjustXAndShowCustomHover(hoverOptions, mouseX, hoverDelegate, isHovering);
                            }
                            else if (hoverDisposable) {
                                hoverDisposable.dispose();
                                hoverDisposable = undefined;
                            }
                            _b.label = 2;
                        case 2:
                            mouseMoveDisposable.dispose();
                            return [2 /*return*/];
                    }
                });
            }); }, hoverDelay);
        }
        var mouseOverDisposable = this._register(domEvent(htmlElement, dom.EventType.MOUSE_OVER, true)(mouseOver.bind(htmlElement)));
        this.customHovers.set(htmlElement, mouseOverDisposable);
    };
    IconLabel.prototype.setupNativeHover = function (htmlElement, tooltip) {
        var stringTooltip = '';
        if (isString(tooltip)) {
            stringTooltip = tooltip;
        }
        else if (tooltip === null || tooltip === void 0 ? void 0 : tooltip.markdownNotSupportedFallback) {
            stringTooltip = tooltip.markdownNotSupportedFallback;
        }
        htmlElement.title = stringTooltip;
    };
    return IconLabel;
}(Disposable));
export { IconLabel };
var Label = /** @class */ (function () {
    function Label(container) {
        this.container = container;
        this.label = undefined;
        this.singleLabel = undefined;
    }
    Label.prototype.setLabel = function (label, options) {
        if (this.label === label && equals(this.options, options)) {
            return;
        }
        this.label = label;
        this.options = options;
        if (typeof label === 'string') {
            if (!this.singleLabel) {
                this.container.innerText = '';
                this.container.classList.remove('multiple');
                this.singleLabel = dom.append(this.container, dom.$('a.label-name', { id: options === null || options === void 0 ? void 0 : options.domId }));
            }
            this.singleLabel.textContent = label;
        }
        else {
            this.container.innerText = '';
            this.container.classList.add('multiple');
            this.singleLabel = undefined;
            for (var i = 0; i < label.length; i++) {
                var l = label[i];
                var id = (options === null || options === void 0 ? void 0 : options.domId) && (options === null || options === void 0 ? void 0 : options.domId) + "_" + i;
                dom.append(this.container, dom.$('a.label-name', { id: id, 'data-icon-label-count': label.length, 'data-icon-label-index': i, 'role': 'treeitem' }, l));
                if (i < label.length - 1) {
                    dom.append(this.container, dom.$('span.label-separator', undefined, (options === null || options === void 0 ? void 0 : options.separator) || '/'));
                }
            }
        }
    };
    return Label;
}());
function splitMatches(labels, separator, matches) {
    if (!matches) {
        return undefined;
    }
    var labelStart = 0;
    return labels.map(function (label) {
        var labelRange = { start: labelStart, end: labelStart + label.length };
        var result = matches
            .map(function (match) { return Range.intersect(labelRange, match); })
            .filter(function (range) { return !Range.isEmpty(range); })
            .map(function (_a) {
            var start = _a.start, end = _a.end;
            return ({ start: start - labelStart, end: end - labelStart });
        });
        labelStart = labelRange.end + separator.length;
        return result;
    });
}
var LabelWithHighlights = /** @class */ (function () {
    function LabelWithHighlights(container, supportIcons) {
        this.container = container;
        this.supportIcons = supportIcons;
        this.label = undefined;
        this.singleLabel = undefined;
    }
    LabelWithHighlights.prototype.setLabel = function (label, options) {
        if (this.label === label && equals(this.options, options)) {
            return;
        }
        this.label = label;
        this.options = options;
        if (typeof label === 'string') {
            if (!this.singleLabel) {
                this.container.innerText = '';
                this.container.classList.remove('multiple');
                this.singleLabel = new HighlightedLabel(dom.append(this.container, dom.$('a.label-name', { id: options === null || options === void 0 ? void 0 : options.domId })), this.supportIcons);
            }
            this.singleLabel.set(label, options === null || options === void 0 ? void 0 : options.matches, undefined, options === null || options === void 0 ? void 0 : options.labelEscapeNewLines);
        }
        else {
            this.container.innerText = '';
            this.container.classList.add('multiple');
            this.singleLabel = undefined;
            var separator = (options === null || options === void 0 ? void 0 : options.separator) || '/';
            var matches = splitMatches(label, separator, options === null || options === void 0 ? void 0 : options.matches);
            for (var i = 0; i < label.length; i++) {
                var l = label[i];
                var m = matches ? matches[i] : undefined;
                var id = (options === null || options === void 0 ? void 0 : options.domId) && (options === null || options === void 0 ? void 0 : options.domId) + "_" + i;
                var name_1 = dom.$('a.label-name', { id: id, 'data-icon-label-count': label.length, 'data-icon-label-index': i, 'role': 'treeitem' });
                var highlightedLabel = new HighlightedLabel(dom.append(this.container, name_1), this.supportIcons);
                highlightedLabel.set(l, m, undefined, options === null || options === void 0 ? void 0 : options.labelEscapeNewLines);
                if (i < label.length - 1) {
                    dom.append(name_1, dom.$('span.label-separator', undefined, separator));
                }
            }
        }
    };
    return LabelWithHighlights;
}());
