/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import * as objects from '../../../common/objects';
import * as dom from '../../dom';
import { renderLabelWithIcons } from '../iconLabel/iconLabels';
var HighlightedLabel = /** @class */ (function () {
    function HighlightedLabel(container, supportIcons) {
        this.supportIcons = supportIcons;
        this.text = '';
        this.title = '';
        this.highlights = [];
        this.didEverRender = false;
        this.domNode = document.createElement('span');
        this.domNode.className = 'monaco-highlighted-label';
        container.appendChild(this.domNode);
    }
    Object.defineProperty(HighlightedLabel.prototype, "element", {
        get: function () {
            return this.domNode;
        },
        enumerable: false,
        configurable: true
    });
    HighlightedLabel.prototype.set = function (text, highlights, title, escapeNewLines) {
        if (highlights === void 0) { highlights = []; }
        if (title === void 0) { title = ''; }
        if (!text) {
            text = '';
        }
        if (escapeNewLines) {
            // adjusts highlights inplace
            text = HighlightedLabel.escapeNewLines(text, highlights);
        }
        if (this.didEverRender && this.text === text && this.title === title && objects.equals(this.highlights, highlights)) {
            return;
        }
        this.text = text;
        this.title = title;
        this.highlights = highlights;
        this.render();
    };
    HighlightedLabel.prototype.render = function () {
        var e_1, _a;
        var children = [];
        var pos = 0;
        try {
            for (var _b = __values(this.highlights), _c = _b.next(); !_c.done; _c = _b.next()) {
                var highlight = _c.value;
                if (highlight.end === highlight.start) {
                    continue;
                }
                if (pos < highlight.start) {
                    var substring_1 = this.text.substring(pos, highlight.start);
                    children.push(dom.$.apply(dom, __spreadArray(['span', undefined], __read(this.supportIcons ? renderLabelWithIcons(substring_1) : [substring_1]))));
                    pos = highlight.end;
                }
                var substring = this.text.substring(highlight.start, highlight.end);
                var element = dom.$.apply(dom, __spreadArray(['span.highlight', undefined], __read(this.supportIcons ? renderLabelWithIcons(substring) : [substring])));
                if (highlight.extraClasses) {
                    element.classList.add(highlight.extraClasses);
                }
                children.push(element);
                pos = highlight.end;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (pos < this.text.length) {
            var substring = this.text.substring(pos);
            children.push(dom.$.apply(dom, __spreadArray(['span', undefined], __read(this.supportIcons ? renderLabelWithIcons(substring) : [substring]))));
        }
        dom.reset.apply(dom, __spreadArray([this.domNode], __read(children)));
        if (this.title) {
            this.domNode.title = this.title;
        }
        else {
            this.domNode.removeAttribute('title');
        }
        this.didEverRender = true;
    };
    HighlightedLabel.escapeNewLines = function (text, highlights) {
        var total = 0;
        var extra = 0;
        return text.replace(/\r\n|\r|\n/g, function (match, offset) {
            var e_2, _a;
            extra = match === '\r\n' ? -1 : 0;
            offset += total;
            try {
                for (var highlights_1 = __values(highlights), highlights_1_1 = highlights_1.next(); !highlights_1_1.done; highlights_1_1 = highlights_1.next()) {
                    var highlight = highlights_1_1.value;
                    if (highlight.end <= offset) {
                        continue;
                    }
                    if (highlight.start >= offset) {
                        highlight.start += extra;
                    }
                    if (highlight.end >= offset) {
                        highlight.end += extra;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (highlights_1_1 && !highlights_1_1.done && (_a = highlights_1.return)) _a.call(highlights_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
            total += extra;
            return '\u23CE';
        });
    };
    return HighlightedLabel;
}());
export { HighlightedLabel };
