/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AutomaticModuleNaming;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.internal.InternalModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleSupport {
    public static final String MODULE_INFO_JAVA = "module-info.java";
    private static final Logger log = LoggerFactory.getLogger(ModuleSupport.class);

    public static void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) {
        InternalModuleInfo moduleInfo;
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        if (javaProject == null || !javaProject.exists() || classpath == null) {
            return;
        }
        int targetCompliance = 8;
        String option = javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        if (option != null) {
            if (option.startsWith("1.")) {
                option = option.substring("1.".length());
            }
            try {
                targetCompliance = Integer.parseInt(option);
            }
            catch (NumberFormatException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (targetCompliance < 9) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((moduleInfo = ModuleSupport.getModuleInfo(javaProject, monitor)) == null) {
            return;
        }
        LinkedHashMap<String, InternalModuleInfo> entryModuleInfos = new LinkedHashMap<String, InternalModuleInfo>();
        LinkedHashMap<String, IClasspathEntryDescriptor> entryDescriptors = new LinkedHashMap<String, IClasspathEntryDescriptor>();
        for (IClasspathEntryDescriptor entryDescriptor : classpath.getEntryDescriptors()) {
            if (monitor.isCanceled()) {
                return;
            }
            InternalModuleInfo entryModuleInfo = ModuleSupport.getModuleInfo(entryDescriptor, monitor, targetCompliance);
            if (entryModuleInfo == null) continue;
            entryModuleInfos.put(entryModuleInfo.name, entryModuleInfo);
            entryDescriptors.put(entryModuleInfo.name, entryDescriptor);
        }
        Set<String> neededModuleNames = ModuleSupport.collectModulesNeededTransitively(moduleInfo, entryModuleInfos);
        if (monitor.isCanceled()) {
            return;
        }
        entryDescriptors.forEach((entryModuleName, entry) -> {
            if (neededModuleNames.contains(entryModuleName)) {
                entry.setClasspathAttribute("module", Boolean.TRUE.toString());
            }
        });
    }

    private static Set<String> collectModulesNeededTransitively(InternalModuleInfo module, Map<String, InternalModuleInfo> classpathModules) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Function<InternalModuleInfo, Set<String>> neededModulesLookup = ModuleSupport.createNeededModulesLookup(classpathModules);
        Set<String> todo = neededModulesLookup.apply(module);
        while (!todo.isEmpty()) {
            LinkedHashSet<String> todoNext = new LinkedHashSet<String>();
            for (String neededModuleName : todo) {
                if (!result.add(neededModuleName)) continue;
                InternalModuleInfo neededModule = classpathModules.get(neededModuleName);
                todoNext.addAll((Collection<String>)neededModulesLookup.apply(neededModule));
            }
            todo = todoNext;
        }
        return result;
    }

    private static Function<InternalModuleInfo, Set<String>> createNeededModulesLookup(Map<String, InternalModuleInfo> classpathModules) {
        LinkedHashMap<String, Set> providersByServiceName = new LinkedHashMap<String, Set>();
        for (InternalModuleInfo classpathModule : classpathModules.values()) {
            for (String serviceName : classpathModule.providedServiceNames) {
                providersByServiceName.computeIfAbsent(serviceName, k -> new LinkedHashSet()).add(classpathModule.name);
            }
        }
        return module -> {
            if (module != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                result.addAll(module.requiredModuleNames);
                for (String serviceName : module.usedServiceNames) {
                    Set providerNames = providersByServiceName.getOrDefault(serviceName, Collections.emptySet());
                    result.addAll(providerNames);
                }
                return result;
            }
            return Collections.emptySet();
        };
    }

    private static InternalModuleInfo getModuleInfo(IClasspathEntryDescriptor entry, IProgressMonitor monitor, int targetCompliance) {
        if (entry != null && !monitor.isCanceled()) {
            if (1 == entry.getEntryKind()) {
                return ModuleSupport.getModuleInfo(entry.getPath().toFile(), targetCompliance);
            }
            if (2 == entry.getEntryKind()) {
                return ModuleSupport.getModuleInfo(ModuleSupport.getJavaProject(entry.getPath()), monitor);
            }
        }
        return null;
    }

    static InternalModuleInfo getModuleInfo(IJavaProject project, IProgressMonitor monitor) {
        if (project != null) {
            try {
                MavenProject mavenProject;
                IModuleDescription moduleDescription = project.getModuleDescription();
                if (moduleDescription != null) {
                    return InternalModuleInfo.fromDescription(moduleDescription);
                }
                String buildName = null;
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project.getProject());
                if (facade != null && (mavenProject = facade.getMavenProject(monitor)) != null) {
                    buildName = mavenProject.getBuild().getFinalName();
                }
                if (buildName == null || buildName.isEmpty()) {
                    buildName = project.getElementName();
                }
                String moduleName = new String(AutomaticModuleNaming.determineAutomaticModuleName((String)buildName, (boolean)false, null));
                return InternalModuleInfo.withAutomaticName(moduleName);
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private static InternalModuleInfo getModuleInfo(File file, int targetCompliance) {
        if (!file.isFile()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JarFile jar = new JarFile(file, false);){
                String automaticModuleName;
                int compliance;
                Manifest manifest = jar.getManifest();
                boolean isMultiRelease = false;
                if (manifest != null) {
                    isMultiRelease = "true".equalsIgnoreCase(manifest.getMainAttributes().getValue("Multi-Release"));
                }
                int i = compliance = isMultiRelease ? targetCompliance : 8;
                while (i >= 8) {
                    IBinaryModule module;
                    String filename = i == 8 ? "module-info.class" : "META-INF/versions/" + i + "/" + "module-info.class";
                    ClassFileReader reader = ClassFileReader.read((ZipFile)jar, (String)filename);
                    if (reader != null && (module = reader.getModuleDeclaration()) != null) {
                        return InternalModuleInfo.fromDeclaration((IModule)module);
                    }
                    --i;
                }
                if (manifest != null && (automaticModuleName = manifest.getMainAttributes().getValue("Automatic-Module-Name")) != null) {
                    return InternalModuleInfo.withAutomaticName(automaticModuleName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException ex) {
            log.error(ex.getMessage(), ex);
        }
        return InternalModuleInfo.withAutomaticNameFromFile(file);
    }

    private static IJavaProject getJavaProject(IPath projectPath) {
        if (projectPath == null || projectPath.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectPath.lastSegment());
        if (project.isAccessible()) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean isModuleEntry(IClasspathEntry entry) {
        return Arrays.stream(entry.getExtraAttributes()).anyMatch(p -> "module".equals(p.getName()) && "true".equals(p.getValue()));
    }

    public static int determineModularClasspathProperty(IClasspathEntry entry) {
        return ModuleSupport.isModuleEntry(entry) ? 4 : 5;
    }

    public static IRuntimeClasspathEntry createRuntimeClasspathEntry(IFolder folder, int classpathProperty, IProject project) {
        if (classpathProperty == 4 && !folder.exists((IPath)new Path("module-info.class"))) {
            classpathProperty = 6;
        }
        IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)folder.getFullPath(), (int)classpathProperty);
        if (classpathProperty == 6) {
            ((RuntimeClasspathEntry)newArchiveRuntimeClasspathEntry).setJavaProject(JavaCore.create((IProject)project));
        }
        return newArchiveRuntimeClasspathEntry;
    }

    public static int determineClasspathPropertyForMainProject(boolean isModularConfiguration, IJavaProject javaProject) {
        if (!isModularConfiguration) {
            return 3;
        }
        if (!JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            return 5;
        }
        return 4;
    }

    public static IRuntimeClasspathEntry newModularProjectRuntimeClasspathEntry(IJavaProject javaProject) {
        return JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject, (int)(JavaRuntime.isModularProject((IJavaProject)javaProject) ? 4 : 5));
    }

    public static boolean isMavenJavaProject(IProject project) {
        try {
            return project != null && project.isOpen() && project.hasNature("org.eclipse.m2e.core.maven2Nature") && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

