"use strict";
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultWindowService = void 0;
const inversify_1 = require("inversify");
const common_1 = require("../../common");
const core_preferences_1 = require("../core-preferences");
const contribution_provider_1 = require("../../common/contribution-provider");
const frontend_application_1 = require("../frontend-application");
const window_service_1 = require("./window-service");
let DefaultWindowService = class DefaultWindowService {
    constructor() {
        this.onUnloadEmitter = new common_1.Emitter();
    }
    get onUnload() {
        return this.onUnloadEmitter.event;
    }
    onStart(app) {
        this.frontendApplication = app;
        this.registerUnloadListeners();
    }
    openNewWindow(url) {
        window.open(url, undefined, 'noopener');
        return undefined;
    }
    openNewDefaultWindow() {
        this.openNewWindow(window_service_1.DEFAULT_WINDOW_HASH);
    }
    canUnload() {
        var _a;
        const confirmExit = this.corePreferences['application.confirmExit'];
        let preventUnload = confirmExit === 'always';
        for (const contribution of this.contributions.getContributions()) {
            if ((_a = contribution.onWillStop) === null || _a === void 0 ? void 0 : _a.call(contribution, this.frontendApplication)) {
                preventUnload = true;
            }
        }
        return confirmExit === 'never' || !preventUnload;
    }
    /**
     * Implement the mechanism to detect unloading of the page.
     */
    registerUnloadListeners() {
        window.addEventListener('beforeunload', event => {
            if (!this.canUnload()) {
                return this.preventUnload(event);
            }
        });
        // In a browser, `unload` is correctly fired when the page unloads, unlike Electron.
        // If `beforeunload` is cancelled, the user will be prompted to leave or stay.
        // If the user stays, the page won't be unloaded, so `unload` is not fired.
        // If the user leaves, the page will be unloaded, so `unload` is fired.
        window.addEventListener('unload', () => this.onUnloadEmitter.fire());
    }
    /**
     * Notify the browser that we do not want to unload.
     *
     * Notes:
     *  - Shows a confirmation popup in browsers.
     *  - Prevents the window from closing without confirmation in electron.
     *
     * @param event The beforeunload event
     */
    preventUnload(event) {
        event.returnValue = '';
        event.preventDefault();
        return '';
    }
};
__decorate([
    inversify_1.inject(core_preferences_1.CorePreferences),
    __metadata("design:type", Object)
], DefaultWindowService.prototype, "corePreferences", void 0);
__decorate([
    inversify_1.inject(contribution_provider_1.ContributionProvider),
    inversify_1.named(frontend_application_1.FrontendApplicationContribution),
    __metadata("design:type", Object)
], DefaultWindowService.prototype, "contributions", void 0);
DefaultWindowService = __decorate([
    inversify_1.injectable()
], DefaultWindowService);
exports.DefaultWindowService = DefaultWindowService;
//# sourceMappingURL=default-window-service.js.map