"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonacoContextKeyService = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const context_key_service_1 = require("@theia/core/lib/browser/context-key-service");
let MonacoContextKeyService = class MonacoContextKeyService extends context_key_service_1.ContextKeyService {
    constructor() {
        super(...arguments);
        this.expressions = new Map();
    }
    init() {
        this.contextKeyService.onDidChangeContext(e => this.fireDidChange({
            affects: keys => e.affectsSome(keys)
        }));
    }
    createKey(key, defaultValue) {
        return this.contextKeyService.createKey(key, defaultValue);
    }
    match(expression, context) {
        const ctx = context || this.activeContext || (window.document.activeElement instanceof HTMLElement ? window.document.activeElement : undefined);
        const parsed = this.parse(expression);
        if (!ctx) {
            return this.contextKeyService.contextMatchesRules(parsed);
        }
        const keyContext = this.contextKeyService.getContext(ctx);
        return monaco.keybindings.KeybindingResolver.contextMatchesRules(keyContext, parsed);
    }
    parse(when) {
        let expression = this.expressions.get(when);
        if (!expression) {
            expression = monaco.contextkey.ContextKeyExpr.deserialize(when);
            if (expression) {
                this.expressions.set(when, expression);
            }
        }
        return expression;
    }
    parseKeys(expression) {
        const expr = monaco.contextkey.ContextKeyExpr.deserialize(expression);
        return expr ? new Set(expr.keys()) : expr;
    }
};
__decorate([
    inversify_1.inject(monaco.contextKeyService.ContextKeyService),
    __metadata("design:type", monaco.contextKeyService.ContextKeyService)
], MonacoContextKeyService.prototype, "contextKeyService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MonacoContextKeyService.prototype, "init", null);
MonacoContextKeyService = __decorate([
    inversify_1.injectable()
], MonacoContextKeyService);
exports.MonacoContextKeyService = MonacoContextKeyService;
//# sourceMappingURL=monaco-context-key-service.js.map