/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import * as dom from '../../../../base/browser/dom';
import { createFastDomNode } from '../../../../base/browser/fastDomNode';
import { PartFingerprints, ViewPart } from '../../view/viewPart';
var Coordinate = /** @class */ (function () {
    function Coordinate(top, left) {
        this.top = top;
        this.left = left;
    }
    return Coordinate;
}());
var ViewContentWidgets = /** @class */ (function (_super) {
    __extends(ViewContentWidgets, _super);
    function ViewContentWidgets(context, viewDomNode) {
        var _this = _super.call(this, context) || this;
        _this._viewDomNode = viewDomNode;
        _this._widgets = {};
        _this.domNode = createFastDomNode(document.createElement('div'));
        PartFingerprints.write(_this.domNode, 1 /* ContentWidgets */);
        _this.domNode.setClassName('contentWidgets');
        _this.domNode.setPosition('absolute');
        _this.domNode.setTop(0);
        _this.overflowingContentWidgetsDomNode = createFastDomNode(document.createElement('div'));
        PartFingerprints.write(_this.overflowingContentWidgetsDomNode, 2 /* OverflowingContentWidgets */);
        _this.overflowingContentWidgetsDomNode.setClassName('overflowingContentWidgets');
        return _this;
    }
    ViewContentWidgets.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this._widgets = {};
    };
    // --- begin event handlers
    ViewContentWidgets.prototype.onConfigurationChanged = function (e) {
        var e_1, _a;
        var keys = Object.keys(this._widgets);
        try {
            for (var keys_1 = __values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var widgetId = keys_1_1.value;
                this._widgets[widgetId].onConfigurationChanged(e);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return)) _a.call(keys_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return true;
    };
    ViewContentWidgets.prototype.onDecorationsChanged = function (e) {
        // true for inline decorations that can end up relayouting text
        return true;
    };
    ViewContentWidgets.prototype.onFlushed = function (e) {
        return true;
    };
    ViewContentWidgets.prototype.onLineMappingChanged = function (e) {
        var e_2, _a;
        var keys = Object.keys(this._widgets);
        try {
            for (var keys_2 = __values(keys), keys_2_1 = keys_2.next(); !keys_2_1.done; keys_2_1 = keys_2.next()) {
                var widgetId = keys_2_1.value;
                this._widgets[widgetId].onLineMappingChanged(e);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (keys_2_1 && !keys_2_1.done && (_a = keys_2.return)) _a.call(keys_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return true;
    };
    ViewContentWidgets.prototype.onLinesChanged = function (e) {
        return true;
    };
    ViewContentWidgets.prototype.onLinesDeleted = function (e) {
        return true;
    };
    ViewContentWidgets.prototype.onLinesInserted = function (e) {
        return true;
    };
    ViewContentWidgets.prototype.onScrollChanged = function (e) {
        return true;
    };
    ViewContentWidgets.prototype.onZonesChanged = function (e) {
        return true;
    };
    // ---- end view event handlers
    ViewContentWidgets.prototype.addWidget = function (_widget) {
        var myWidget = new Widget(this._context, this._viewDomNode, _widget);
        this._widgets[myWidget.id] = myWidget;
        if (myWidget.allowEditorOverflow) {
            this.overflowingContentWidgetsDomNode.appendChild(myWidget.domNode);
        }
        else {
            this.domNode.appendChild(myWidget.domNode);
        }
        this.setShouldRender();
    };
    ViewContentWidgets.prototype.setWidgetPosition = function (widget, range, preference) {
        var myWidget = this._widgets[widget.getId()];
        myWidget.setPosition(range, preference);
        this.setShouldRender();
    };
    ViewContentWidgets.prototype.removeWidget = function (widget) {
        var widgetId = widget.getId();
        if (this._widgets.hasOwnProperty(widgetId)) {
            var myWidget = this._widgets[widgetId];
            delete this._widgets[widgetId];
            var domNode = myWidget.domNode.domNode;
            domNode.parentNode.removeChild(domNode);
            domNode.removeAttribute('monaco-visible-content-widget');
            this.setShouldRender();
        }
    };
    ViewContentWidgets.prototype.shouldSuppressMouseDownOnWidget = function (widgetId) {
        if (this._widgets.hasOwnProperty(widgetId)) {
            return this._widgets[widgetId].suppressMouseDown;
        }
        return false;
    };
    ViewContentWidgets.prototype.onBeforeRender = function (viewportData) {
        var e_3, _a;
        var keys = Object.keys(this._widgets);
        try {
            for (var keys_3 = __values(keys), keys_3_1 = keys_3.next(); !keys_3_1.done; keys_3_1 = keys_3.next()) {
                var widgetId = keys_3_1.value;
                this._widgets[widgetId].onBeforeRender(viewportData);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (keys_3_1 && !keys_3_1.done && (_a = keys_3.return)) _a.call(keys_3);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    ViewContentWidgets.prototype.prepareRender = function (ctx) {
        var e_4, _a;
        var keys = Object.keys(this._widgets);
        try {
            for (var keys_4 = __values(keys), keys_4_1 = keys_4.next(); !keys_4_1.done; keys_4_1 = keys_4.next()) {
                var widgetId = keys_4_1.value;
                this._widgets[widgetId].prepareRender(ctx);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (keys_4_1 && !keys_4_1.done && (_a = keys_4.return)) _a.call(keys_4);
            }
            finally { if (e_4) throw e_4.error; }
        }
    };
    ViewContentWidgets.prototype.render = function (ctx) {
        var e_5, _a;
        var keys = Object.keys(this._widgets);
        try {
            for (var keys_5 = __values(keys), keys_5_1 = keys_5.next(); !keys_5_1.done; keys_5_1 = keys_5.next()) {
                var widgetId = keys_5_1.value;
                this._widgets[widgetId].render(ctx);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (keys_5_1 && !keys_5_1.done && (_a = keys_5.return)) _a.call(keys_5);
            }
            finally { if (e_5) throw e_5.error; }
        }
    };
    return ViewContentWidgets;
}(ViewPart));
export { ViewContentWidgets };
var Widget = /** @class */ (function () {
    function Widget(context, viewDomNode, actual) {
        this._context = context;
        this._viewDomNode = viewDomNode;
        this._actual = actual;
        this.domNode = createFastDomNode(this._actual.getDomNode());
        this.id = this._actual.getId();
        this.allowEditorOverflow = this._actual.allowEditorOverflow || false;
        this.suppressMouseDown = this._actual.suppressMouseDown || false;
        var options = this._context.configuration.options;
        var layoutInfo = options.get(124 /* layoutInfo */);
        this._fixedOverflowWidgets = options.get(32 /* fixedOverflowWidgets */);
        this._contentWidth = layoutInfo.contentWidth;
        this._contentLeft = layoutInfo.contentLeft;
        this._lineHeight = options.get(53 /* lineHeight */);
        this._range = null;
        this._viewRange = null;
        this._preference = [];
        this._cachedDomNodeClientWidth = -1;
        this._cachedDomNodeClientHeight = -1;
        this._maxWidth = this._getMaxWidth();
        this._isVisible = false;
        this._renderData = null;
        this.domNode.setPosition((this._fixedOverflowWidgets && this.allowEditorOverflow) ? 'fixed' : 'absolute');
        this.domNode.setVisibility('hidden');
        this.domNode.setAttribute('widgetId', this.id);
        this.domNode.setMaxWidth(this._maxWidth);
    }
    Widget.prototype.onConfigurationChanged = function (e) {
        var options = this._context.configuration.options;
        this._lineHeight = options.get(53 /* lineHeight */);
        if (e.hasChanged(124 /* layoutInfo */)) {
            var layoutInfo = options.get(124 /* layoutInfo */);
            this._contentLeft = layoutInfo.contentLeft;
            this._contentWidth = layoutInfo.contentWidth;
            this._maxWidth = this._getMaxWidth();
        }
    };
    Widget.prototype.onLineMappingChanged = function (e) {
        this._setPosition(this._range);
    };
    Widget.prototype._setPosition = function (range) {
        this._range = range;
        this._viewRange = null;
        if (this._range) {
            // Do not trust that widgets give a valid position
            var validModelRange = this._context.model.validateModelRange(this._range);
            if (this._context.model.coordinatesConverter.modelPositionIsVisible(validModelRange.getStartPosition()) || this._context.model.coordinatesConverter.modelPositionIsVisible(validModelRange.getEndPosition())) {
                this._viewRange = this._context.model.coordinatesConverter.convertModelRangeToViewRange(validModelRange);
            }
        }
    };
    Widget.prototype._getMaxWidth = function () {
        return (this.allowEditorOverflow
            ? window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth
            : this._contentWidth);
    };
    Widget.prototype.setPosition = function (range, preference) {
        this._setPosition(range);
        this._preference = preference;
        this._cachedDomNodeClientWidth = -1;
        this._cachedDomNodeClientHeight = -1;
    };
    Widget.prototype._layoutBoxInViewport = function (topLeft, bottomLeft, width, height, ctx) {
        // Our visible box is split horizontally by the current line => 2 boxes
        // a) the box above the line
        var aboveLineTop = topLeft.top;
        var heightAboveLine = aboveLineTop;
        // b) the box under the line
        var underLineTop = bottomLeft.top + this._lineHeight;
        var heightUnderLine = ctx.viewportHeight - underLineTop;
        var aboveTop = aboveLineTop - height;
        var fitsAbove = (heightAboveLine >= height);
        var belowTop = underLineTop;
        var fitsBelow = (heightUnderLine >= height);
        // And its left
        var actualAboveLeft = topLeft.left;
        var actualBelowLeft = bottomLeft.left;
        if (actualAboveLeft + width > ctx.scrollLeft + ctx.viewportWidth) {
            actualAboveLeft = ctx.scrollLeft + ctx.viewportWidth - width;
        }
        if (actualBelowLeft + width > ctx.scrollLeft + ctx.viewportWidth) {
            actualBelowLeft = ctx.scrollLeft + ctx.viewportWidth - width;
        }
        if (actualAboveLeft < ctx.scrollLeft) {
            actualAboveLeft = ctx.scrollLeft;
        }
        if (actualBelowLeft < ctx.scrollLeft) {
            actualBelowLeft = ctx.scrollLeft;
        }
        return {
            fitsAbove: fitsAbove,
            aboveTop: aboveTop,
            aboveLeft: actualAboveLeft,
            fitsBelow: fitsBelow,
            belowTop: belowTop,
            belowLeft: actualBelowLeft,
        };
    };
    Widget.prototype._layoutHorizontalSegmentInPage = function (windowSize, domNodePosition, left, width) {
        // Initially, the limits are defined as the dom node limits
        var MIN_LIMIT = Math.max(0, domNodePosition.left - width);
        var MAX_LIMIT = Math.min(domNodePosition.left + domNodePosition.width + width, windowSize.width);
        var absoluteLeft = domNodePosition.left + left - dom.StandardWindow.scrollX;
        if (absoluteLeft + width > MAX_LIMIT) {
            var delta = absoluteLeft - (MAX_LIMIT - width);
            absoluteLeft -= delta;
            left -= delta;
        }
        if (absoluteLeft < MIN_LIMIT) {
            var delta = absoluteLeft - MIN_LIMIT;
            absoluteLeft -= delta;
            left -= delta;
        }
        return [left, absoluteLeft];
    };
    Widget.prototype._layoutBoxInPage = function (topLeft, bottomLeft, width, height, ctx) {
        var aboveTop = topLeft.top - height;
        var belowTop = bottomLeft.top + this._lineHeight;
        var domNodePosition = dom.getDomNodePagePosition(this._viewDomNode.domNode);
        var absoluteAboveTop = domNodePosition.top + aboveTop - dom.StandardWindow.scrollY;
        var absoluteBelowTop = domNodePosition.top + belowTop - dom.StandardWindow.scrollY;
        var windowSize = dom.getClientArea(document.body);
        var _a = __read(this._layoutHorizontalSegmentInPage(windowSize, domNodePosition, topLeft.left - ctx.scrollLeft + this._contentLeft, width), 2), aboveLeft = _a[0], absoluteAboveLeft = _a[1];
        var _b = __read(this._layoutHorizontalSegmentInPage(windowSize, domNodePosition, bottomLeft.left - ctx.scrollLeft + this._contentLeft, width), 2), belowLeft = _b[0], absoluteBelowLeft = _b[1];
        // Leave some clearance to the top/bottom
        var TOP_PADDING = 22;
        var BOTTOM_PADDING = 22;
        var fitsAbove = (absoluteAboveTop >= TOP_PADDING);
        var fitsBelow = (absoluteBelowTop + height <= windowSize.height - BOTTOM_PADDING);
        if (this._fixedOverflowWidgets) {
            return {
                fitsAbove: fitsAbove,
                aboveTop: Math.max(absoluteAboveTop, TOP_PADDING),
                aboveLeft: absoluteAboveLeft,
                fitsBelow: fitsBelow,
                belowTop: absoluteBelowTop,
                belowLeft: absoluteBelowLeft
            };
        }
        return {
            fitsAbove: fitsAbove,
            aboveTop: aboveTop,
            aboveLeft: aboveLeft,
            fitsBelow: fitsBelow,
            belowTop: belowTop,
            belowLeft: belowLeft
        };
    };
    Widget.prototype._prepareRenderWidgetAtExactPositionOverflowing = function (topLeft) {
        return new Coordinate(topLeft.top, topLeft.left + this._contentLeft);
    };
    /**
     * Compute `this._topLeft`
     */
    Widget.prototype._getTopAndBottomLeft = function (ctx) {
        var e_6, _a, e_7, _b, e_8, _c;
        if (!this._viewRange) {
            return [null, null];
        }
        var visibleRangesForRange = ctx.linesVisibleRangesForRange(this._viewRange, false);
        if (!visibleRangesForRange || visibleRangesForRange.length === 0) {
            return [null, null];
        }
        var firstLine = visibleRangesForRange[0];
        var lastLine = visibleRangesForRange[0];
        try {
            for (var visibleRangesForRange_1 = __values(visibleRangesForRange), visibleRangesForRange_1_1 = visibleRangesForRange_1.next(); !visibleRangesForRange_1_1.done; visibleRangesForRange_1_1 = visibleRangesForRange_1.next()) {
                var visibleRangesForLine = visibleRangesForRange_1_1.value;
                if (visibleRangesForLine.lineNumber < firstLine.lineNumber) {
                    firstLine = visibleRangesForLine;
                }
                if (visibleRangesForLine.lineNumber > lastLine.lineNumber) {
                    lastLine = visibleRangesForLine;
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (visibleRangesForRange_1_1 && !visibleRangesForRange_1_1.done && (_a = visibleRangesForRange_1.return)) _a.call(visibleRangesForRange_1);
            }
            finally { if (e_6) throw e_6.error; }
        }
        var firstLineMinLeft = 1073741824 /* MAX_SAFE_SMALL_INTEGER */; //firstLine.Constants.MAX_SAFE_SMALL_INTEGER;
        try {
            for (var _d = __values(firstLine.ranges), _e = _d.next(); !_e.done; _e = _d.next()) {
                var visibleRange = _e.value;
                if (visibleRange.left < firstLineMinLeft) {
                    firstLineMinLeft = visibleRange.left;
                }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
            }
            finally { if (e_7) throw e_7.error; }
        }
        var lastLineMinLeft = 1073741824 /* MAX_SAFE_SMALL_INTEGER */; //lastLine.Constants.MAX_SAFE_SMALL_INTEGER;
        try {
            for (var _f = __values(lastLine.ranges), _g = _f.next(); !_g.done; _g = _f.next()) {
                var visibleRange = _g.value;
                if (visibleRange.left < lastLineMinLeft) {
                    lastLineMinLeft = visibleRange.left;
                }
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
            }
            finally { if (e_8) throw e_8.error; }
        }
        var topForPosition = ctx.getVerticalOffsetForLineNumber(firstLine.lineNumber) - ctx.scrollTop;
        var topLeft = new Coordinate(topForPosition, firstLineMinLeft);
        var topForBottomLine = ctx.getVerticalOffsetForLineNumber(lastLine.lineNumber) - ctx.scrollTop;
        var bottomLeft = new Coordinate(topForBottomLine, lastLineMinLeft);
        return [topLeft, bottomLeft];
    };
    Widget.prototype._prepareRenderWidget = function (ctx) {
        var e_9, _a;
        var _b = __read(this._getTopAndBottomLeft(ctx), 2), topLeft = _b[0], bottomLeft = _b[1];
        if (!topLeft || !bottomLeft) {
            return null;
        }
        if (this._cachedDomNodeClientWidth === -1 || this._cachedDomNodeClientHeight === -1) {
            var preferredDimensions = null;
            if (typeof this._actual.beforeRender === 'function') {
                preferredDimensions = safeInvoke(this._actual.beforeRender, this._actual);
            }
            if (preferredDimensions) {
                this._cachedDomNodeClientWidth = preferredDimensions.width;
                this._cachedDomNodeClientHeight = preferredDimensions.height;
            }
            else {
                var domNode = this.domNode.domNode;
                this._cachedDomNodeClientWidth = domNode.clientWidth;
                this._cachedDomNodeClientHeight = domNode.clientHeight;
            }
        }
        var placement;
        if (this.allowEditorOverflow) {
            placement = this._layoutBoxInPage(topLeft, bottomLeft, this._cachedDomNodeClientWidth, this._cachedDomNodeClientHeight, ctx);
        }
        else {
            placement = this._layoutBoxInViewport(topLeft, bottomLeft, this._cachedDomNodeClientWidth, this._cachedDomNodeClientHeight, ctx);
        }
        // Do two passes, first for perfect fit, second picks first option
        if (this._preference) {
            for (var pass = 1; pass <= 2; pass++) {
                try {
                    for (var _c = (e_9 = void 0, __values(this._preference)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var pref = _d.value;
                        // placement
                        if (pref === 1 /* ABOVE */) {
                            if (!placement) {
                                // Widget outside of viewport
                                return null;
                            }
                            if (pass === 2 || placement.fitsAbove) {
                                return { coordinate: new Coordinate(placement.aboveTop, placement.aboveLeft), position: 1 /* ABOVE */ };
                            }
                        }
                        else if (pref === 2 /* BELOW */) {
                            if (!placement) {
                                // Widget outside of viewport
                                return null;
                            }
                            if (pass === 2 || placement.fitsBelow) {
                                return { coordinate: new Coordinate(placement.belowTop, placement.belowLeft), position: 2 /* BELOW */ };
                            }
                        }
                        else {
                            if (this.allowEditorOverflow) {
                                return { coordinate: this._prepareRenderWidgetAtExactPositionOverflowing(topLeft), position: 0 /* EXACT */ };
                            }
                            else {
                                return { coordinate: topLeft, position: 0 /* EXACT */ };
                            }
                        }
                    }
                }
                catch (e_9_1) { e_9 = { error: e_9_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                    }
                    finally { if (e_9) throw e_9.error; }
                }
            }
        }
        return null;
    };
    /**
     * On this first pass, we ensure that the content widget (if it is in the viewport) has the max width set correctly.
     */
    Widget.prototype.onBeforeRender = function (viewportData) {
        if (!this._viewRange || !this._preference) {
            return;
        }
        if (this._viewRange.endLineNumber < viewportData.startLineNumber || this._viewRange.startLineNumber > viewportData.endLineNumber) {
            // Outside of viewport
            return;
        }
        this.domNode.setMaxWidth(this._maxWidth);
    };
    Widget.prototype.prepareRender = function (ctx) {
        this._renderData = this._prepareRenderWidget(ctx);
    };
    Widget.prototype.render = function (ctx) {
        if (!this._renderData) {
            // This widget should be invisible
            if (this._isVisible) {
                this.domNode.removeAttribute('monaco-visible-content-widget');
                this._isVisible = false;
                this.domNode.setVisibility('hidden');
            }
            if (typeof this._actual.afterRender === 'function') {
                safeInvoke(this._actual.afterRender, this._actual, null);
            }
            return;
        }
        // This widget should be visible
        if (this.allowEditorOverflow) {
            this.domNode.setTop(this._renderData.coordinate.top);
            this.domNode.setLeft(this._renderData.coordinate.left);
        }
        else {
            this.domNode.setTop(this._renderData.coordinate.top + ctx.scrollTop - ctx.bigNumbersDelta);
            this.domNode.setLeft(this._renderData.coordinate.left);
        }
        if (!this._isVisible) {
            this.domNode.setVisibility('inherit');
            this.domNode.setAttribute('monaco-visible-content-widget', 'true');
            this._isVisible = true;
        }
        if (typeof this._actual.afterRender === 'function') {
            safeInvoke(this._actual.afterRender, this._actual, this._renderData.position);
        }
    };
    return Widget;
}());
function safeInvoke(fn, thisArg) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    try {
        return fn.call.apply(fn, __spreadArray([thisArg], __read(args)));
    }
    catch (_a) {
        // ignore
        return null;
    }
}
