"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitQuickOpenPrompt = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const PQueue = require("p-queue");
const git_prompt_1 = require("../../common/git-prompt");
let GitQuickOpenPrompt = class GitQuickOpenPrompt extends git_prompt_1.GitPrompt {
    constructor() {
        super(...arguments);
        this.queue = new PQueue({ autoStart: true, concurrency: 1 });
    }
    async ask(question) {
        return this.queue.add(() => {
            const { details, text, password } = question;
            return new Promise(async (resolve) => {
                var _a;
                const result = await ((_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.input({
                    placeHolder: text,
                    prompt: details,
                    password,
                }));
                resolve(git_prompt_1.GitPrompt.Success.create(result));
            });
        });
    }
    dispose() {
        if (!this.queue.isPaused) {
            this.queue.pause();
        }
        this.queue.clear();
    }
};
__decorate([
    inversify_1.inject(browser_1.QuickInputService),
    inversify_1.optional(),
    __metadata("design:type", Object)
], GitQuickOpenPrompt.prototype, "quickInputService", void 0);
GitQuickOpenPrompt = __decorate([
    inversify_1.injectable()
], GitQuickOpenPrompt);
exports.GitQuickOpenPrompt = GitQuickOpenPrompt;
//# sourceMappingURL=git-quick-open-prompt.js.map