"use strict";
/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitDecorationProvider = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const common_1 = require("../common");
const common_2 = require("@theia/core/lib/common");
const git_repository_tracker_1 = require("./git-repository-tracker");
const uri_1 = require("@theia/core/lib/common/uri");
let GitDecorationProvider = class GitDecorationProvider {
    constructor(gitRepositoryTracker) {
        this.gitRepositoryTracker = gitRepositoryTracker;
        this.onDidChangeDecorationsEmitter = new common_2.Emitter();
        this.onDidChange = this.onDidChangeDecorationsEmitter.event;
        this.decorations = new Map();
        this.gitRepositoryTracker.onGitEvent((event) => {
            this.onGitEvent(event);
        });
    }
    async onGitEvent(event) {
        if (!event) {
            return;
        }
        const newDecorations = new Map();
        this.collectDecorationData(event.status.changes, newDecorations);
        const uris = new Set([...this.decorations.keys()].concat([...newDecorations.keys()]));
        this.decorations = newDecorations;
        this.onDidChangeDecorationsEmitter.fire([...uris.values()].map(value => new uri_1.default(value)));
    }
    collectDecorationData(changes, bucket) {
        changes.forEach(change => {
            const color = common_1.GitFileStatus.getColor(change.status, change.staged);
            bucket.set(change.uri, {
                colorId: color.substring(12, color.length - 1).replace(/-/g, '.'),
                tooltip: common_1.GitFileStatus.toString(change.status),
                letter: common_1.GitFileStatus.toAbbreviation(change.status, change.staged)
            });
        });
    }
    provideDecorations(uri, token) {
        return this.decorations.get(uri.toString());
    }
};
GitDecorationProvider = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(git_repository_tracker_1.GitRepositoryTracker)),
    __metadata("design:paramtypes", [git_repository_tracker_1.GitRepositoryTracker])
], GitDecorationProvider);
exports.GitDecorationProvider = GitDecorationProvider;
//# sourceMappingURL=git-decoration-provider.js.map