/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.gradle;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.CoreTraceScopes;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.core.internal.console.ProcessStreams;
import org.eclipse.buildship.core.internal.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.internal.util.progress.CancellationForwardingListener;
import org.eclipse.buildship.core.internal.util.progress.DelegatingProgressListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProgressListener;

public final class GradleProgressAttributes {
    private final ProcessStreams streams;
    private final CancellationToken cancellationToken;
    private final ImmutableList<ProgressListener> progressListeners;
    private final ImmutableList<org.gradle.tooling.events.ProgressListener> progressEventListeners;
    private final boolean isInteractive;

    private GradleProgressAttributes(ProcessStreams streams, CancellationToken cancellationToken, List<ProgressListener> progressListeners, List<org.gradle.tooling.events.ProgressListener> progressEventListeners, boolean isInteractive) {
        this.streams = (ProcessStreams)Preconditions.checkNotNull((Object)streams);
        this.cancellationToken = (CancellationToken)Preconditions.checkNotNull((Object)cancellationToken);
        this.progressListeners = ImmutableList.copyOf(progressListeners);
        this.progressEventListeners = ImmutableList.copyOf(progressEventListeners);
        this.isInteractive = isInteractive;
    }

    public void applyTo(LongRunningOperation operation) {
        operation.setStandardOutput(this.streams.getOutput());
        operation.setStandardError(this.streams.getError());
        if (this.isInteractive) {
            operation.setStandardInput(this.streams.getInput());
        }
        for (ProgressListener listener : this.progressListeners) {
            operation.addProgressListener(listener);
        }
        for (ProgressListener listener : this.progressEventListeners) {
            operation.addProgressListener((org.gradle.tooling.events.ProgressListener)listener);
        }
        operation.withCancellationToken(this.cancellationToken);
    }

    public void writeConfig(String line) {
        try {
            OutputStream configStream = this.streams.getConfiguration();
            configStream.write(line.getBytes());
            configStream.write(StandardSystemProperty.LINE_SEPARATOR.value().getBytes());
        }
        catch (IOException e) {
            CorePlugin.logger().trace(CoreTraceScopes.PREFERENCES, String.format("Failed to write configuration %s to stream", line), e);
        }
    }

    public void close() {
        this.streams.close();
    }

    public static final GradleProgressAttributesBuilder builder(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        return new GradleProgressAttributesBuilder(tokenSource, monitor);
    }

    public static class GradleProgressAttributesBuilder {
        private final CancellationTokenSource tokenSource;
        private final IProgressMonitor monitor;
        private ProcessDescription processDescription = null;
        private boolean isInteractive = true;
        private ProgressListener delegatingListener = null;

        public GradleProgressAttributesBuilder(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
            this.tokenSource = tokenSource;
            this.monitor = monitor;
        }

        public GradleProgressAttributesBuilder forBackgroundProcess() {
            this.processDescription = null;
            return this;
        }

        public GradleProgressAttributesBuilder forNonInteractiveBackgroundProcess() {
            this.processDescription = null;
            this.isInteractive = false;
            return this;
        }

        public GradleProgressAttributesBuilder forDedicatedProcess(ProcessDescription processDescription) {
            this.processDescription = processDescription;
            return this;
        }

        public GradleProgressAttributesBuilder withFullProgress() {
            this.delegatingListener = DelegatingProgressListener.withFullOutput(this.monitor);
            return this;
        }

        public GradleProgressAttributesBuilder withFilteredProgress() {
            this.delegatingListener = DelegatingProgressListener.withoutDuplicateLifecycleEvents(this.monitor);
            return this;
        }

        public GradleProgressAttributes build() {
            ProcessStreamsProvider streamsProvider = CorePlugin.processStreamsProvider();
            ProcessStreams streams = this.processDescription == null ? streamsProvider.getBackgroundJobProcessStreams() : streamsProvider.createProcessStreams(this.processDescription);
            ImmutableList.Builder progressListeners = ImmutableList.builder();
            ImmutableList.Builder progressEventListeners = ImmutableList.builder();
            progressListeners.add((Object)this.delegatingListener);
            CancellationForwardingListener cancellationListener = new CancellationForwardingListener(this.monitor, this.tokenSource);
            progressListeners.add((Object)cancellationListener);
            progressEventListeners.add((Object)cancellationListener);
            return new GradleProgressAttributes(streams, this.tokenSource.token(), (List)progressListeners.build(), (List)progressEventListeners.build(), this.isInteractive);
        }
    }
}

