/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphItem;

class ItemData {
    public TimeGraphItem[] _expandedItems = new TimeGraphItem[0];
    public TimeGraphItem[] _items = new TimeGraphItem[0];
    private ITimeGraphEntry[] _traces = new ITimeGraphEntry[0];
    private boolean[] traceFilter = new boolean[0];
    private Vector<ITimeGraphEntry> filteredOut = new Vector();
    public ITimeGraphPresentationProvider provider;

    TimeGraphItem findItem(ITimeGraphEntry entry) {
        if (entry == null) {
            return null;
        }
        int i = 0;
        while (i < this._items.length) {
            TimeGraphItem item = this._items[i];
            if (item._trace == entry) {
                return item;
            }
            ++i;
        }
        return null;
    }

    int findItemIndex(ITimeGraphEntry trace) {
        if (trace == null) {
            return -1;
        }
        int i = 0;
        while (i < this._expandedItems.length) {
            TimeGraphItem item = this._expandedItems[i];
            if (item._trace == trace) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void refreshData() {
        ArrayList<TimeGraphItem> itemList = new ArrayList<TimeGraphItem>();
        this.filteredOut.clear();
        int i = 0;
        while (i < this._traces.length) {
            ITimeGraphEntry entry = this._traces[i];
            this.refreshData(itemList, null, 0, entry);
            ++i;
        }
        this._items = itemList.toArray(new TimeGraphItem[0]);
        this.updateExpandedItems();
    }

    private void refreshData(List<TimeGraphItem> itemList, TimeGraphItem parent, int level, ITimeGraphEntry entry) {
        TimeGraphItem item = new TimeGraphItem(entry, entry.getName(), level);
        if (parent != null) {
            parent.children.add(item);
        }
        item.itemHeight = this.provider.getItemHeight(entry);
        itemList.add(item);
        if (entry.hasChildren()) {
            item._expanded = true;
            item._hasChildren = true;
            ITimeGraphEntry[] iTimeGraphEntryArray = entry.getChildren();
            int n = iTimeGraphEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITimeGraphEntry child = iTimeGraphEntryArray[n2];
                this.refreshData(itemList, item, level + 1, child);
                ++n2;
            }
        }
    }

    public void updateExpandedItems() {
        ArrayList<TimeGraphItem> expandedItemList = new ArrayList<TimeGraphItem>();
        int i = 0;
        while (i < this._traces.length) {
            ITimeGraphEntry entry = this._traces[i];
            TimeGraphItem item = this.findItem(entry);
            this.refreshExpanded(expandedItemList, item);
            ++i;
        }
        this._expandedItems = expandedItemList.toArray(new TimeGraphItem[0]);
    }

    private void refreshExpanded(List<TimeGraphItem> expandedItemList, TimeGraphItem item) {
        expandedItemList.add(item);
        if (item._hasChildren && item._expanded) {
            for (TimeGraphItem child : item.children) {
                this.refreshExpanded(expandedItemList, child);
            }
        }
    }

    public void expandItem(int idx) {
        if (idx < 0 || idx >= this._expandedItems.length) {
            return;
        }
        TimeGraphItem item = this._expandedItems[idx];
        if (item._hasChildren && !item._expanded) {
            item._expanded = true;
            this.updateExpandedItems();
        }
    }

    public void refreshData(ITimeGraphEntry[] traces) {
        if (traces == null || traces.length == 0) {
            this.traceFilter = null;
        } else if (this.traceFilter == null || traces.length != this.traceFilter.length) {
            this.traceFilter = new boolean[traces.length];
            Arrays.fill(this.traceFilter, true);
        }
        this._traces = traces;
        this.refreshData();
    }

    public ITimeGraphEntry[] getTraces() {
        return this._traces;
    }

    public boolean[] getTraceFilter() {
        return this.traceFilter;
    }

    public Vector<ITimeGraphEntry> getFilteredOut() {
        return this.filteredOut;
    }
}

