/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.editors;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomEventsTable;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditor;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceParserUpdatedSignal;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class TmfEventsEditor
extends TmfEditor
implements ITmfTraceEditor,
IReusableEditor,
IPropertyListener,
IResourceChangeListener {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.editors.events";
    private TmfEventsTable fEventsTable;
    private IFile fFile;
    private ITmfTrace fTrace;
    private Composite fParent;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        block27: {
            if (input instanceof TmfEditorInput) {
                this.fFile = ((TmfEditorInput)input).getFile();
                this.fTrace = ((TmfEditorInput)input).getTrace();
                input = new FileEditorInput(this.fFile);
            } else if (input instanceof IFileEditorInput) {
                this.fFile = ((IFileEditorInput)input).getFile();
                if (this.fFile == null) {
                    throw new PartInitException("Invalid IFileEditorInput: " + input);
                }
                try {
                    String traceTypeId = this.fFile.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                    if (traceTypeId == null) {
                        throw new PartInitException(Messages.OpenTraceHandler_NoTraceType);
                    }
                    if (traceTypeId.equals(TmfExperiment.class.getCanonicalName())) {
                        TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
                        ncp.getChildren(this.fFile.getProject());
                        TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject());
                        if (project == null) {
                            throw new PartInitException(Messages.OpenExperimentHandler_NoTraceType);
                        }
                        for (ITmfProjectModelElement projectElement : project.getExperimentsFolder().getChildren()) {
                            String traceName = this.fFile.getParent().getName();
                            if (!projectElement.getName().equals(traceName)) continue;
                            TmfExperimentElement experimentElement = (TmfExperimentElement)projectElement;
                            List<TmfTraceElement> traceEntries = experimentElement.getTraces();
                            int nbTraces = traceEntries.size();
                            int cacheSize = Integer.MAX_VALUE;
                            ITmfTrace[] traces = new ITmfTrace[nbTraces];
                            int i = 0;
                            while (i < nbTraces) {
                                TmfTraceElement traceElement = traceEntries.get(i);
                                ITmfTrace<?> trace = traceElement.instantiateTrace();
                                ITmfEvent traceEvent = traceElement.instantiateEvent();
                                if (trace == null || traceEvent == null) {
                                    int j = 0;
                                    while (j < i) {
                                        traces[j].dispose();
                                        ++j;
                                    }
                                    throw new PartInitException(Messages.OpenExperimentHandler_NoTraceType);
                                }
                                try {
                                    trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                                }
                                catch (TmfTraceException tmfTraceException) {}
                                cacheSize = Math.min(cacheSize, trace.getCacheSize());
                                traces[i] = trace;
                                ++i;
                            }
                            TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, experimentElement.getName(), traces, cacheSize);
                            experiment.setBookmarksFile(this.fFile);
                            this.fTrace = experiment;
                            experiment.initTrace(null, null, null);
                            break block27;
                        }
                        break block27;
                    }
                    if (traceTypeId.equals(TmfTrace.class.getCanonicalName())) {
                        TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
                        ncp.getChildren(this.fFile.getProject());
                        TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject());
                        for (ITmfProjectModelElement projectElement : project.getTracesFolder().getChildren()) {
                            String traceName = this.fFile.getParent().getName();
                            if (!projectElement.getName().equals(traceName)) continue;
                            TmfTraceElement traceElement = (TmfTraceElement)projectElement;
                            ITmfTrace<?> trace = traceElement.instantiateTrace();
                            ITmfEvent traceEvent = traceElement.instantiateEvent();
                            if (trace == null || traceEvent == null) {
                                throw new PartInitException(Messages.OpenTraceHandler_NoTraceType);
                            }
                            try {
                                trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                            }
                            catch (TmfTraceException tmfTraceException) {}
                            this.fTrace = trace;
                            break block27;
                        }
                        break block27;
                    }
                    TmfNavigatorContentProvider ncp = new TmfNavigatorContentProvider();
                    ncp.getChildren(this.fFile.getProject());
                    TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject());
                    for (ITmfProjectModelElement projectElement : project.getTracesFolder().getChildren()) {
                        if (!projectElement.getResource().equals((Object)this.fFile)) continue;
                        TmfTraceElement traceElement = (TmfTraceElement)projectElement;
                        ITmfTrace<?> trace = traceElement.instantiateTrace();
                        ITmfEvent traceEvent = traceElement.instantiateEvent();
                        if (trace == null || traceEvent == null) {
                            throw new PartInitException(Messages.OpenTraceHandler_NoTraceType);
                        }
                        try {
                            trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                        }
                        catch (TmfTraceException tmfTraceException) {}
                        this.fTrace = trace;
                        break;
                    }
                }
                catch (InvalidRegistryObjectException e) {
                    Activator.getDefault().logError("Error initializing TmfEventsEditor", e);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error initializing TmfEventsEditor", e);
                }
            } else {
                throw new PartInitException("Invalid IEditorInput: " + input.getClass());
            }
        }
        if (this.fTrace == null) {
            throw new PartInitException("Invalid IEditorInput: " + this.fFile.getName());
        }
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.firePropertyChange(258);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.broadcast(new TmfTraceClosedSignal(this, this.fTrace));
            this.fFile = ((TmfEditorInput)this.getEditorInput()).getFile();
            this.fTrace = ((TmfEditorInput)this.getEditorInput()).getTrace();
            super.setInput((IEditorInput)new FileEditorInput(this.fFile));
            this.fEventsTable.dispose();
            if (this.fTrace != null) {
                this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
                this.fEventsTable.setTrace(this.fTrace, true);
                this.fEventsTable.refreshBookmarks(this.fFile);
                this.broadcast(new TmfTraceOpenedSignal(this, this.fTrace, this.fFile, this.fEventsTable));
            } else {
                this.fEventsTable = new TmfEventsTable(this.fParent, 0);
            }
            this.fParent.layout();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        if (this.fTrace != null) {
            this.setPartName(this.fTrace.getName());
            this.fEventsTable = this.createEventsTable(parent, this.fTrace.getCacheSize());
            this.fEventsTable.setTrace(this.fTrace, true);
            this.fEventsTable.refreshBookmarks(this.fFile);
            this.broadcast(new TmfTraceOpenedSignal(this, this.fTrace, this.fFile, this.fEventsTable));
        } else {
            this.setPartName(this.getEditorInput().getName());
            this.fEventsTable = new TmfEventsTable(parent, 0);
        }
        this.addPropertyListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.removePropertyListener(this);
        if (this.fTrace != null) {
            this.broadcast(new TmfTraceClosedSignal(this, this.fTrace));
        }
        if (this.fEventsTable != null) {
            this.fEventsTable.dispose();
        }
        super.dispose();
    }

    protected TmfEventsTable createEventsTable(Composite parent, int cacheSize) {
        TmfEventsTable eventsTable = this.getEventsTable(parent, cacheSize);
        if (eventsTable == null) {
            eventsTable = new TmfEventsTable(parent, cacheSize);
        }
        return eventsTable;
    }

    private TmfEventsTable getEventsTable(Composite parent, int cacheSize) {
        String traceType;
        TmfEventsTable eventsTable;
        block19: {
            block18: {
                if (this.fTrace instanceof TmfExperiment) {
                    return this.getExperimentEventsTable((TmfExperiment)this.fTrace, parent, cacheSize);
                }
                eventsTable = null;
                if (this.fTrace.getResource() != null) break block18;
                return null;
            }
            traceType = this.fTrace.getResource().getPersistentProperty(TmfCommonConstants.TRACETYPE);
            if (traceType != null) break block19;
            return null;
        }
        try {
            if (traceType.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                return new CustomEventsTable(((CustomTxtTrace)this.fTrace).getDefinition(), parent, cacheSize);
            }
            if (traceType.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                return new CustomEventsTable(((CustomXmlTrace)this.fTrace).getDefinition(), parent, cacheSize);
            }
            IConfigurationElement[] iConfigurationElementArray = TmfTraceType.getTypeElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (ce.getAttribute("id").equals(traceType)) {
                    String eventsTableType;
                    IConfigurationElement[] eventsTableTypeCE = ce.getChildren("eventsTableType");
                    if (eventsTableTypeCE.length == 1 && (eventsTableType = eventsTableTypeCE[0].getAttribute("class")) != null && eventsTableType.length() != 0) {
                        Bundle bundle = Platform.getBundle((String)ce.getContributor().getName());
                        Class c = bundle.loadClass(eventsTableType);
                        Class[] constructorArgs = new Class[]{Composite.class, Integer.TYPE};
                        Constructor constructor = c.getConstructor(constructorArgs);
                        Object[] args = new Object[]{parent, cacheSize};
                        eventsTable = (TmfEventsTable)constructor.newInstance(args);
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (ClassNotFoundException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (SecurityException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (NoSuchMethodException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (IllegalArgumentException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (InstantiationException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (IllegalAccessException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable", e);
        }
        return eventsTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TmfEventsTable getExperimentEventsTable(TmfExperiment<?> experiment, Composite parent, int cacheSize) {
        TmfEventsTable eventsTable = null;
        String commonTraceType = null;
        try {
            ITmfTrace[] iTmfTraceArray = experiment.getTraces();
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (commonTraceType != null) break;
                    return null;
                }
                ITmfTrace trace = iTmfTraceArray[n2];
                IResource resource = trace.getResource();
                if (resource == null) {
                    return null;
                }
                String traceType = resource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (commonTraceType != null && !commonTraceType.equals(traceType)) {
                    return null;
                }
                commonTraceType = traceType;
                ++n2;
            }
            if (commonTraceType.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                return new CustomEventsTable(((CustomTxtTrace)experiment.getTraces()[0]).getDefinition(), parent, cacheSize);
            }
            if (commonTraceType.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                return new CustomEventsTable(((CustomXmlTrace)experiment.getTraces()[0]).getDefinition(), parent, cacheSize);
            }
            iTmfTraceArray = TmfTraceType.getTypeElements();
            n = iTmfTraceArray.length;
            n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return eventsTable;
                }
                ITmfTrace ce = iTmfTraceArray[n2];
                if (ce.getAttribute("id").equals(commonTraceType)) {
                    IConfigurationElement[] eventsTableTypeCE = ce.getChildren("eventsTableType");
                    if (eventsTableTypeCE.length != 1) {
                        return eventsTable;
                    }
                    String eventsTableType = eventsTableTypeCE[0].getAttribute("class");
                    if (eventsTableType == null) return eventsTable;
                    if (eventsTableType.length() == 0) {
                        return eventsTable;
                    }
                    Bundle bundle = Platform.getBundle((String)ce.getContributor().getName());
                    Class c = bundle.loadClass(eventsTableType);
                    Class[] constructorArgs = new Class[]{Composite.class, Integer.TYPE};
                    Constructor constructor = c.getConstructor(constructorArgs);
                    Object[] args = new Object[]{parent, cacheSize};
                    return (TmfEventsTable)constructor.newInstance(args);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (InvalidRegistryObjectException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (SecurityException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (IllegalArgumentException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (ClassNotFoundException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (NoSuchMethodException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (InstantiationException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (IllegalAccessException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
            return eventsTable;
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError("Error getting TmfEventsTable for experiment", e);
        }
        return eventsTable;
    }

    @Override
    public ITmfTrace<?> getTrace() {
        return this.fTrace;
    }

    @Override
    public IFile getBookmarksFile() {
        return this.fFile;
    }

    public void setFocus() {
        this.fEventsTable.setFocus();
        if (this.fTrace != null) {
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
        }
    }

    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            return this.fEventsTable;
        }
        return super.getAdapter(adapter);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fFile)) {
                if (delta.getKind() == 2) {
                    final IMarker bookmark = delta.getMarker();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfEventsEditor.this.fEventsTable.removeBookmark(bookmark);
                        }
                    });
                } else if (delta.getKind() == 4) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfEventsEditor.this.fEventsTable.getTable().refresh();
                        }
                    });
                }
            }
            ++n2;
        }
    }

    public void addBookmark() {
        this.fEventsTable.addBookmark(this.fFile);
    }

    @TmfSignalHandler
    public void traceParserUpdated(TmfTraceParserUpdatedSignal signal) {
        if (signal.getTraceResource().equals((Object)this.fFile)) {
            block9: {
                this.broadcast(new TmfTraceClosedSignal(this, this.fTrace));
                try {
                    this.fTrace.getName();
                    this.fTrace = null;
                    String traceTypeId = this.fFile.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                    if (traceTypeId == null) break block9;
                    IConfigurationElement[] iConfigurationElementArray = TmfTraceType.getTypeElements();
                    int n = iConfigurationElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement ce = iConfigurationElementArray[n2];
                        if (traceTypeId.equals(ce.getAttribute("id"))) {
                            this.fTrace = (ITmfTrace)ce.createExecutableExtension("trace_type");
                            TmfEvent event = (TmfEvent)ce.createExecutableExtension("event_type");
                            String path = this.fFile.getLocationURI().getPath();
                            this.fTrace.initTrace(null, path, event.getClass());
                            break;
                        }
                        ++n2;
                    }
                }
                catch (InvalidRegistryObjectException e) {
                    Activator.getDefault().logError("Error handling signal TmfTraceParserUpdatedSignal", e);
                }
                catch (TmfTraceException e) {
                    Activator.getDefault().logError("Error handling signal TmfTraceParserUpdatedSignal", e);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError("Error handling signal TmfTraceParserUpdatedSignal", e);
                }
            }
            this.fEventsTable.dispose();
            if (this.fTrace != null) {
                this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
                this.fEventsTable.setTrace(this.fTrace, true);
                this.broadcast(new TmfTraceOpenedSignal(this, this.fTrace, this.fFile, this.fEventsTable));
            } else {
                this.fEventsTable = new TmfEventsTable(this.fParent, 0);
            }
            this.fParent.layout();
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getSource() != this && signal.getTrace().equals(this.fTrace)) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)this);
        }
    }
}

