/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.Tracer;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.AttributeTree;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateSystem;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.TransientState;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateHistoryBackend;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

public class StateHistorySystem
extends StateSystem
implements IStateSystemBuilder {
    private final IStateHistoryBackend backend;

    public StateHistorySystem(IStateHistoryBackend backend, boolean newFile) throws IOException {
        this.backend = backend;
        this.transState = new TransientState(backend);
        if (newFile) {
            this.attributeTree = new AttributeTree(this);
        } else {
            this.attributeTree = new AttributeTree(this, backend.supplyAttributeTreeReader());
            this.transState.setInactive();
        }
    }

    @Override
    public long getStartTime() {
        return this.backend.getStartTime();
    }

    @Override
    public long getCurrentEndTime() {
        return this.backend.getEndTime();
    }

    @Override
    public void closeHistory(long endTime) throws TimeRangeException {
        long realEndTime = endTime;
        if (realEndTime < this.backend.getEndTime()) {
            realEndTime = this.backend.getEndTime();
        }
        this.transState.closeTransientState(realEndTime);
        this.backend.finishedBuilding(realEndTime);
        File attributeTreeFile = this.backend.supplyAttributeTreeWriterFile();
        long attributeTreeFilePos = this.backend.supplyAttributeTreeWriterFilePosition();
        if (attributeTreeFile != null) {
            this.attributeTree.writeSelf(attributeTreeFile, attributeTreeFilePos);
        }
    }

    @Override
    public synchronized List<ITmfStateInterval> queryFullState(long t) throws TimeRangeException {
        ArrayList<ITmfStateInterval> stateInfo = new ArrayList<ITmfStateInterval>(this.attributeTree.getNbAttributes());
        int i = 0;
        while (i < this.attributeTree.getNbAttributes()) {
            stateInfo.add(null);
            ++i;
        }
        this.backend.doQuery(stateInfo, t);
        if (this.transState.isActive()) {
            this.transState.doQuery(stateInfo, t);
        }
        i = 0;
        while (i < stateInfo.size()) {
            if (stateInfo.get(i) == null) {
                StateHistorySystem.logMissingInterval(i, t);
                stateInfo.set(i, new TmfStateInterval(t, t, i, TmfStateValue.nullValue()));
            }
            ++i;
        }
        return stateInfo;
    }

    @Override
    public ITmfStateInterval querySingleState(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException {
        ITmfStateInterval ret = this.transState.hasInfoAboutStateOf(t, attributeQuark) ? this.transState.getOngoingInterval(attributeQuark) : this.backend.doSingularQuery(t, attributeQuark);
        if (ret == null) {
            StateHistorySystem.logMissingInterval(attributeQuark, t);
            return new TmfStateInterval(t, this.getCurrentEndTime(), attributeQuark, TmfStateValue.nullValue());
        }
        return ret;
    }

    @Override
    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2) throws TimeRangeException, AttributeNotFoundException {
        if (t2 <= t1) {
            throw new TimeRangeException();
        }
        long tEnd = t2 > this.getCurrentEndTime() ? this.getCurrentEndTime() : t2;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = this.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = currentInterval.getEndTime();
        while (ts != -1L && ts < tEnd) {
            currentInterval = this.querySingleState(++ts, attributeQuark);
            intervals.add(currentInterval);
            ts = currentInterval.getEndTime();
        }
        return intervals;
    }

    @Override
    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2, long resolution) throws TimeRangeException, AttributeNotFoundException {
        if (t2 < t1 || resolution <= 0L) {
            throw new TimeRangeException();
        }
        long tEnd = t2 > this.getCurrentEndTime() ? this.getCurrentEndTime() : t2;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = this.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = t1;
        while (currentInterval.getEndTime() != -1L && ts < tEnd) {
            if (ts > currentInterval.getEndTime()) {
                currentInterval = this.querySingleState(ts, attributeQuark);
                intervals.add(currentInterval);
            }
            ts += resolution;
        }
        if (currentInterval.getEndTime() < tEnd) {
            currentInterval = this.querySingleState(tEnd, attributeQuark);
            intervals.add(currentInterval);
        }
        return intervals;
    }

    private static void logMissingInterval(int attribute, long timestamp) {
        Tracer.traceInfo("No data found in history for attribute " + attribute + " at time " + timestamp + ", returning dummy interval");
    }

    @Override
    public synchronized void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        super.debugPrint(writer);
        this.backend.debugPrint(writer);
    }
}

