/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;

public class RPMProjectCreator {
    private RPMProjectLayout layout;
    private IProject latest;

    public RPMProjectCreator(RPMProjectLayout layout) {
        this.layout = layout;
    }

    public RPMProjectCreator() {
        this(RPMProjectLayout.RPMBUILD);
    }

    public void create(String projectName, IPath projectPath, IProgressMonitor monitor) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName);
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            String parsedIPathString = null;
            if (!Platform.getLocation().equals((Object)projectPath)) {
                parsedIPathString = projectPath.toString().replaceFirst(":/", "://");
                try {
                    description.setLocationURI(new URI(parsedIPathString));
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
                }
            }
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.rpm.core.rpmnature"});
            project.create(description, monitor);
            monitor.worked(10);
            project.open(monitor);
            if (projectPath.toString().indexOf(58) != -1) {
                if (this.layout.equals((Object)RPMProjectLayout.RPMBUILD)) {
                    this.createDirsRemote(monitor, project, parsedIPathString);
                }
            } else if (this.layout.equals((Object)RPMProjectLayout.RPMBUILD)) {
                this.createDirs(monitor, project);
            }
            this.latest = project;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IProject getLatestProject() {
        return this.latest;
    }

    private void createDirs(IProgressMonitor monitor, IProject project) throws CoreException {
        project.getFolder("SPECS").create(true, true, monitor);
        project.getFolder("SOURCES").create(true, true, monitor);
        project.getFolder("BUILD").create(true, true, monitor);
        project.getFolder("RPMS").create(true, true, monitor);
        project.getFolder("SRPMS").create(true, true, monitor);
    }

    private void createDirsRemote(IProgressMonitor monitor, IProject project, String parsedIPathString) throws CoreException {
        IRemoteFileProxy proxy = null;
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(new URI(parsedIPathString));
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
        IFileStore iFileStoreSpecs = proxy.getResource("SPECS");
        iFileStoreSpecs.mkdir(0, monitor);
        project.getFolder("SPECS").create(true, true, monitor);
        IFileStore iFileStoreSources = proxy.getResource("SOURCES");
        iFileStoreSources.mkdir(0, monitor);
        project.getFolder("SOURCES").create(true, true, monitor);
        IFileStore iFileStoreBuild = proxy.getResource("BUILD");
        iFileStoreBuild.mkdir(0, monitor);
        project.getFolder("BUILD").create(true, true, monitor);
        IFileStore iFileStoreRPMs = proxy.getResource("RPMS");
        iFileStoreRPMs.mkdir(0, monitor);
        project.getFolder("RPMS").create(true, true, monitor);
        IFileStore iFileStoreSRPMs = proxy.getResource("SRPMS");
        iFileStoreSRPMs.mkdir(0, monitor);
        project.getFolder("SRPMS").create(true, true, monitor);
    }
}

