/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.rpm.core.IProjectConfiguration;
import org.eclipse.linuxtools.rpm.core.utils.Utils;

public class RPM {
    private List<String> macroDefines;
    private String rpmCmd;

    public RPM(IProjectConfiguration config) {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.core");
        this.rpmCmd = node.get("RPM_CMD", "");
        this.macroDefines = new ArrayList<String>();
        this.macroDefines.add(this.rpmCmd);
        this.macroDefines.add("-v");
        this.macroDefines.addAll(config.getConfigDefines());
    }

    public String install(IFile sourceRPM) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(this.macroDefines);
        command.add("-i");
        command.add(sourceRPM.getLocation().toOSString());
        try {
            return Utils.runCommandToString(command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }
}

