/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.lang.reflect.Method;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class TmfLocation<L extends Comparable<L>>
implements ITmfLocation<L> {
    private L fLocation;

    private TmfLocation() {
        this.fLocation = null;
    }

    public TmfLocation(L location) {
        this.fLocation = location;
    }

    public TmfLocation(TmfLocation<L> location) {
        this.fLocation = location.fLocation;
    }

    @Override
    public L getLocation() {
        return this.fLocation;
    }

    @Override
    public TmfLocation<L> clone() {
        TmfLocation clone = null;
        try {
            clone = (TmfLocation)super.clone();
            if (this.fLocation != null) {
                Class<?> clazz = this.fLocation.getClass();
                Method method = clazz.getMethod("clone", new Class[0]);
                Object copy = method.invoke(this.fLocation, new Object[0]);
                clone.fLocation = (Comparable)copy;
            } else {
                clone.fLocation = null;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
        return clone;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fLocation != null ? this.fLocation.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfLocation other = (TmfLocation)obj;
        return !(this.fLocation == null ? other.fLocation != null : !this.fLocation.equals(other.fLocation));
    }

    public String toString() {
        return "TmfLocation [fLocation=" + this.fLocation + "]";
    }
}

