/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.rpm.core.FlatBuildConfiguration;
import org.eclipse.linuxtools.internal.rpm.core.Messages;
import org.eclipse.linuxtools.internal.rpm.core.RPMBuildConfiguration;
import org.eclipse.linuxtools.internal.rpm.core.SpecfileVisitor;
import org.eclipse.linuxtools.internal.rpm.core.utils.FileDownloadJob;
import org.eclipse.linuxtools.internal.rpm.core.utils.RPM;
import org.eclipse.linuxtools.internal.rpm.core.utils.RPMBuild;
import org.eclipse.linuxtools.rpm.core.IProjectConfiguration;
import org.eclipse.linuxtools.rpm.core.IRPMConstants;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;
import org.eclipse.linuxtools.rpm.core.RPMProjectNature;

public class RPMProject {
    private IProject project;
    private IProjectConfiguration rpmConfig;

    public RPMProject(IProject project, RPMProjectLayout projectLayout) throws CoreException {
        this.project = project;
        switch (projectLayout) {
            case FLAT: {
                this.rpmConfig = new FlatBuildConfiguration(this.project);
                break;
            }
            default: {
                this.rpmConfig = new RPMBuildConfiguration(this.project);
            }
        }
    }

    public IProjectConfiguration getConfiguration() {
        return this.rpmConfig;
    }

    public IResource getSpecFile() {
        IContainer specsFolder = this.getConfiguration().getSpecsFolder();
        IResource file = null;
        SpecfileVisitor specVisitor = new SpecfileVisitor();
        try {
            specsFolder.accept((IResourceVisitor)specVisitor);
            ArrayList<IResource> installedSpecs = specVisitor.getSpecFiles();
            file = (IResource)installedSpecs.get(0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file;
    }

    public void importSourceRPM(File externalFile) throws CoreException {
        IFile srpmFile = this.getConfiguration().getSrpmsFolder().getFile((IPath)new Path(externalFile.getName()));
        try {
            srpmFile.create((InputStream)new FileInputStream(externalFile), false, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String throw_message = String.valueOf(Messages.getString("RPMCore.Error_trying_to_copy__")) + this.rpmConfig.getSpecsFolder().getLocation().toOSString();
            Status error = new Status(4, IRPMConstants.ERROR, 1, throw_message, null);
            throw new CoreException((IStatus)error);
        }
        RPM rpm = new RPM(this.getConfiguration());
        rpm.install(srpmFile);
        this.project.refreshLocal(2, null);
        RPMProjectNature.addRPMNature(this.project, null);
    }

    public void importSourceRPM(URL remoteFile, IProgressMonitor monitor) throws CoreException {
        URLConnection content;
        try {
            content = remoteFile.openConnection();
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        File tempFile = new File(System.getProperty("java.io.tmpdir"), remoteFile.toString().substring(remoteFile.toString().lastIndexOf(47) + 1));
        if (tempFile.exists()) {
            tempFile.delete();
        }
        FileDownloadJob downloadJob = new FileDownloadJob(tempFile, content);
        downloadJob.run(monitor);
        this.importSourceRPM(tempFile);
    }

    public int buildAll(OutputStream outStream) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        int result = rpmbuild.buildAll(this.getSpecFile(), outStream);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
        this.getConfiguration().getRpmsFolder().refreshLocal(2, null);
        this.getConfiguration().getSrpmsFolder().refreshLocal(2, null);
        return result;
    }

    public int buildBinaryRPM(OutputStream out) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        int result = rpmbuild.buildBinary(this.getSpecFile(), out);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
        this.getConfiguration().getRpmsFolder().refreshLocal(2, null);
        return result;
    }

    public int buildSourceRPM(OutputStream out) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        int result = rpmbuild.buildSource(this.getSpecFile(), out);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
        this.getConfiguration().getSrpmsFolder().refreshLocal(2, null);
        return result;
    }

    public void buildPrep(OutputStream out) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        rpmbuild.buildPrep(this.getSpecFile(), out);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
    }
}

