/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.linuxtools.internal.lttng.jni.common.Jni_C_Pointer;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.lttng.jni.JniMarkerField;
import org.eclipse.linuxtools.lttng.jni.Jni_C_Common;
import org.eclipse.linuxtools.lttng.jni.ParsedObjectContent;

public abstract class JniParser
extends Jni_C_Common {
    private static ParsedObjectContent parsedData = new ParsedObjectContent();

    protected static native void ltt_getParsedData(int var0, ParsedObjectContent var1, long var2, long var4);

    protected JniParser() {
    }

    public static Object parseField(JniEvent eventToParse, int fieldPosition) {
        if (fieldPosition < 0 || fieldPosition >= eventToParse.requestEventMarker().getMarkerFieldsArrayList().size()) {
            return null;
        }
        JniMarkerField tmpField = eventToParse.requestEventMarker().getMarkerFieldsArrayList().get(fieldPosition);
        JniParser.ltt_getParsedData(eventToParse.getEventPtr().getLibraryId(), parsedData, eventToParse.getEventPtr().getPointer(), tmpField.getMarkerFieldPtr().getPointer());
        return parsedData.getData();
    }

    public static Object parseField(JniEvent eventToParse, String fieldName) {
        JniMarkerField tmpField = eventToParse.requestEventMarker().getMarkerFieldsHashMap().get(fieldName);
        if (tmpField == null) {
            return null;
        }
        JniParser.ltt_getParsedData(eventToParse.getEventPtr().getLibraryId(), parsedData, eventToParse.getEventPtr().getPointer(), tmpField.getMarkerFieldPtr().getPointer());
        return parsedData.getData();
    }

    public static HashMap<String, Object> parseAllFields(JniEvent eventToParse) {
        HashMap<String, JniMarkerField> markerFieldData = eventToParse.requestEventMarker().getMarkerFieldsHashMap();
        HashMap<String, Object> parsedDataMap = new HashMap<String, Object>(markerFieldData);
        JniMarkerField newMarkerField = null;
        Iterator<String> iterator = markerFieldData.keySet().iterator();
        while (iterator.hasNext()) {
            newMarkerField = markerFieldData.get(iterator.next());
            JniParser.ltt_getParsedData(eventToParse.getEventPtr().getLibraryId(), parsedData, eventToParse.getEventPtr().getPointer(), newMarkerField.getMarkerFieldPtr().getPointer());
            parsedDataMap.put(newMarkerField.getField(), parsedData.getData());
        }
        return parsedDataMap;
    }

    private static void addStringToParsingFromC(Object contentHolder, String stringToAdd) {
        ((ParsedObjectContent)contentHolder).setData(stringToAdd);
    }

    private static void addLongPointerToParsingFromC(Object contentHolder, long pointerToAdd) {
        ((ParsedObjectContent)contentHolder).setData(new Jni_C_Pointer(pointerToAdd));
    }

    private static void addIntPointerToParsingFromC(Object contentHolder, long pointerToAdd) {
        ((ParsedObjectContent)contentHolder).setData(new Jni_C_Pointer((int)pointerToAdd));
    }

    private static void addShortToParsingFromC(Object contentHolder, short shortToAdd) {
        ((ParsedObjectContent)contentHolder).setData(shortToAdd);
    }

    private static void addIntegerToParsingFromC(Object contentHolder, int intToAdd) {
        ((ParsedObjectContent)contentHolder).setData(intToAdd);
    }

    private static void addLongToParsingFromC(Object contentHolder, long longToAdd) {
        ((ParsedObjectContent)contentHolder).setData(longToAdd);
    }

    private static void addFloatToParsingFromC(Object contentHolder, float floatToAdd) {
        ((ParsedObjectContent)contentHolder).setData(new Float(floatToAdd));
    }

    private static void addDoubleToParsingFromC(Object contentHolder, double doubleToAdd) {
        ((ParsedObjectContent)contentHolder).setData(new Double(doubleToAdd));
    }
}

