/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;

public class StructDeclaration
implements IDeclaration {
    private final HashMap<String, IDeclaration> fields = new HashMap();
    private final List<String> fieldsList = new LinkedList<String>();
    private long maxAlign;

    public StructDeclaration(long align) {
        this.maxAlign = Math.max(align, 1L);
    }

    public long getMaxAlign() {
        return this.maxAlign;
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public HashMap<String, IDeclaration> getFields() {
        return this.fields;
    }

    public List<String> getFieldsList() {
        return this.fieldsList;
    }

    @Override
    public long getAlignment() {
        return this.maxAlign;
    }

    @Override
    public StructDefinition createDefinition(IDefinitionScope definitionScope, String fieldName) {
        return new StructDefinition(this, definitionScope, fieldName);
    }

    public void addField(String name, IDeclaration declaration) {
        this.fields.put(name, declaration);
        this.fieldsList.add(name);
        this.maxAlign = Math.max(this.maxAlign, declaration.getAlignment());
        if (this.maxAlign == 1L) {
            this.maxAlign = 1L;
        }
    }

    public String toString() {
        return "[declaration] struct[" + Integer.toHexString(this.hashCode()) + ']';
    }
}

