/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.perf.model;

import org.eclipse.linuxtools.perf.model.PMFile;
import org.eclipse.linuxtools.perf.model.PMLineRef;
import org.eclipse.linuxtools.perf.model.TreeParent;

public class PMSymbol
extends TreeParent {
    private Double samples;
    private boolean pathConflictFound = false;

    public String getFunctionName() {
        int argloc;
        String tmpName = this.name;
        if (tmpName.startsWith("[")) {
            tmpName = tmpName.substring(4);
        }
        if ((argloc = tmpName.indexOf("(")) != -1) {
            tmpName = tmpName.substring(0, argloc);
        }
        return tmpName;
    }

    public PMSymbol(String symbolName, Double samples2, float pc) {
        super(symbolName);
        this.samples = samples2;
        this.percent = pc;
    }

    @Override
    public void addChild(TreeParent child) {
        float tmp = this.percent;
        super.addChild(child);
        this.percent = tmp;
    }

    public void addPercent(Integer lineNum, Float percent) {
        PMLineRef current = (PMLineRef)this.getChild(lineNum.toString());
        if (current == null) {
            current = new PMLineRef(lineNum, percent.floatValue());
            this.addChild(current);
        } else {
            current.addPercent(percent);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.percent) + "% in " + this.name + " (" + this.samples + " samples)" + (this.pathConflictFound ? "(Warning multiple paths found for this symbol!)" : "");
    }

    public PMFile getFile() {
        if (!(super.getParent() instanceof PMFile)) {
            return null;
        }
        return (PMFile)super.getParent();
    }

    public void markConflict() {
        this.pathConflictFound = true;
    }

    public boolean conflicted() {
        return this.pathConflictFound;
    }
}

