/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency.model;

import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.latency.analyzer.EventMatcher;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.model.LatencyController;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;

public class LatencyEventRequest
extends TmfEventRequest<LttngEvent> {
    private final LatencyController fController;

    public LatencyEventRequest(LatencyController controller, TmfTimeRange range, int rank, int nbEvents, ITmfDataRequest.ExecutionType execType) {
        super(LttngEvent.class, range, rank, nbEvents, 50000, execType);
        this.fController = controller;
        EventMatcher.getInstance().clearStack();
    }

    public LatencyEventRequest(LatencyController controller, TmfTimeRange range, ITmfDataRequest.ExecutionType execType) {
        this(controller, range, 0, Integer.MAX_VALUE, execType);
    }

    public LatencyEventRequest(LatencyController controller, TmfTimeRange range, int rank, ITmfDataRequest.ExecutionType execType) {
        this(controller, range, rank, Integer.MAX_VALUE, execType);
    }

    public void handleData(LttngEvent event) {
        super.handleData((ITmfEvent)event);
        LttngEvent startEvent = EventMatcher.getInstance().process(event);
        if (startEvent != null) {
            long latency = event.getTimestamp().getValue() - startEvent.getTimestamp().getValue();
            this.fController.handleData(this.getNbRead(), startEvent.getTimestamp().getValue(), latency);
        }
    }

    public void handleCompleted() {
        this.fController.handleCompleted();
        super.handleCompleted();
    }

    public void handleCancel() {
        EventMatcher.getInstance().clearStack();
        this.fController.handleCancel();
        super.handleCancel();
    }
}

