/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.project.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.linuxtools.internal.lttng.core.TraceHelper;
import org.eclipse.linuxtools.internal.lttng.ui.project.dialogs.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.project.dialogs.TraceLibraryPathWizardPage;
import org.eclipse.linuxtools.tmf.ui.project.wizards.NewTmfProjectWizard;

public class NewLTTngProjectWizard
extends NewTmfProjectWizard {
    private static final String TRACE_LIBRARY_PATH = "traceLibraryPath";
    private TraceLibraryPathWizardPage traceLibraryPathPage;

    public NewLTTngProjectWizard() {
        this(Messages.NewProjectWizard_Title, Messages.NewProjectWizard_Description);
    }

    public NewLTTngProjectWizard(String title, String desc) {
        super(title, desc);
    }

    public void addPages() {
        super.addPages();
        this.traceLibraryPathPage = new TraceLibraryPathWizardPage(Messages.NewProjectWizard_Title);
        this.traceLibraryPathPage.setTitle(Messages.TraceLibraryPathWizardPage_Title);
        this.traceLibraryPathPage.setDescription(Messages.TraceLibraryPathWizardPage_Description);
        this.addPage((IWizardPage)this.traceLibraryPathPage);
    }

    public boolean performFinish() {
        super.performFinish();
        try {
            IProjectDescription description = this.fProject.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature", "org.eclipse.linuxtools.internal.lttng.LTTngProjectNature"});
            this.fProject.setDescription(description, null);
        }
        catch (CoreException coreException) {}
        String traceLibraryPath = this.traceLibraryPathPage.getPath();
        if (traceLibraryPath != null) {
            return TraceHelper.setProjectPreference((IProject)this.fProject, (String)TRACE_LIBRARY_PATH, (String)traceLibraryPath);
        }
        return true;
    }

    public IProject getProject() {
        return this.fProject;
    }
}

