/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.UUID;

public class Utils {
    public static final int CTF_MAGIC = -1040441407;
    public static final int TSDL_MAGIC = 1976638807;
    public static final int TSDL_MAGIC_LEN = 4;
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final int UUID_LEN = 16;

    public static int unsignedCompare(long a, long b) {
        boolean bLeftBit;
        boolean aLeftBit = (a & Integer.MIN_VALUE) != 0L;
        boolean bl = bLeftBit = (b & Integer.MIN_VALUE) != 0L;
        if (aLeftBit && !bLeftBit) {
            return 1;
        }
        if (!aLeftBit && bLeftBit) {
            return -1;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static UUID makeUUID(byte[] bytes) {
        long high = 0L;
        long low = 0L;
        assert (bytes.length == 16);
        int i = 0;
        while (i < 8) {
            low = low << 8 | (long)(bytes[i + 8] & 0xFF);
            high = high << 8 | (long)(bytes[i] & 0xFF);
            ++i;
        }
        UUID uuid = new UUID(high, low);
        return uuid;
    }
}

