/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.event;

import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventReference;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;

public class TmfTraceEvent
extends TmfEvent {
    private final String fSourcePath;
    private final String fFileName;
    private final int fLineNumber;

    public TmfTraceEvent(TmfTimestamp originalTS, TmfTimestamp effectiveTS, TmfEventSource source, TmfEventType type, TmfEventReference reference, String path, String file, int line) {
        super(originalTS, effectiveTS, source, type, reference);
        this.fSourcePath = path;
        this.fFileName = file;
        this.fLineNumber = line;
    }

    public TmfTraceEvent(TmfTimestamp timestamp, TmfEventSource source, TmfEventType type, TmfEventReference reference, String path, String file, int line) {
        super(timestamp, source, type, reference);
        this.fSourcePath = path;
        this.fFileName = file;
        this.fLineNumber = line;
    }

    public TmfTraceEvent(TmfTraceEvent other) {
        super(other);
        this.fSourcePath = other.fSourcePath;
        this.fFileName = other.fFileName;
        this.fLineNumber = other.fLineNumber;
    }

    public String getSourcePath() {
        return this.fSourcePath;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.fSourcePath != null ? this.fSourcePath.hashCode() : 0);
        result = 37 * result + (this.fFileName != null ? this.fFileName.hashCode() : 0);
        result = 37 * result + this.fLineNumber;
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfEvent) {
            return super.equals(other);
        }
        if (!(other instanceof TmfTraceEvent)) {
            return false;
        }
        TmfTraceEvent o = (TmfTraceEvent)other;
        return super.equals(o) && this.fSourcePath.equals(o.fSourcePath) && this.fFileName.equals(o.fFileName) && this.fLineNumber == o.fLineNumber;
    }

    @Override
    public String toString() {
        return "[TmfTraceEvent(" + this.fSourcePath + "," + this.fFileName + "," + this.fLineNumber + ")]";
    }
}

