/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.views.project.TmfProjectNature;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectTreeNode;

public class TmfProjectRoot
extends TmfProjectTreeNode {
    private final ProjectView fView;

    public TmfProjectRoot(ProjectView view) {
        super(null);
        this.fView = view;
        this.refreshChildren();
    }

    @Override
    public void refresh() {
        this.fView.refresh();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void refreshChildren() {
        IProject[] projects;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.isOpen() || this.isTmfProject(project)) {
                TmfProjectNode node = this.find(project.getName());
                if (node == null) {
                    node = new TmfProjectNode(this, project);
                    this.fChildren.add(node);
                } else {
                    node.updateState();
                }
            }
            ++n2;
        }
        ArrayList<ITmfProjectTreeNode> toRemove = new ArrayList<ITmfProjectTreeNode>();
        for (ITmfProjectTreeNode node : this.fChildren) {
            if (this.exists(node.getName(), projects)) {
                node.refreshChildren();
                continue;
            }
            toRemove.add(node);
        }
        for (ITmfProjectTreeNode node : toRemove) {
            this.fChildren.remove(node);
        }
    }

    private TmfProjectNode find(String name) {
        for (ITmfProjectTreeNode node : this.fChildren) {
            if (!(node instanceof TmfProjectNode) || !node.getName().equals(name)) continue;
            return (TmfProjectNode)node;
        }
        return null;
    }

    private boolean exists(String name, IProject[] projects) {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(name) && (!project.isOpen() || this.isTmfProject(project))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isTmfProject(IProject project) {
        if (project.isOpen()) {
            try {
                IProjectNature nature = project.getNature("org.eclipse.linuxtools.tmf.project.nature");
                if (nature instanceof TmfProjectNature) {
                    return true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

