/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.views.project.dialogs.NewProjectWizard;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectRoot;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class NewProjectHandler
extends AbstractHandler {
    private TmfProjectRoot fProjectRoot = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPart part = window.getActivePage().getActivePart();
        if (!(part instanceof ProjectView)) {
            return false;
        }
        this.fProjectRoot = ((ProjectView)part).getRoot();
        return this.fProjectRoot != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NewProjectWizard wizard = new NewProjectWizard();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (project = wizard.getProject()) != null && this.fProjectRoot != null) {
            IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.linuxtools.tmf.ui");
            node.put("ACTIVE_PROJECT", project.getName());
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            this.fProjectRoot.refreshChildren();
            this.fProjectRoot.refresh();
        }
        return null;
    }
}

