/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.views.project.dialogs.NewExperimentDialog;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentFolderNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewExperimentHandler
extends AbstractHandler {
    private TmfProjectNode fProject = null;

    public boolean isEnabled() {
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof ProjectView)) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.tmf.ui.views.project");
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfProjectTreeNode) {
            ITmfProjectTreeNode node = (ITmfProjectTreeNode)element;
            while (node != null && !(node instanceof TmfProjectNode)) {
                node = node.getParent();
            }
            TmfProjectNode tmfProjectNode = this.fProject = node instanceof TmfProjectNode ? (TmfProjectNode)node : null;
        }
        return this.fProject != null && this.fProject.isOpen() && this.fProject.isTmfProject();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] experiments;
        TmfExperimentFolderNode experimentFolder = this.fProject.getExperimentsFolder();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NewExperimentDialog dialog = new NewExperimentDialog(shell, experimentFolder);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (experiments = dialog.getResult())[0] instanceof IFolder) {
            experimentFolder.addExperiment((IFolder)experiments[0]);
        }
        return null;
    }
}

