/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.launch.configuration;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.oprofile.core.Oprofile;
import org.eclipse.linuxtools.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.oprofile.core.daemon.OpUnitMask;
import org.eclipse.linuxtools.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.oprofile.launch.OprofileLaunchPlugin;

public class OprofileCounter {
    private static final String COUNTER_STRING = OprofileLaunchMessages.getString("oprofileCounter.counterString");
    private int _number;
    private boolean _enabled;
    private OprofileDaemonEvent _daemonEvent;
    private OpEvent[] _eventList = null;

    public OprofileCounter(int nr) {
        this._number = nr;
        this._enabled = false;
        this._eventList = Oprofile.getEvents((int)this._number);
        this._daemonEvent = new OprofileDaemonEvent();
    }

    public static OprofileCounter[] getCounters(ILaunchConfiguration config) {
        OprofileCounter[] ctrs = new OprofileCounter[Oprofile.getNumberOfCounters()];
        int i = 0;
        while (i < ctrs.length) {
            ctrs[i] = new OprofileCounter(i);
            if (config != null) {
                ctrs[i].loadConfiguration(config);
            }
            ++i;
        }
        return ctrs;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setEvent(OpEvent event) {
        this._daemonEvent.setEvent(event);
    }

    public void setProfileKernel(boolean profileKernel) {
        this._daemonEvent.setProfileKernel(profileKernel);
    }

    public void setProfileUser(boolean profileUser) {
        this._daemonEvent.setProfileUser(profileUser);
    }

    public void setCount(int count) {
        this._daemonEvent.setResetCount(count);
    }

    public void saveConfiguration(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_ENABLED(this._number), this._enabled);
        if (this._daemonEvent.getEvent() != null) {
            config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_EVENT(this._number), this._daemonEvent.getEvent().getText());
            config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_UNIT_MASK(this._number), this._daemonEvent.getEvent().getUnitMask().getMaskValue());
        }
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_KERNEL(this._number), this._daemonEvent.getProfileKernel());
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_USER(this._number), this._daemonEvent.getProfileUser());
        config.setAttribute(OprofileLaunchPlugin.ATTR_COUNTER_COUNT(this._number), this._daemonEvent.getResetCount());
    }

    public void loadConfiguration(ILaunchConfiguration config) {
        try {
            this._enabled = config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_ENABLED(this._number), false);
            String str = config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_EVENT(this._number), "");
            this._daemonEvent.setEvent(this._eventFromString(str));
            if (this._daemonEvent.getEvent() == null) {
                return;
            }
            int maskValue = config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_UNIT_MASK(this._number), -1);
            this._daemonEvent.getEvent().getUnitMask().setMaskValue(maskValue);
            this._daemonEvent.setProfileKernel(config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_KERNEL(this._number), false));
            this._daemonEvent.setProfileUser(config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_PROFILE_USER(this._number), false));
            this._daemonEvent.setResetCount(config.getAttribute(OprofileLaunchPlugin.ATTR_COUNTER_COUNT(this._number), 0));
        }
        catch (CoreException coreException) {}
    }

    public OpUnitMask getUnitMask() {
        OpEvent event = this._daemonEvent.getEvent();
        if (event != null) {
            return event.getUnitMask();
        }
        return null;
    }

    public String getText() {
        Object[] args = new Object[]{new Integer(this._number)};
        return MessageFormat.format(COUNTER_STRING, args);
    }

    public int getNumber() {
        return this._number;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public OpEvent getEvent() {
        return this._daemonEvent.getEvent();
    }

    public boolean getProfileKernel() {
        return this._daemonEvent.getProfileKernel();
    }

    public boolean getProfileUser() {
        return this._daemonEvent.getProfileUser();
    }

    public int getCount() {
        return this._daemonEvent.getResetCount();
    }

    public OpEvent[] getValidEvents() {
        return this._eventList;
    }

    public OprofileDaemonEvent getDaemonEvent() {
        return this._daemonEvent;
    }

    private OpEvent _eventFromString(String str) {
        int i = 0;
        while (i < this._eventList.length) {
            if (this._eventList[i].getText().equals(str)) {
                return this._eventList[i];
            }
            ++i;
        }
        return null;
    }
}

